package com.ericsson.cms.contractmgmt.client.tab.copyrightholder;



import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;

import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;

import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;

import com.ericsson.cms.contractmgmt.client.tab.copyrightholder.CopyrightHolderDataProvider.IBusyNotifier;

import com.google.gwt.core.client.GWT;

import com.google.gwt.user.client.ui.Composite;

import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;

import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;



/**

 * Table that shows the list of copyright holders.

 * 

 * @author Daniel Paranhos

 * 

 */

public class CopyrightHolderListPanel extends Composite {



    // table related

    private CopyrightHolderDataProvider dataProvider;

    private PageFeature pageFeature;

    private SortFeatureImpl<Long, UiCopyrightHolderRecord> sortFeature;

    private CopyrightHolderDetailFeature detailFeature;

    private BookmarkFeature bookmarkFeature;

    private AnchorChangeListener anchorChangeListener;



    // widgets used in this view

    private VerticalContainer mainContainer;

    private Table<Long, UiCopyrightHolderRecord> table;

    private BusyIndicator busyIndicator = new BusyIndicator();



    private HeaderPanel header;

    private final SuccessPanel successPanel = new SuccessPanel();

    private final ErrorPanel errorPanel = new ErrorPanel();



    private ContractComponentConstants constants = (ContractComponentConstants) GWT

            .create( ContractComponentConstants.class );



    // spacing between the table and message panel

    private static final int SPACING = 2;

    private static final String STYLE_NAME = "content-ContractPanel";



    public CopyrightHolderListPanel() {

        this.dataProvider = new CopyrightHolderDataProvider( this );

        dataProvider.setBusyNotifier( new IBusyNotifier() {

            @Override

            public void startingToBeBusy() {

                busyIndicator.center();

            }



            @Override

            public void doneBeingBusy() {

                busyIndicator.hide();

            }

        } );

        init();

    }



    private void init() {

        initWidgets();

        setContainers();

    }



    public SuccessPanel getSuccessPanel() {

        return successPanel;

    }



    public ErrorPanel getErrorPanel() {

        return errorPanel;

    }



    private void setContainers() {

        mainContainer.add( header );

        mainContainer.add( successPanel );

        mainContainer.add( errorPanel );

        mainContainer.add( table );

    }



    private void initWidgets() {

        mainContainer = new VerticalContainer();

        mainContainer.setSpacing( SPACING );

        mainContainer.setStylePrimaryName( STYLE_NAME );

        this.initWidget( mainContainer );



        header = new HeaderPanel( "" );



        table = new Table<Long, UiCopyrightHolderRecord>( dataProvider );

        table.addTableViewChangeHandler( new TableViewChangeHandler<Long, UiCopyrightHolderRecord>() {

            @Override

            public void onShowDetailView( TableDetailViewEvent<Long, UiCopyrightHolderRecord> event ) {

                if ( event.isCreateView() ) {

                    header.setLabel( constants.copyrightHolderCreateHeading() );

                } else {

                    header.setLabel( constants.copyrightHolderViewEditHeading() + " "

                            + event.getRecord().getCopyrightHolder().getName() );

                }

            }



            @Override

            public void onShowListView( TableViewEvent event ) {

                header.setLabel( constants.copyrightHolderListHeading() );

            }

        } );



        // page feature

        pageFeature = new PageFeatureImpl();

        dataProvider.setParentPageFeature( pageFeature );



        // sort feature

        sortFeature = new SortFeatureImpl<Long, UiCopyrightHolderRecord>(

                dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING );

        for ( Column<?, UiCopyrightHolderRecord> col : dataProvider.getSortColumns() ) {

            sortFeature.addSortableColumn( col );

        }

        dataProvider.setParentSortFeature( sortFeature );

        

        // bookmark feature

        bookmarkFeature = new BookmarkFeatureImpl();



        // detail feature

        detailFeature = new CopyrightHolderDetailFeature( this );



        table.addSortFeature( sortFeature );

        table.addPageFeature( pageFeature );

        table.addDetailFeature( detailFeature );

        table.addBookmarkFeature(bookmarkFeature);



        table.initialize( new NeptuneAsyncCallback<Void>() {

            @Override

            public void onNeptuneFailure( Throwable caught ) {

            }



            @Override

            public void onNeptuneSuccess( Void result ) {

            }

        } );



        anchorChangeListener = new CopyrightHolderAnchorChangeListener( this );

    }



    public Table<Long, UiCopyrightHolderRecord> getCopyrightHolderTable() {

        return this.table;

    }



    public AnchorChangeListener getAnchorChangeListener() {

        return this.anchorChangeListener;

    }



    /**

     * @param reverseAnchorChangeListener

     *            the reverseAnchorChangeListener to set

     */

    public void setReverseAnchorChangeListener( AnchorChangeListener reverseAnchorChangeListener ) {

        table.setAnchorChangeNotifier( reverseAnchorChangeListener );

    }



    public void clearMessages() {

        this.successPanel.reset();

        this.errorPanel.reset();

    }

}

