package com.ericsson.cms.contractmgmt.client.tab.deal;

import com.ericsson.cms.contractmgmt.client.model.UiContract;
import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class DealAnchorChangeListener implements AnchorChangeListener {

    // constants in the url e.g. ?dealId=1
    private static final String DEAL_ID = "dealId";
    private static final String CONTRACT_ID = "contractId";
    private static final String PARAMETER_DELIMITER = "&";
    private static final String VALUE_DELIMITER = "=";
    private final DealListPanel widget;

    public DealAnchorChangeListener( DealListPanel listPanel ) {
        this.widget = listPanel;
    }

    @Override
    public void anchorChanged( String anchor ) {
        long dealId = 0L;
        long contractId = 0L;
        
        /* Check for anchor with title list id */
        if ( anchor != null && anchor.contains( DEAL_ID ) ) {
            widget.getDealTable().reset();

            // skip the first char
            anchor = anchor.substring( 5 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( DEAL_ID ) ) {
                	dealId = Long.parseLong( paramValue[1] );
                } 
            }
            
            IContractManagerServiceAsync cmService = GWT.create( IContractManagerService.class );
            cmService.getDeal(dealId, new NeptuneAsyncCallback<UiDeal>() {

				@Override
				public void onNeptuneFailure(Throwable caught) {
					 Window.alert( caught.getLocalizedMessage() );
				}

				@Override
				public void onNeptuneSuccess(UiDeal result) {
					widget.getDealTable().showDetailView(new UiDealRecord(result));	
				}	
			
            } );
        } else if (anchor != null && !anchor.contains( DEAL_ID ) && anchor.contains(CONTRACT_ID)) {
            widget.getDealTable().reset();

            // skip the first char
            anchor = anchor.substring( 7 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( CONTRACT_ID ) ) {
                    contractId = Long.parseLong( paramValue[1] );
                }
            }
            
            final UiDeal uiDeal = new UiDeal();
            
            IContractManagerServiceAsync cmService = GWT.create( IContractManagerService.class );
            
            cmService.getContract(contractId, new NeptuneAsyncCallback<UiContract>() {

                @Override
                public void onNeptuneFailure(Throwable caught) {
                    Window.alert( caught.getLocalizedMessage() );
                }

                @Override
                public void onNeptuneSuccess(UiContract result) {
                    uiDeal.setName("");
                    uiDeal.setContract(result);
                    widget.getDealTable().showDetailView(new UiDealRecord(uiDeal)); 
                }
            });
            
        } else {
            widget.clearMessages();
            widget.getDealTable().setAnchor( anchor );
        }
    }
}
