package com.ericsson.cms.contractmgmt.client.tab.deal;



import java.util.ArrayList;

import java.util.Collection;

import java.util.HashMap;

import java.util.List;

import java.util.Map;

import java.util.Map.Entry;

import java.util.Set;



import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;

import com.ericsson.cms.contractmgmt.client.Permissions;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldValidator;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;

import com.ericsson.cms.contractmgmt.client.document.DocumentComponentFactory;

import com.ericsson.cms.contractmgmt.client.model.UiContactType;

import com.ericsson.cms.contractmgmt.client.model.UiContract;

import com.ericsson.cms.contractmgmt.client.model.UiDeal;

import com.ericsson.cms.contractmgmt.client.model.UiDealType;

import com.ericsson.cms.contractmgmt.client.model.UiDocument;

import com.ericsson.cms.contractmgmt.client.model.UiDocumentType;

import com.ericsson.cms.contractmgmt.client.model.UiKeyName;

import com.ericsson.cms.contractmgmt.client.model.UiLicense;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;

import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;

import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;

import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;

import com.ericsson.cms.contractmgmt.client.tab.config.PositiveIntegerConverter;

import com.ericsson.cms.contractmgmt.client.tab.contacts.ContactListPanel;

import com.ericsson.cms.contractmgmt.client.tab.license.UiLicenseRecord;

import com.google.gwt.core.client.GWT;

import com.google.gwt.event.dom.client.ClickEvent;

import com.google.gwt.event.dom.client.ClickHandler;

import com.google.gwt.event.logical.shared.ValueChangeEvent;

import com.google.gwt.event.logical.shared.ValueChangeHandler;

import com.google.gwt.i18n.client.DateTimeFormat;

import com.google.gwt.user.client.History;

import com.google.gwt.user.client.Window;

import com.google.gwt.user.client.ui.Composite;

import com.google.gwt.user.client.ui.FormPanel;

import com.google.gwt.user.client.ui.HasHorizontalAlignment;

import com.google.gwt.user.client.ui.Widget;

import com.google.gwt.user.datepicker.client.CalendarUtil;

import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;

import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;

import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;



public class DealDetailView extends Composite implements DetailView<Long, UiDealRecord> {



    private static final String STYLE_DISCLOSURE_CONTAINER = "content-FileView-disclosureContainer";

    private static final String ROW_HEADER_STYLE = "contract-PlatformTable-row-header";

    private static final String TABLE_STYLE = "contract-PlatformTable";

    private static final String ROW_BODY_STYLE = "contract-PlatformTable-row-body";

    private static final String ROW_STYLE = "contract-PlatformTable-row";

    private static final String CELL_STYLE = "contract-PlatformTable-cell";

    private static final String CELL_HEADER_STYLE = "contract-PlatformTable-cell-header";

    private static final String LINK_BEHAVIOUR = "contract-Link";





    private static final String CONTENT_LISTBOX_WIDTH =  "130px";

    private static final String TEXTBOXWIDGET_WIDTH = "150px";

    private static final String DATE_BOX_WIDTH = "75px";

    private static final int DEAL_NAME_MAX_LENGH = 50;

    private static final int EXTERNAL_ID_MAX_LENGTH = 100;



    private final ContractComponentConstants constants = (ContractComponentConstants) GWT

            .create(ContractComponentConstants.class);



    private final ContractComponentMessages messages = (ContractComponentMessages) GWT

            .create(ContractComponentMessages.class);



    private final IContractManagerServiceAsync contractManagerService = GWT.create( IContractManagerService.class );

    private final IContractManagerDropDownServiceAsync dropDownService = GWT.create(IContractManagerDropDownService.class);



    private final Map<DataTypeWidget<?>, UiUserDefinedField> widgetCustomFieldMap = new HashMap<DataTypeWidget<?>, UiUserDefinedField>();



    private final UiDealRecord record;

    private final DetailViewCallback<Long, UiDealRecord> callback;

    private final VerticalContainer mainContainer;

    private FormContainer licenseContainer;

    private final ContractFormContainer formUserDefinedFields;



    private DisclosureContainer licenseDisclosureContainer;



    private final ContractFormContainer formContainer;



    private ButtonWidget removeButton;

    private ButtonWidget addButton;

    private ButtonWidget saveButton;

    private ButtonWidget cancelButton;

    private CheckBoxWidget check;



    private TypedListBoxWidget<Long> copyrightHolder;

    private TypedListBoxWidget<Long> contract;

    private final TypedListBoxWidget<Long> type;



    private TypedTextBoxWidget<String> externalIdTextBox;

    private TextBoxWidget name;

    private TypedTextBoxWidget<Integer> expiryReminder;



    private final TypedDateBoxWidget dealCreationDate = new TypedDateBoxWidget( new DateConverter(

            constants.dateFormat(), constants.dateFormat() ) );;

            private final TypedDateBoxWidget dealEffectiveDate = new TypedDateBoxWidget( new DateConverter(

                    constants.dateFormat(), constants.dateFormat() ) );;

                    private final TypedDateBoxWidget dealExpiryDate = new TypedDateBoxWidget( new DateConverter(

                            constants.dateFormat(), constants.dateFormat() ) );;



                            private FlexTableContainer tableLicense;



                            private final SuccessPanel successPanel = new SuccessPanel();

                            private final ErrorPanel errorPanel = new ErrorPanel();



                            private final HorizontalContainer buttonsContainer;



                            private final ContactListPanel contactListPanel = new ContactListPanel();



                            private List<UiDocument> documentsList = new ArrayList<UiDocument>();

                            private final List<UiUserDefinedFieldValue> userDefinedFieldValueList = new ArrayList<UiUserDefinedFieldValue>();



                            private FormPanel form = new FormPanel();



                            private final BusyIndicator busyIndicator = new BusyIndicator();



                            private DocumentComponentFactory documentComponent;



                            private UiContract uiContract;





                            public DealDetailView( UiDealRecord record,

                                    DetailViewCallback<Long, UiDealRecord> callback ) {

                                this.record = record;

                                this.callback = callback;

                                busyIndicator.center();

                                mainContainer = new VerticalContainer();

                                mainContainer.add( successPanel );

                                mainContainer.add( errorPanel );



                                initWidget( mainContainer );

                                buttonsContainer = new HorizontalContainer();

                                formContainer = new ContractFormContainer( HasHorizontalAlignment.ALIGN_LEFT);

                                formUserDefinedFields = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);

                                getCustomFields(record.getKey());

                                if(record.getKey() != null){

                                    getContract(record.getDeal().getContract().getKey());

                                }

                                type = getTypeListBox(0L);

                            }



                            private void getLicense(){

                                if(record.getKey() != null){

                                    contractManagerService.getDealsLicenseList(record.getDeal().getKey(), new NeptuneAsyncCallback<List<UiLicense>>() {



                                        @Override

                                        public void onNeptuneFailure(Throwable caught) {

                                            errorPanel.showMessage(caught.getLocalizedMessage());

                                        }



                                        @Override

                                        public void onNeptuneSuccess(List<UiLicense> result) {

                                            record.getDeal().setUiLicenseList(result);

                                            fillLicenseTable(result);

                                        }



                                    });

                                }

                            }



                            private void fillLicenseTable(List<UiLicense> result) {

                                for(UiLicense license: result){

                                    addRowLicense(license);

                                }

                            }



                            private void addRowLicense(UiLicense license){



                                insertRow();

                                int row = getRow();



                                tableLicense.getRowFormatter().setStyleName(row, TableConstants.STYLE_DATA_EVEN_ROW);



                                DateTimeFormat format = DateTimeFormat.getFormat(constants.dateFormat());



                                CheckBoxWidget checkBox = new CheckBoxWidget();

                                tableLicense.setWidget(row, 0, checkBox);



                                LabelWidget link = new LabelWidget();

                                link.setText(license.getName());

                                final String url = "Contracts.License.Edit?licenseId=" + record.getDeal().getUiLicenseList().get(row-1).getKey();

                                link.addClickHandler(new ClickHandler() {

                                    @Override

                                    public void onClick(ClickEvent event) {

                                        History.newItem(url);

                                    }

                                });

                                link.setStyleName(LINK_BEHAVIOUR);

                                tableLicense.setWidget(row, 1, link);



                                LabelWidget label = new LabelWidget();

                                label.setText(license.getType().getName());

                                tableLicense.setWidget(row, 2, label);





                                label = new LabelWidget();

                                label.setText(format.format(license.getExpiryDate()));

                                tableLicense.setWidget(row, 3, label);



                            }



                            private void insertRow(){

                                tableLicense.insertRow(tableLicense.getRowCount());

                                tableLicense.getRowFormatter().addStyleName(getRow(), ROW_STYLE);

                                tableLicense.getRowFormatter().addStyleName(getRow(), ROW_BODY_STYLE);

                            }





                            private int getRow(){

                                return tableLicense.getRowCount() - 1;

                            }



                            private void init(){

                                buildComponents();

                                copyrightHolder.addValueChangeHandler(new ValueChangeHandler<Long>() {



                                    @Override

                                    public void onValueChange(ValueChangeEvent<Long> event) {

                                        if(record.getKey() != null){

                                            fillContractListBox(event.getValue(), record.getDeal().getContract().getKey());

                                        } else {

                                            fillContractListBox(event.getValue(), 0L);

                                        }

                                    }

                                });

                                copyrightHolder.setWidth(CONTENT_LISTBOX_WIDTH);

                                copyrightHolder.ensureDebugId("deal-copyrightHolder");

                                buildDisclosureLicense();



                                contactListPanel.setContactType(UiContactType.DEAL);

                                mainContainer.add(formContainer);

                                mainContainer.add(contactListPanel);

                                documentComponent= new DocumentComponentFactory(record.getKey(), constants.contractDocuments(), UiDocumentType.DEAL, errorPanel);

                                form = documentComponent.getDocumentPanel();

                                mainContainer.add(form);

                                mainContainer.add(formUserDefinedFields);

                                addButtons();

                                mainContainer.add(buttonsContainer);

                                mainContainer.add(licenseContainer);



                                if (record.getKey() != null) {

                                    contactListPanel.setParentId(record.getKey());

                                    contactListPanel.isEditing = true;

                                    documentsList = record.getDeal().getUiDocumentList();

                                    documentComponent.setDocumentsList(documentsList);

                                    getLicense();

                                    fillForm();

                                }  else if(record.getDeal().getContract().getKey() != null) {

                                    getContract(record.getDeal().getContract().getKey());

                                    copyrightHolder.setSelectedItem(record.getDeal().getContract().getCopyrightHolder().getKey());

                                    fillContractListBox(record.getDeal().getContract().getCopyrightHolder().getKey(), record.getDeal().getContract().getKey());

                                }  else {

                                    contactListPanel.isEditing = false;

                                }



                                verifyPermissions();

                                busyIndicator.hide();

                            }





                            private void buildComponents(){



                                contract = new TypedListBoxWidget<Long>(new IntegerConverter());

                                contract.addValueChangeHandler(new ValueChangeHandler<Long>() {



                                    @Override

                                    public void onValueChange(ValueChangeEvent<Long> event) {

                                        if(event != null && event.getValue() != 0L){

                                            getContract(event.getValue());

                                        }

                                    }

                                });

                                contract.setWidth(CONTENT_LISTBOX_WIDTH);



                                contract.ensureDebugId("deal-contract");

                                externalIdTextBox = new TypedTextBoxWidget<String>(new StringConverter());

                                externalIdTextBox.setMaxLength(EXTERNAL_ID_MAX_LENGTH);



                                name = new TextBoxWidget();

                                name.setWidth(TEXTBOXWIDGET_WIDTH);

                                name.setMaxLength(DEAL_NAME_MAX_LENGH);

                                name.ensureDebugId("deal-name");



                                type.setWidth(CONTENT_LISTBOX_WIDTH);

                                type.ensureDebugId("deal-type");



                                dealCreationDate.setWidth(DATE_BOX_WIDTH);

                                dealCreationDate.ensureDebugId("deal-creationDate");



                                dealEffectiveDate.setWidth(DATE_BOX_WIDTH);

                                dealEffectiveDate.ensureDebugId("deal-effectiveDate");



                                dealExpiryDate.setWidth(DATE_BOX_WIDTH);

                                dealExpiryDate.ensureDebugId("deal-expiryDate");



                                expiryReminder = new TypedTextBoxWidget<Integer>(new PositiveIntegerConverter());

                                expiryReminder.setWidth(TEXTBOXWIDGET_WIDTH);



                                formContainer.addRow(constants.contractCopyrightHolder(), copyrightHolder, true);

                                formContainer.addRow(constants.dealContract(), contract, true);

                                formContainer.addRow(constants.externalID(), externalIdTextBox);

                                formContainer.addRow(constants.contractName(), name, true);

                                formContainer.addRow(constants.contractType(), type, true);

                                formContainer.addRow(constants.contractCreationDate(), dealCreationDate, true);

                                formContainer.addRow(constants.contractEffectiveDate(), dealEffectiveDate, true);

                                formContainer.addRow(constants.contractExpiryDate(), dealExpiryDate, true);

                                formContainer.addRow(constants.dealExpiryReminder(), expiryReminder);



                            }



                            private TypedListBoxWidget<Long> getTypeListBox(final Long selected) {

                                final TypedListBoxWidget<Long> lbType = new TypedListBoxWidget<Long>(new IntegerConverter());

                                dropDownService.getDealTypeKeyNameList(new NeptuneAsyncCallback<List<UiKeyName>>() {



                                    @Override

                                    public void onNeptuneFailure(Throwable caught) {

                                        errorPanel.showMessage(caught.getLocalizedMessage());

                                    }



                                    @Override

                                    public void onNeptuneSuccess(List<UiKeyName> result) {

                                        fillListBox(lbType, selected, result);

                                        copyrightHolder = getCopyrightHolderListBox(0L);

                                    }



                                });



                                return lbType;

                            }





                            private TypedListBoxWidget<Long> getCopyrightHolderListBox(final Long selected) {

                                final TypedListBoxWidget<Long> lbCopyrightHolder = new TypedListBoxWidget<Long>(new IntegerConverter());

                                dropDownService.getCopyrightHolderKeyNameList(new NeptuneAsyncCallback<List<UiKeyName>>() {



                                    @Override

                                    public void onNeptuneFailure(Throwable caught) {

                                        Window.alert(constants.failureGettingCopyrightHolders());

                                    }



                                    @Override

                                    public void onNeptuneSuccess(List<UiKeyName> result) {

                                        fillListBox(lbCopyrightHolder, selected, result);

                                        init();

                                    }

                                });



                                return lbCopyrightHolder;

                            }



                            private void getCustomFields(final Long isEditing){

                                contractManagerService.getUserDefinedFields(CustomFieldFactory.DEAL_SCREEN, new NeptuneAsyncCallback<List<UiUserDefinedField>>() {



                                    @Override

                                    public void onNeptuneFailure(Throwable caught) {

                                        errorPanel.showMessage(caught.getLocalizedMessage());

                                    }



                                    @Override

                                    public void onNeptuneSuccess(List<UiUserDefinedField> result) {

                                        CustomFieldFactory factory = new CustomFieldFactory(null);

                                        factory.addFieldsToForm( formUserDefinedFields, result, widgetCustomFieldMap );

                                        for (UiUserDefinedField uiUserDefinedField : result) {

                                            UiUserDefinedFieldValue value = new UiUserDefinedFieldValue();

                                            value.setIdUserDefinedField(uiUserDefinedField.getIdUserDefinedField());

                                            if(isEditing == null){

                                                value.setValue(uiUserDefinedField.getDefaultValue());

                                            }

                                            userDefinedFieldValueList.add(value);

                                        }

                                        createUpdateUserDefinedFieldValues();

                                        if(record.getDeal().getUserDefinedFieldsValues() != null){

                                            updateFormFromUserDefinedFieldValues(record.getDeal().getUserDefinedFieldsValues());

                                        }

                                    }

                                });

                            }



                            private UiContract getContract(Long key){

                                contractManagerService.getContract(key, new NeptuneAsyncCallback<UiContract>() {



                                    @Override

                                    public void onNeptuneFailure(Throwable caught) {

                                        errorPanel.showMessage(caught.getLocalizedMessage());

                                    }



                                    @Override

                                    public void onNeptuneSuccess(UiContract result) {

                                        uiContract =  result;

                                        record.getDeal().setContract(uiContract);

                                    }

                                });



                                return uiContract;

                            }



                            private void fillContractListBox(final long copyrightHolderKey, final Long selected) {

                                contract.clear();

                                dropDownService.getContractKeyNameList(copyrightHolderKey, new NeptuneAsyncCallback<List<UiKeyName>>() {



                                    @Override

                                    public void onNeptuneFailure(Throwable caught) {

                                        Window.alert(constants.failureGettingCopyrightHolders());

                                    }



                                    @Override

                                    public void onNeptuneSuccess(List<UiKeyName> result) {

                                        fillListBox(contract, selected, result);

                                    }

                                });



                            }



                            private void fillListBox(final TypedListBoxWidget<Long> listBox, final Long selected, List<UiKeyName> result) {

                                listBox.addItem("", null);

                                for (UiKeyName keyName : result) {

                                    listBox.addItem(keyName.getName(), keyName.getKey());

                                }



                                listBox.setSelectedItem(selected);



                            }



                            private void addHeading(String heading, FlexTableContainer table) {

                                /* Add the column to the header row */

                                int column = table.getCellCount(0);

                                table.insertCell(0, column);



                                /* Update the style of the header cells */

                                table.getCellFormatter().addStyleName(0, column, CELL_STYLE);

                                table.getCellFormatter().addStyleName(0, column, CELL_HEADER_STYLE);



                                updateHeading(table, heading, column);

                            }



                            private void updateHeading(FlexTableContainer table, String heading, int column) {

                                /* Create new label widget or update existing widget */

                                LabelWidget label = getHeadingWidget(table, column);

                                if (label == null) {

                                    /* Update the widget displayed as the column header */

                                    label = new LabelWidget(heading);

                                    label.addStyleName(TableConstants.STYLE_HEADER_NONSORTABLE_COL_TEXT);

                                    table.setWidget(0, column, label);

                                } else {

                                    label.setText(heading);

                                }

                            }



                            private LabelWidget getHeadingWidget(FlexTableContainer table, int column) {

                                Widget widget = table.getWidget(0, column);

                                return widget instanceof LabelWidget ? (LabelWidget) widget : null;

                            }



                            private void fillForm() {

                                externalIdTextBox.setValue(record.getDeal().getExternalId());

                                name.setValue(record.getDeal().getName());

                                copyrightHolder.setValue(record.getDeal().getContract().getCopyrightHolder().getKey(), true);

                                contract.setSelectedItem(record.getDeal().getContract().getKey());



                                if(record.getDeal().getLicenseExpiryReminder() != null){

                                    expiryReminder.setValue(record.getDeal().getLicenseExpiryReminder().intValue());

                                }



                                if(record.getDeal().getUiLicenseList() != null && !record.getDeal().getUiLicenseList().isEmpty()){

                                    fillLicenseTable(record.getDeal().getUiLicenseList());

                                }



                                for(UiDocument doc: documentsList){

                                    documentComponent.addRow(doc);

                                }



                                type.setSelectedItem(record.getDeal().getType().getKey());



                                DateTimeFormat dateFormatter = DateTimeFormat.getFormat( constants.dateFormat() );

                                dealExpiryDate.setValue(dateFormatter.format(record.getDeal().getExpiryDate()));

                                dealCreationDate.setValue(dateFormatter.format(record.getDeal().getCreationDate()));

                                dealEffectiveDate.setValue(dateFormatter.format(record.getDeal().getEffectiveDate()));



                                contactListPanel.getContactTable().refresh();



                                updateFormFromUserDefinedFieldValues(record.getDeal().getUserDefinedFieldsValues());

                            }



                            private void addButtons() {



                                saveButton = new ButtonWidget(constants.saveButtonName(), new ClickHandler() {



                                    @Override

                                    public void onClick(ClickEvent event) {



                                        if (validate()) {

                                            commit();

                                            DealDetailView.this.callback.save(DealDetailView.this);

                                        }

                                    }



                                });

                                saveButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);

                                saveButton.setEnabled(false);

                                saveButton.ensureDebugId("deal-save");

                                buttonsContainer.add(saveButton);



                                cancelButton = new ButtonWidget(constants.cancelButtonName(), new ClickHandler() {

                                    @Override

                                    public void onClick(ClickEvent event) {

                                        errorPanel.reset();

                                        History.back();

                                    }

                                });

                                cancelButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);

                                buttonsContainer.add(cancelButton);

                            }





                            private boolean validate(){



                                errorPanel.reset();

                                boolean valid = formContainer.validate() && formUserDefinedFields.validate();

                                if(record.getDeal().getContract().getKey() != null && valid){

                                    for(UiLicense uiLicense : record.getDeal().getUiLicenseList()){

                                        if(uiLicense.getCreationDate().before(dealCreationDate.getDatePicker().getValue())){

                                            valid = false;

                                            errorPanel.addHeading1(messages.dealLicenseCreationDateValidation(uiLicense.getName()));

                                        } else if(uiLicense.getEffectiveDate().before(dealEffectiveDate.getDatePicker().getValue())){

                                            valid = false;

                                            errorPanel.addHeading1(messages.dealLicenseEffectiveDateValidation(uiLicense.getName()));

                                        } else if(uiLicense.getExpiryDate().after(dealExpiryDate.getDatePicker().getValue())){

                                            valid = false;

                                            errorPanel.addHeading1(messages.dealLicenseExpiryDateValidation(uiLicense.getName()));

                                        }

                                    }

                                    if (dealCreationDate.getDatePicker().getValue().after(dealEffectiveDate.getDatePicker().getValue())){

                                        valid = false;

                                        errorPanel.addHeading1(constants.dealCreationDateValidation());

                                    }



                                    if(dealCreationDate.getDatePicker().getValue().before(uiContract.getCreationDate())) {

                                        valid = false;

                                        errorPanel.addHeading1(constants.dealContractCreationDateValidation());

                                    }



                                    if (dealEffectiveDate.getDatePicker().getValue().before(uiContract.getEffectiveDate())){

                                        valid = false;

                                        errorPanel.addHeading1(constants.dealEffectiveDateValidation());

                                    }



                                    if(dealEffectiveDate.getDatePicker().getValue().after(uiContract.getExpiryDate())

                                            || CalendarUtil.isSameDate(dealEffectiveDate.getDatePicker().getValue(), uiContract.getExpiryDate())) {

                                        valid = false;

                                        errorPanel.addHeading1(constants.dealContractEffectiveDateValidation());

                                    }



                                    if (dealEffectiveDate.getDatePicker().getValue().after(dealExpiryDate.getDatePicker().getValue())

                                            || CalendarUtil.isSameDate(dealEffectiveDate.getDatePicker().getValue(), dealExpiryDate.getDatePicker()

                                                    .getValue())){

                                        valid = false;

                                        errorPanel.addHeading1(constants.dealExpiryEffectiveDateValidation());

                                    }



                                    if(dealExpiryDate.getDatePicker().getValue().before(uiContract.getEffectiveDate())

                                            || CalendarUtil.isSameDate(dealExpiryDate.getDatePicker().getValue(), uiContract.getEffectiveDate() )){

                                        valid = false;

                                        errorPanel.addHeading1(constants.dealContractExpiryEffectiveDateValidation());

                                    }



                                    if(dealExpiryDate.getDatePicker().getValue().after(uiContract.getExpiryDate())) {

                                        valid = false;

                                        errorPanel.addHeading1(constants.dealContractExpiriesDateValidation());

                                    }



                                }



                                Set<Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = widgetCustomFieldMap.entrySet();

                                for (Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {

                                    DataTypeWidget<?> dataTypeWidget = entry.getKey();

                                    CustomFieldValidator.validate(dataTypeWidget, entry.getValue());

                                    if (!dataTypeWidget.isValidValue() || dataTypeWidget.hasValidationError()) {

                                        valid = false;

                                    }

                                }



                                if(!valid){

                                    errorPanel.addHeading1(constants.dealValidationMessage());

                                }



                                return valid;

                            }



                            private void buildDisclosureLicense() {

                                licenseDisclosureContainer = new RoundedDisclosureContainer(constants.contractDeals(), true);



                                licenseDisclosureContainer.addStyleName(STYLE_DISCLOSURE_CONTAINER);

                                licenseContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);

                                tableLicense = new FlexTableContainer();

                                tableLicense.addStyleName(TABLE_STYLE);



                                /* Create the header row */

                                tableLicense.insertRow(0);

                                tableLicense.getRowFormatter().addStyleName(0, ROW_STYLE);

                                tableLicense.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);



                                createTableLicenseHeader();

                                LabelWidget label = new LabelWidget();

                                label.setHeight("30px");

                                licenseContainer.addRow("", label);

                                licenseContainer.addRow(constants.licenseTabDisplayName(), tableLicense);

                                addButtonsLicense();

                                licenseDisclosureContainer.add(licenseContainer);

                            }



                            private void createTableLicenseHeader() {



                                check = new CheckBoxWidget();

                                check.addClickHandler(new ClickHandler() {

                                    @Override

                                    public void onClick(ClickEvent event) {

                                        if (check.getValue()) {

                                            for (int i = 0; i < tableLicense.getRowCount(); i++) {

                                                CheckBoxWidget all = (CheckBoxWidget) tableLicense.getWidget(i, 0);

                                                all.setValue(true);

                                            }

                                        } else {

                                            for (int i = 0; i < tableLicense.getRowCount(); i++) {

                                                CheckBoxWidget all = (CheckBoxWidget) tableLicense.getWidget(i, 0);

                                                all.setValue(false);

                                            }

                                        }

                                    }

                                });



                                tableLicense.insertCell(0, 0);

                                tableLicense.getRowFormatter().setStyleName(0, TableConstants.STYLE_HEADER_ROW);

                                tableLicense.getCellFormatter().addStyleName(0, 0, CELL_STYLE);

                                tableLicense.getCellFormatter().addStyleName(0, 0, CELL_HEADER_STYLE);

                                tableLicense.setWidget(0, 0, check);



                                addHeading(constants.dealName(), tableLicense);

                                addHeading(constants.dealType(), tableLicense);

                                addHeading(constants.dealExpiryDate(), tableLicense);



                            }



                            private void addButtonsLicense() {

                                HorizontalContainer buttons = new HorizontalContainer();

                                buttons.setSpacing(5);



                                addButton = new ButtonWidget(constants.addButtonName(), new ClickHandler() {



                                    @Override

                                    public void onClick(ClickEvent event) {

                                        History.newItem("Contracts.License.Create?dealId=" + record.getKey());

                                    }



                                });

                                addButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);

                                addButton.setEnabled(false);



                                removeButton = new ButtonWidget(constants.removeButtonName(), new ClickHandler() {



                                    @Override

                                    public void onClick(ClickEvent event) {

                                        removeRow();

                                    }



                                });

                                removeButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);

                                removeButton.setEnabled(false);



                                buttons.add(addButton);

                                buttons.add(removeButton);



                                licenseContainer.addRow("", new LabelWidget());

                                licenseContainer.addRow("", buttons);



                            }



                            private void removeRow(){

                                List<UiLicenseRecord> deleteList = new ArrayList<UiLicenseRecord>();



                                for(int i = 1; i < tableLicense.getRowCount(); i++){

                                    if(((CheckBoxWidget)tableLicense.getWidget(i, 0)).getValue()){

                                        UiLicenseRecord liRecord = new UiLicenseRecord();

                                        liRecord.setLicense(this.record.getDeal().getUiLicenseList().get(i-1));

                                        deleteList.add(liRecord);

                                    }

                                }



                                if(deleteList.size() == 0){

                                    Window.alert(messages.noLicenseSelected());

                                } else {



                                    busyIndicator.center();

                                    contractManagerService.deleteLicenses(deleteList, new NeptuneAsyncCallback<Void>() {



                                        @Override

                                        public void onNeptuneFailure(Throwable caught) {

                                            errorPanel.showMessage(caught.getLocalizedMessage());

                                            busyIndicator.hide();

                                        }



                                        @Override

                                        public void onNeptuneSuccess(Void result) {

                                            for(int i = 1; i < tableLicense.getRowCount(); i++){

                                                if(((CheckBoxWidget)tableLicense.getWidget(i, 0)).getValue()){

                                                    tableLicense.removeRow(i);

                                                    record.getDeal().getUiLicenseList().remove(i-1);

                                                    i = i - 1;

                                                }

                                            }



                                            if(((CheckBoxWidget)tableLicense.getWidget(0, 0)).getValue()){

                                                ((CheckBoxWidget)tableLicense.getWidget(0, 0)).setValue(false);

                                            }



                                            busyIndicator.hide();

                                        }

                                    });

                                }

                            }



                            @Override

                            public void commit() {

                                UiDeal deal  = new UiDeal();

                                if(record.getKey() !=  null){

                                    deal.setKey(record.getDeal().getKey());

                                }

                                deal.setExternalId(externalIdTextBox.getText() != null ? externalIdTextBox.getText().trim() : null);

                                UiContract dealUiContract = new UiContract();

                                dealUiContract.setKey(contract.getSelectedItem());

                                deal.setContract(dealUiContract);

                                deal.setActive(true);

                                deal.setCreationDate(dealCreationDate.getDatePicker().getValue());

                                deal.setEffectiveDate(dealEffectiveDate.getDatePicker().getValue());

                                deal.setExpiryDate(dealExpiryDate.getDatePicker().getValue());

                                if(expiryReminder.getValue() != null){

                                    deal.setLicenseExpiryReminder(new Long(expiryReminder.getValue().toString()));

                                }

                                deal.setName(name.getText().trim());

                                UiDealType dealType = new UiDealType();

                                dealType.setKey(type.getSelectedItem());

                                dealType.setName(type.getTextValue());

                                deal.setType(dealType);

                                deal.setUiContactList(contactListPanel.getUiContactList());

                                deal.setUiDocumentList(documentsList);

                                deal.setUiLicenseList(record.getDeal().getUiLicenseList());

                                updateUserDefinedFieldsValuesFromForm(userDefinedFieldValueList);

                                deal.setUserDefinedFieldsValues(userDefinedFieldValueList);

                                record.setDeal(deal);

                            }



                            private void createUpdateUserDefinedFieldValues() {

                                for ( UiUserDefinedField uiUserDefinedField : widgetCustomFieldMap.values() ) {

                                    UiUserDefinedFieldValue uiUserDefinedFieldValue = findUiUserDefinedFieldValue(

                                            uiUserDefinedField.getIdUserDefinedField(), record.getDeal().getUserDefinedFieldsValues() );

                                    if ( uiUserDefinedFieldValue == null ) {

                                        uiUserDefinedFieldValue = new UiUserDefinedFieldValue();

                                        uiUserDefinedFieldValue.setIdUserDefinedField( uiUserDefinedField.getIdUserDefinedField() );

                                        uiUserDefinedFieldValue.setValue( uiUserDefinedField.getDefaultValue() );

                                        record.getDeal().getUserDefinedFieldsValues().add( uiUserDefinedFieldValue );

                                    }

                                }

                            }



                            private UiUserDefinedFieldValue findUiUserDefinedFieldValue( Long idUserDefinedField,

                                    List<UiUserDefinedFieldValue> userDefinedFieldsValues ) {

                                UiUserDefinedFieldValue uiUserDefinedFieldValue = null;

                                for ( UiUserDefinedFieldValue fieldValue : userDefinedFieldsValues ) {

                                    if ( fieldValue.getIdUserDefinedField() != null

                                            && fieldValue.getIdUserDefinedField().equals( idUserDefinedField ) ) {

                                        uiUserDefinedFieldValue = fieldValue;

                                        break;

                                    }

                                }

                                return uiUserDefinedFieldValue;

                            }



                            protected void updateUserDefinedFieldsValuesFromForm(Collection<UiUserDefinedFieldValue> oldValuesList) {

                                Set<Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = widgetCustomFieldMap.entrySet();

                                for (Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {

                                    DataTypeWidget<?> dataTypeWidget = entry.getKey();

                                    UiUserDefinedField userDefinedField = entry.getValue();

                                    UiUserDefinedFieldValue userDefinedFieldValue = getValueForFieldType(oldValuesList, userDefinedField

                                            .getIdUserDefinedField());

                                    if (userDefinedFieldValue != null) {

                                        userDefinedFieldValue.setValue(dataTypeWidget.getTextValue());

                                    }

                                }

                            }



                            protected void updateFormFromUserDefinedFieldValues(Collection<UiUserDefinedFieldValue> newValuesList) {



                                Set<Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = widgetCustomFieldMap.entrySet();

                                for (Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {

                                    DataTypeWidget<?> dataTypeWidget = entry.getKey();

                                    UiUserDefinedField userDefinedField = entry.getValue();

                                    UiUserDefinedFieldValue userDefinedFieldValue = getValueForFieldType(newValuesList, userDefinedField

                                            .getIdUserDefinedField());

                                    if (userDefinedFieldValue != null) {

                                        dataTypeWidget.setTextValue(userDefinedFieldValue.getValue());

                                    }

                                }

                            }



                            private UiUserDefinedFieldValue getValueForFieldType(Collection<UiUserDefinedFieldValue> newValuesList,

                                    Long idUserDefinedField) {

                                UiUserDefinedFieldValue userDefinedFieldValue = null;

                                for (UiUserDefinedFieldValue newUserDefinedFieldValue : newValuesList) {

                                    Long newIdUserDefinedField = newUserDefinedFieldValue.getIdUserDefinedField();

                                    if (newIdUserDefinedField.equals(idUserDefinedField)) {

                                        userDefinedFieldValue = newUserDefinedFieldValue;

                                        break;

                                    }

                                }



                                return userDefinedFieldValue;

                            }



                            private void verifyPermissions(){

                                if (ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_CREATE) && record.getKey() == null) {

                                    saveButton.setEnabled(true);

                                }



                                if (ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_CREATE) && record.getKey() != null) {

                                    addButton.setEnabled(true);

                                }



                                if(ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_MODIFY) && record.getKey() != null){

                                    saveButton.setEnabled(true);

                                }



                                if(ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_DELETE) && record.getKey() != null){

                                    removeButton.setEnabled(true);

                                }

                            }



                            @Override

                            public UiDealRecord getRecord() {

                                return record;

                            }



                            @Override

                            public void revert() {

                            }



                            @Override

                            public String getStyleName() {

                                return null;

                            }



                            @Override

                            public Widget getWidget() {

                                return this;

                            }



                            @Override

                            public void release() {

                            }



                            @Override

                            public void saveFailed( Throwable throwable ) {

                                errorPanel.showMessage(throwable.getLocalizedMessage());

                            }



                            @Override

                            protected void onUnload() {

                                super.onUnload();

                            }

}

