package com.ericsson.cms.contractmgmt.client.tab.deal;



import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;

import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;

import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;

import com.ericsson.cms.contractmgmt.client.tab.deal.DealDataProvider.IBusyNotifier;

import com.google.gwt.core.client.GWT;

import com.google.gwt.user.client.ui.Composite;

import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;

import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;



/**

 * Table that shows the list of deals.

 * 

 * @author Daniel Paranhos

 * 

 */

public class DealListPanel extends Composite {



    // table related

    private DealDataProvider dataProvider;

    private PageFeature pageFeature;

    private SortFeatureImpl<Long, UiDealRecord> sortFeature;

    private DealDetailFeature detailFeature;

    private BookmarkFeature bookmarkFeature;

    private AnchorChangeListener anchorChangeListener;



    // widgets used in this view

    private VerticalContainer mainContainer;

    private Table<Long, UiDealRecord> table;

    private BusyIndicator busyIndicator = new BusyIndicator();



    private HeaderPanel header;

    private final SuccessPanel successPanel = new SuccessPanel();

    private final ErrorPanel errorPanel = new ErrorPanel();



    private ContractComponentConstants constants = (ContractComponentConstants) GWT

            .create( ContractComponentConstants.class );



    // spacing between the table and message panel

    private static final int SPACING = 2;

    private static final String STYLE_NAME = "content-ContractPanel";



    public DealListPanel() {

        this.dataProvider = new DealDataProvider( this );

        dataProvider.setBusyNotifier( new IBusyNotifier() {

            @Override

            public void startingToBeBusy() {

                busyIndicator.center();

            }



            @Override

            public void doneBeingBusy() {

                busyIndicator.hide();

            }

        } );

        init();

    }



    private void init() {

        initWidgets();

        setContainers();

    }



    public SuccessPanel getSuccessPanel() {

        return successPanel;

    }



    public ErrorPanel getErrorPanel() {

        return errorPanel;

    }



    private void setContainers() {

        mainContainer.add( header );

        mainContainer.add( successPanel );

        mainContainer.add( errorPanel );

        mainContainer.add( table );

    }



    private void initWidgets() {

        mainContainer = new VerticalContainer();

        mainContainer.setSpacing( SPACING );

        mainContainer.setStylePrimaryName( STYLE_NAME );

        this.initWidget( mainContainer );



        header = new HeaderPanel( "" );



        table = new Table<Long, UiDealRecord>( dataProvider );

        table.addTableViewChangeHandler( new TableViewChangeHandler<Long, UiDealRecord>() {

            @Override

            public void onShowDetailView( TableDetailViewEvent<Long, UiDealRecord> event ) {

                if ( event.isCreateView() ) {

                    header.setLabel( constants.dealCreateHeading() );

                } else {

                    header.setLabel( constants.dealViewEditHeading() + " "

                            + event.getRecord().getDeal().getName() );

                }

            }



            @Override

            public void onShowListView( TableViewEvent event ) {

                header.setLabel( constants.dealListHeading() );

            }

        } );



        // page feature

        pageFeature = new PageFeatureImpl();

        dataProvider.setParentPageFeature( pageFeature );



        // sort feature

        sortFeature = new SortFeatureImpl<Long, UiDealRecord>(

                dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING );

        for ( Column<?, UiDealRecord> col : dataProvider.getSortColumns() ) {

            sortFeature.addSortableColumn( col );

        }

        dataProvider.setParentSortFeature( sortFeature );



        // detail feature

        detailFeature = new DealDetailFeature( this );

        

        // bookmark feature

        bookmarkFeature = new BookmarkFeatureImpl();        



        table.addSortFeature( sortFeature );

        table.addPageFeature( pageFeature );

        table.addDetailFeature( detailFeature );

        table.addBookmarkFeature( bookmarkFeature );



        table.initialize( new NeptuneAsyncCallback<Void>() {

            @Override

            public void onNeptuneFailure( Throwable caught ) {

            }



            @Override

            public void onNeptuneSuccess( Void result ) {

            }

        } );



        anchorChangeListener = new DealAnchorChangeListener( this );

    }



    public Table<Long, UiDealRecord> getDealTable() {

        return this.table;

    }



    public AnchorChangeListener getAnchorChangeListener() {

        return this.anchorChangeListener;

    }



    /**

     * @param reverseAnchorChangeListener

     *            the reverseAnchorChangeListener to set

     */

    public void setReverseAnchorChangeListener( AnchorChangeListener reverseAnchorChangeListener ) {

        table.setAnchorChangeNotifier( reverseAnchorChangeListener );

    }



    public void clearMessages() {

        this.successPanel.reset();

        this.errorPanel.reset();

    }

}

