package com.ericsson.cms.contractmgmt.client.tab.license;

import static com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants.STYLE_DATACELL;
import static com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants.STYLE_DATACELL_CHECKBOX;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.HelpWidget;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.model.UiAsset;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.HTMLTable.CellFormatter;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class AssetsTable extends VerticalContainer {

    private static final String TABLE_STYLE = "contract-table";
    private static final int CHECKBOX_COLUMN = 0;

    private RadioButtonWidget assetsInLicenseSelect;
    private FlexTableContainer table;
    private ButtonWidget addAssetsButton;
    private ButtonWidget removeAssetsButton;
    private VerticalContainer tableContainer;
    private HorizontalContainer buttonsContainer;
    private final UiLicense uiLicense;
    private final ErrorPanel errorPanel;
    private final BusyIndicator busyIndicator = new BusyIndicator();

    private final IContractManagerServiceAsync contractManagerService = GWT.create( IContractManagerService.class );

    private final ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    private final ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create( ContractComponentMessages.class );

    public AssetsTable( UiLicense uiLicense, ErrorPanel errorPanel ) {
        this.uiLicense = uiLicense;
        this.errorPanel = errorPanel;

        init();
    }

    private void init() {
        assetsInLicenseSelect = new RadioButtonWidget( "assets", constants.select() );
        assetsInLicenseSelect.addValueChangeHandler( new ValueChangeHandler<Boolean>() {

            @Override
            public void onValueChange( ValueChangeEvent<Boolean> event ) {
                if ( event.getValue() ) {
                    showAssetsTable();
                }
            }
        } );
        boolean isCreating = uiLicense.getKey() == null;
        if ( isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE )
                || !isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) ) {
            HorizontalContainer assets = createRadioContainer( null, assetsInLicenseSelect );
            if ( uiLicense.getKey() == null ) {
                assets.add( new HelpWidget( messages.assetsSelectionAfterSave() ) );
            }
            add( assets );
        }
        assetsInLicenseSelect.setValue(true);
        assetsInLicenseSelect.setEnabled( false );

        tableContainer = new VerticalContainer();
        add( tableContainer );

        buttonsContainer = new HorizontalContainer();
        add( buttonsContainer );

        if ( uiLicense.getKey() != null ) {
            assetsInLicenseSelect.setEnabled( true );
            if ( uiLicense.getAssetList().isEmpty() ) {
                assetsInLicenseSelect.setValue( false );
                uiLicense.setAllAssets( true );
            } else {
                assetsInLicenseSelect.setValue( true );
                uiLicense.setAllAssets( false );
            }

            addAssetsButton = new ButtonWidget( constants.addButtonName(), new ClickHandler() {

                @Override
                public void onClick( ClickEvent event ) {
                    History.newItem( "Content.Search?licenseId=" + uiLicense.getKey() );
                }
            } );
            addAssetsButton.addStyleDependentName( StyleNames.COMMIT_BUTTON_STYLE );

            List<Long> titleIds = new ArrayList<Long>();
            for ( UiAsset uiAsset : uiLicense.getAssetList() ) {
                titleIds.add( uiAsset.getKey() );
            }

            busyIndicator.center();
            contractManagerService.getAssets( titleIds, new NeptuneAsyncCallback<List<UiAsset>>() {
                @Override
                public void onNeptuneFailure( Throwable caught ) {
                    busyIndicator.hide();
                }

                @Override
                public void onNeptuneSuccess( final List<UiAsset> uiAssets ) {
                    uiLicense.getAssetList().clear();
                    uiLicense.getAssetList().addAll( uiAssets );

                    table = prepareTable( uiAssets );

                    if ( ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) ) {
                        removeAssetsButton = new ButtonWidget( constants.deleteButtonName(),
                                new ClickHandler() {
                                    @Override
                                    public void onClick( ClickEvent event ) {
                                        List<Long> assetsToRemove = new ArrayList<Long>();
                                        // Gather all asset ids that need to be removed
                                        for ( int i = table.getRowCount() - 1; i >= 1; i-- ) {
                                            // if this row is selected add the asset id to
                                            // the remove list
                                            if ( ( (CheckBoxWidget) table.getWidget( i, CHECKBOX_COLUMN ) )
                                                    .getValue() ) {
                                                assetsToRemove.add( uiAssets.get( i - 1 ).getKey() );
                                                table.removeRow( i );
                                            }
                                        }
                                        if ( assetsToRemove.isEmpty() ) {
                                            errorPanel.showMessage( messages.assetSelectionRequired() );
                                            return;
                                        } else {
                                            removeAssetsFromLicense( uiLicense, assetsToRemove );
                                        }
                                    }

                                } );
                        if ( uiLicense.getAllAssets() != null && !uiLicense.getAllAssets() ) {
                            tableContainer.add( table );
                            addButtons();                            
                        }
                    } else {
                        if ( uiLicense.getAllAssets() != null && !uiLicense.getAllAssets() ) {
                            tableContainer.add( table );
                        } else {
                            tableContainer.add( new LabelWidget( constants.none() ) );
                        }
                    }

                    busyIndicator.hide();
                }

            } );
        } else {
            uiLicense.setAllAssets( false );
        }
        if ( !ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) ) {
            assetsInLicenseSelect.setEnabled( false );
        }

    }

    private void addButtons() {
        if ( ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) ) {
            buttonsContainer.add( addAssetsButton );
            LabelWidget space = new LabelWidget( "" );
            buttonsContainer.add( space );
            buttonsContainer.setCellWidth( space, "5px" );
            buttonsContainer.add( removeAssetsButton );
        }
    }

    private void removeAssetsFromLicense( final UiLicense uiLicense, final List<Long> assetsToRemove ) {
        busyIndicator.center();
        contractManagerService.removeAssetsFromLicense( uiLicense.getKey(), assetsToRemove, new NeptuneAsyncCallback<Void>() {

            @Override
            public void onNeptuneFailure( Throwable caught ) {
                busyIndicator.hide();
            }

            @Override
            public void onNeptuneSuccess( Void result ) {
                for ( Long assetIdToRemove : assetsToRemove ) {
                    for ( UiAsset uiAsset : uiLicense.getAssetList() ) {
                        if ( uiAsset.getKey().equals( assetIdToRemove ) ) {
                            uiLicense.getAssetList().remove( uiAsset );
                            break;
                        }
                    }
                }

                busyIndicator.hide();
            }
        } );
    }

    private HorizontalContainer createRadioContainer( RadioButtonWidget radio1, RadioButtonWidget radio2 ) {
        HorizontalContainer container = new HorizontalContainer();

        radio2.setValue( true );
        container.add( radio2 );
        addSpace( container );

        return container;
    }

    private void addSpace( HorizontalContainer container ) {
        if ( container != null ) {
            HorizontalPanel space = new HorizontalPanel();
            LabelWidget label = new LabelWidget();
            space.add( label );
            space.setCellWidth( label, "10" );
            container.add( space );
        }
    }

    public boolean allAssetsSelected() {
        return false;
    }

    /**
     * Populates the asset table with the every asset's metadata.
     * 
     * @param uiAssets
     * @return
     */
    private FlexTableContainer prepareTable( List<UiAsset> uiAssets ) {
        // flex table
        final FlexTableContainer flexTable = new FlexTableContainer();
        flexTable.setStylePrimaryName( TABLE_STYLE );

        /* table row and column indices */
        int rowIndex = 0;
        int columnIndex = 0;

        /* Create the header row */
        flexTable.getRowFormatter().addStyleName( rowIndex, TableConstants.STYLE_HEADER_ROW );

        // show the check box only if the user has modify permissions
        if ( ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) ) {
            final CheckBoxWidget headerChkBox = new CheckBoxWidget();
            headerChkBox.addClickHandler( new ClickHandler() {
                @Override
                public void onClick( ClickEvent event ) {
                    // check/uncheck checkboxes in all the rows
                    for ( int i = 1; i < flexTable.getRowCount(); i++ ) {
                        ( (CheckBoxWidget) flexTable.getWidget( i, CHECKBOX_COLUMN ) ).setValue( headerChkBox
                                .getValue() );
                    }
                }
            } );
            flexTable.setWidget( rowIndex, columnIndex++, headerChkBox );
        }

        // Creating header row

        flexTable.setWidget( rowIndex, columnIndex++, createHeaderLabel( constants.licenseTitleIdColumn() ) );
        flexTable.setWidget( rowIndex, columnIndex++, createHeaderLabel( constants.licensePackageAssetIdColumn() ) );
        flexTable.setWidget( rowIndex, columnIndex++, createHeaderLabel( constants.licenseTitleBriefColumn() ) );

        CellFormatter cellFormatter = flexTable.getCellFormatter();
        for ( UiAsset ua : uiAssets ) {
            final UiAsset uiAsset = ua;
            rowIndex = flexTable.getRowCount();
            columnIndex = 0;
            flexTable.insertRow( rowIndex );

            // check box for this row, if required
            if ( ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) ) {
                CheckBoxWidget dataRowChkbox = new CheckBoxWidget();
                dataRowChkbox.addClickHandler( new ClickHandler() {
                    @Override
                    public void onClick( ClickEvent event ) {
                        // If the check all was selected prior to un-selecting
                        // this row, un-select the check all too.
                        if ( ( (CheckBoxWidget) flexTable.getWidget( 0, CHECKBOX_COLUMN ) ).getValue() ) {
                            ( (CheckBoxWidget) flexTable.getWidget( 0, CHECKBOX_COLUMN ) ).setValue( false );
                        }
                    }
                } );
                flexTable.setWidget( rowIndex, columnIndex, dataRowChkbox );
                cellFormatter.addStyleName( rowIndex, columnIndex, STYLE_DATACELL );
                cellFormatter.addStyleName( rowIndex, columnIndex, STYLE_DATACELL_CHECKBOX );
                columnIndex++;
            }

            String styleName = rowIndex % 2 == 0 ? TableConstants.STYLE_DATA_EVEN_ROW
                    : TableConstants.STYLE_DATA_ODD_ROW;
            flexTable.getRowFormatter().setStyleName( rowIndex, styleName );

            LabelWidget idLabel = new LabelWidget( uiAsset.getKey().toString() );
            // if this is the id column, create a hyperlink to the title detail.
            if ( ClientAuthorizationManager
                    .isAuthorized( com.tandbergtv.cms.portal.content.client.Permissions.TITLE_VIEW ) ) {
                idLabel.setStyleName( TableConstants.STYLE_DATA_LINK );
                idLabel.addClickHandler( new ClickHandler() {
                    @Override
                    public void onClick( ClickEvent event ) {
                        History.newItem( "Content.Search.Id=" + uiAsset.getKey() );
                    }
                } );
            } else {
                idLabel.addStyleName( TableConstants.STYLE_DATA_TEXT );
            }
            flexTable.setWidget( rowIndex, columnIndex, idLabel );
            cellFormatter.addStyleName( rowIndex, columnIndex, TableConstants.STYLE_DATACELL );
            columnIndex++;

            
            addDataCellToTable( flexTable, rowIndex, columnIndex, uiAsset.getPackageAssetId(), cellFormatter,
                    TableConstants.STYLE_DATACELL_TEXT );
            columnIndex++;
            
            
            addDataCellToTable( flexTable, rowIndex, columnIndex, uiAsset.getName(), cellFormatter,
                    TableConstants.STYLE_DATACELL_TEXT );
            columnIndex++;

            rowIndex++;
        }

        return flexTable;
    }

    private void addDataCellToTable( FlexTableContainer table, int rowIndex, int columnIndex, String version,
            CellFormatter cellFormatter, String style ) {
        table.setWidget( rowIndex, columnIndex, createDataCellLabel( version ) );
        cellFormatter.addStyleName( rowIndex, columnIndex, TableConstants.STYLE_DATACELL );
        cellFormatter.addStyleName( rowIndex, columnIndex, style );
    }

    private Widget createHeaderLabel( String text ) {
        LabelWidget label = new LabelWidget( text );
        label.addStyleName( TableConstants.STYLE_HEADER_NONSORTABLE_COL_TEXT );

        return label;
    }

    private Widget createDataCellLabel( String text ) {
        LabelWidget label = new LabelWidget( text );
        label.addStyleName( TableConstants.STYLE_DATACELL );

        return label;
    }

    private void showAssetsTable() {
        tableContainer.clear();
        buttonsContainer.clear();
        tableContainer.add( table );
        addButtons();
    }

}
