package com.ericsson.cms.contractmgmt.client.tab.license;

import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class LicenseAnchorChangeListener implements AnchorChangeListener {

    // constants in the url e.g. ?licenseId=1
    private static final String LICENSE_ID = "licenseId";
    private static final String DEAL_ID = "dealId";
    private static final String PARAMETER_DELIMITER = "&";
    private static final String VALUE_DELIMITER = "=";
    private final LicenseListPanel widget;

    public LicenseAnchorChangeListener( LicenseListPanel listPanel ) {
        this.widget = listPanel;
    }

    @Override
    public void anchorChanged( String anchor ) {
        long licenseId = 0L;
        long dealId = 0L;
        
        /* Check for anchor with license id */
        if ( anchor != null && anchor.contains( LICENSE_ID ) ) {
            widget.getLicenseTable().reset();

            // skip the first char
            anchor = anchor.substring( 5 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( LICENSE_ID ) ) {
                    licenseId = Long.parseLong( paramValue[1] );
                }
            }

            IContractManagerServiceAsync cmService = GWT.create( IContractManagerService.class );
            cmService.getLicense(licenseId, new NeptuneAsyncCallback<UiLicense>() {

                @Override
                public void onNeptuneFailure(Throwable caught) {
                     Window.alert( caught.getLocalizedMessage() );
                }

                @Override
                public void onNeptuneSuccess(UiLicense result) {
                    widget.getLicenseTable().showDetailView(new UiLicenseRecord(result)); 
                }   
            
            } );
        } else if (anchor != null && !anchor.contains( LICENSE_ID ) && anchor.contains(DEAL_ID)) {
            widget.getLicenseTable().reset();

            // skip the first char
            anchor = anchor.substring( 7 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( DEAL_ID ) ) {
                    dealId = Long.parseLong( paramValue[1] );
                }
            }
            
            final UiLicense uiLicense = new UiLicense();
            
            IContractManagerServiceAsync cmService = GWT.create( IContractManagerService.class );
            
            cmService.getDeal(dealId, new NeptuneAsyncCallback<UiDeal>() {

                @Override
                public void onNeptuneFailure(Throwable caught) {
                    Window.alert( caught.getLocalizedMessage() );
                }

                @Override
                public void onNeptuneSuccess(UiDeal result) {
                    uiLicense.setName("");
                    uiLicense.setDeal(result);
                    widget.getLicenseTable().showDetailView(new UiLicenseRecord(uiLicense)); 
                }
            });
            
        } else {
            widget.getLicenseTable().setAnchor( anchor );
        }
    }
}
