package com.ericsson.cms.contractmgmt.client.tab.license;



import java.util.ArrayList;

import java.util.Collection;

import java.util.Collections;

import java.util.Comparator;

import java.util.Date;

import java.util.HashMap;

import java.util.List;

import java.util.Map;

import java.util.Map.Entry;

import java.util.Set;



import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldValidator;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;

import com.ericsson.cms.contractmgmt.client.document.DocumentComponentFactory;

import com.ericsson.cms.contractmgmt.client.model.UiContentProvider;

import com.ericsson.cms.contractmgmt.client.model.UiContract;

import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;

import com.ericsson.cms.contractmgmt.client.model.UiDeal;

import com.ericsson.cms.contractmgmt.client.model.UiDeliveryLocation;

import com.ericsson.cms.contractmgmt.client.model.UiDevice;

import com.ericsson.cms.contractmgmt.client.model.UiDocument;

import com.ericsson.cms.contractmgmt.client.model.UiDocumentType;

import com.ericsson.cms.contractmgmt.client.model.UiKeyName;

import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;

import com.ericsson.cms.contractmgmt.client.model.UiLicense;

import com.ericsson.cms.contractmgmt.client.model.UiPlatform;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;

import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;

import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;

import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;

import com.google.gwt.core.client.GWT;

import com.google.gwt.event.dom.client.ChangeEvent;

import com.google.gwt.event.dom.client.ChangeHandler;

import com.google.gwt.event.logical.shared.ValueChangeEvent;

import com.google.gwt.event.logical.shared.ValueChangeHandler;

import com.google.gwt.i18n.client.DateTimeFormat;

import com.google.gwt.user.client.ui.FormPanel;

import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;

import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;

import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextAreaWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;



public class LicenseMainForm extends ContractFormContainer {



    private static final int VISIBLE_LENGTH = 10;

    private static final String CONTENT_LISTBOX_WIDTH = "300px";

    private static final int NOTES_VISIBLE_COUNT = 5;

    private static final int NAME_MAX_LENGHT = 50;

    private static final int NOTES_CHAR_WIDTH = 30;

    private static final int EXTERNAL_ID_MAX_LENGTH = 100;



    private final ContractComponentConstants constants = (ContractComponentConstants) GWT

            .create( ContractComponentConstants.class );



    private final ContractComponentMessages messages = (ContractComponentMessages) GWT

            .create( ContractComponentMessages.class );



    private final IContractManagerServiceAsync contractManagerService = GWT.create( IContractManagerService.class );



    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT

            .create( IContractManagerDropDownService.class );



    private final Map<DataTypeWidget<?>, UiUserDefinedField> widgetCustomFieldMap = new HashMap<DataTypeWidget<?>, UiUserDefinedField>();



    private TypedListBoxWidget<Long> copyrightHolderListBox;

    private TypedListBoxWidget<Long> contractListBox;

    private TypedListBoxWidget<Long> dealListBox;

    private TypedListBoxWidget<Long> typeListBox;

    private TypedListBoxWidget<String> contentProviderListBox;

    private final TypedTextBoxWidget<String> externalIdTextBox = new TypedTextBoxWidget<String>(new StringConverter());



    private final TypedTextBoxWidget<String> nameTextBox = new TypedTextBoxWidget<String>(

            new StringConverter() );

    private final CheckBoxWidget activeCheckBox = new CheckBoxWidget();

    private final TypedDateBoxWidget creationDate = new TypedDateBoxWidget( new DateConverter(

            constants.dateFormat(), constants.dateFormat() ) );

    private final TypedDateBoxWidget expiryDate = new TypedDateBoxWidget( new DateConverter(

            constants.dateFormat(), constants.dateFormat() ) );

    private final TypedDateBoxWidget effectiveDate = new TypedDateBoxWidget( new DateConverter(

            constants.dateFormat(), constants.dateFormat() ) );

    private final TypedTextAreaWidget<String> notesTextArea = new TypedTextAreaWidget<String>(

            new StringConverter() );

    private ListBoxWidget<UiDeliveryLocation> locationListBox;

    private ListBoxWidget<UiPlatform> platformListBox;

    private ListBoxWidget<UiDevice> deviceListBox;



    private DocumentComponentFactory documentComponent;

    private List<UiDocument> documentsList = new ArrayList<UiDocument>();



    private final UiLicense uiLicense;

    private UiDeal uiDeal;

    private final ErrorPanel errorPanel;



    // Server loaded lists control

    private final BusyIndicator busyIndicator = new BusyIndicator();

    private boolean copyrightHoldersLoaded = false;

    private boolean contractsLoaded = false;

    private boolean dealsLoaded = false;

    private boolean contentProvidersLoaded = false;

    private boolean locationsLoaded = false;

    private boolean platformsLoaded = false;

    private boolean devicesLoaded = false;

    private boolean typesLoaded = false;

    private boolean fieldsLoaded = false;



    private FormPanel form;

    private AssetsTable assetsTable;



    public LicenseMainForm( UiLicense uiLicense, ErrorPanel errorPanel,

            HorizontalAlignmentConstant buttonPanelHAlign ) {

        super( buttonPanelHAlign );

        this.uiLicense = uiLicense;

        this.errorPanel = errorPanel;



        init();

    }



    public void validateWithMessages() throws ValidationException {



        List<String> validationMessages = new ArrayList<String>();

        if ( super.validate() && uiDeal != null ) {

            Date creationDateNoTime = resetTime( creationDate.getDatePicker().getValue() );

            Date effectiveDateNoTime = resetTime( effectiveDate.getDatePicker().getValue() );

            Date expiryDateNoTime = resetTime( expiryDate.getDatePicker().getValue() );

            Date dealCreationDateNoTime = resetTime( uiDeal.getCreationDate() );

            Date dealEffectiveDateNoTime = resetTime( uiDeal.getEffectiveDate() );

            Date dealExpiryDateNoTime = resetTime( uiDeal.getExpiryDate() );



            if ( notesTextArea.getText().length() > 250 ) {

                validationMessages.add( messages.maxFieldLength( constants.licenseNotesColumn(), 250 ) );

            }



            DateTimeFormat dateFormatter = DateTimeFormat.getFormat( constants.dateFormat() );

            if ( creationDateNoTime.after( effectiveDateNoTime ) ) {

                validationMessages

                .add( messages.dateNotAfterError( constants.licenseCreationDateColumn(),

                        constants.licenseEffectiveDateColumn(),

                        dateFormatter.format( effectiveDateNoTime ) ) );

            }



            if ( creationDateNoTime.before( dealCreationDateNoTime ) ) {

                validationMessages.add( messages.dateNotBeforeError( constants.licenseCreationDateColumn(),

                        constants.licenseDealColumn() + " " + constants.licenseCreationDateColumn(),

                        dateFormatter.format( dealCreationDateNoTime ) ) );

            }



            if ( effectiveDateNoTime.before( dealEffectiveDateNoTime ) ) {

                validationMessages.add( messages.dateNotBeforeError( constants.licenseEffectiveDateColumn(),

                        constants.licenseDealColumn() + " " + constants.licenseEffectiveDateColumn(),

                        dateFormatter.format( dealEffectiveDateNoTime ) ) );

            }



            if ( !effectiveDateNoTime.before( dealExpiryDateNoTime ) ) {

                validationMessages.add( messages.dateBeforeError( constants.licenseEffectiveDateColumn(),

                        constants.licenseDealColumn() + " " + constants.licenseExpiryDateColumn(),

                        dateFormatter.format( dealExpiryDateNoTime ) ) );

            }



            if ( !expiryDateNoTime.after( effectiveDateNoTime ) ) {

                validationMessages

                .add( messages.dateAfterError( constants.licenseExpiryDateColumn(),

                        constants.licenseEffectiveDateColumn(),

                        dateFormatter.format( effectiveDateNoTime ) ) );

            }



            if ( !expiryDateNoTime.after( dealEffectiveDateNoTime ) ) {

                validationMessages.add( messages.dateAfterError( constants.licenseExpiryDateColumn(),

                        constants.licenseDealColumn() + " " + constants.licenseEffectiveDateColumn(),

                        dateFormatter.format( dealEffectiveDateNoTime ) ) );

            }



            if ( expiryDateNoTime.after( dealExpiryDateNoTime ) ) {

                validationMessages.add( messages.dateNotAfterError( constants.licenseExpiryDateColumn(),

                        constants.licenseDealColumn() + " " + constants.licenseExpiryDateColumn(),

                        dateFormatter.format( dealExpiryDateNoTime ) ) );

            }



            validateCustomFields( validationMessages );



        } else {

            validationMessages.add( messages.formHasValidationErrors() );

        }



        boolean locationSelected = false;

        for ( int x = 0; x < locationListBox.getItemCount(); x++ ) {

            if ( locationListBox.isItemSelected( x ) ) {

                locationSelected = true;

                break;

            }

        }

        if ( !locationSelected ) {

            validationMessages.add( messages.deliveryLocationNotSelected() );

        }



        if ( !validationMessages.isEmpty() ) {

            throw new ValidationException( validationMessages );

        }



    }



    @SuppressWarnings("deprecation")

    private Date resetTime( Date date ) {

        long msec = date.getTime();

        msec = msec / 1000 * 1000;

        Date resetDate = new Date( msec );



        resetDate.setHours( 0 );

        resetDate.setMinutes( 0 );

        resetDate.setSeconds( 0 );



        return resetDate;

    }



    private void init() {

        busyIndicator.center();

        UiDeal deal = uiLicense.getDeal();

        UiContract contract = deal.getContract();

        UiCopyrightHolder copyrightHolder = contract.getCopyrightHolder();



        documentComponent = new DocumentComponentFactory( uiLicense.getKey(), constants.licenseDocuments(),

                UiDocumentType.LICENSE, errorPanel );

        form = documentComponent.getDocumentPanel();



        if ( !isEditing() ) {

            copyrightHolderListBox = new TypedListBoxWidget<Long>( new IntegerConverter() );

            copyrightHolderListBox.ensureDebugId("license-copyrightHolder");

            copyrightHolderListBox.addValueChangeHandler( new ValueChangeHandler<Long>() {



                @Override

                public void onValueChange( ValueChangeEvent<Long> event ) {

                    contractsLoaded = false;

                    busyIndicator.center();

                    loadContractListBox( contractListBox, copyrightHolderListBox.getSelectedItem(), null );

                    dealListBox.clear();

                }

            } );

            loadCopyrightHolderListBox( copyrightHolderListBox, copyrightHolder.getKey() );

            addRow( constants.licenseCopyrightHolderColumn(), copyrightHolderListBox, true );



            contractListBox = new TypedListBoxWidget<Long>( new IntegerConverter() );

            contractListBox.ensureDebugId("license-contract");

            contractListBox.addValueChangeHandler( new ValueChangeHandler<Long>() {



                @Override

                public void onValueChange( ValueChangeEvent<Long> event ) {

                    dealsLoaded = false;

                    busyIndicator.center();

                    loadDealListBox( dealListBox, contractListBox.getSelectedItem(), null );

                }

            } );

            loadContractListBox( contractListBox, copyrightHolder.getKey(), contract.getKey() );

            addRow( constants.licenseContractColumn(), contractListBox, true );



            dealListBox = new TypedListBoxWidget<Long>( new IntegerConverter() );

            dealListBox.ensureDebugId("license-deal");

            dealListBox.addValueChangeHandler( new ValueChangeHandler<Long>() {



                @Override

                public void onValueChange( ValueChangeEvent<Long> event ) {

                    if ( uiLicense.getKey() == null && event.getValue() != null ) {

                        busyIndicator.center();

                        contractManagerService.getDeal( event.getValue(), new NeptuneAsyncCallback<UiDeal>() {



                            @Override

                            public void onNeptuneFailure( Throwable caught ) {

                                busyIndicator.hide();

                            }



                            @Override

                            public void onNeptuneSuccess( UiDeal result ) {

                                uiLicense.setDeal( result );

                                busyIndicator.hide();

                            }

                        } );

                    }

                }

            } );

            loadDealListBox( dealListBox, contract.getKey(), deal.getKey() );

            addRow( constants.licenseDealColumn(), dealListBox, true );

        } else {

            TextBoxWidget copyrightHolderTextBox = new TextBoxWidget( copyrightHolder.getName() );

            TextBoxWidget contractTextBox = new TextBoxWidget( contract.getName() );

            TextBoxWidget dealTextBox = new TextBoxWidget( deal.getName() );

            copyrightHolderTextBox.setEnabled( false );

            contractTextBox.setEnabled( false );

            dealTextBox.setEnabled( false );



            addRow( constants.licenseCopyrightHolderColumn(), copyrightHolderTextBox );

            addRow( constants.licenseContractColumn(), contractTextBox );

            addRow( constants.licenseDealColumn(), dealTextBox );

            copyrightHoldersLoaded = true;

            contractsLoaded = true;

            dealsLoaded = true;



            documentsList = uiLicense.getDocumentsList();

            documentComponent.setDocumentsList( documentsList );

        }



        externalIdTextBox.setValue(uiLicense.getExternalId());

        externalIdTextBox.setMaxLength(EXTERNAL_ID_MAX_LENGTH);

        addRow(constants.externalID(), externalIdTextBox);



        nameTextBox.setText( uiLicense.getName() );

        nameTextBox.setMaxLength( NAME_MAX_LENGHT );

        nameTextBox.ensureDebugId("license-name");

        addRow( constants.licenseNameColumn(), nameTextBox, true );



        activeCheckBox.setValue( uiLicense.isActive() );

        activeCheckBox.ensureDebugId("license-active");

        addRow( constants.licenseActiveColumn(), activeCheckBox, true );



        typeListBox = new TypedListBoxWidget<Long>( new IntegerConverter() );

        typeListBox.ensureDebugId("license-type");

        loadTypeListBox( typeListBox, uiLicense.getType().getKey() );

        addRow( constants.licenseTypeColumn(), typeListBox, true );



        configureDateBoxWidget( creationDate, uiLicense.getCreationDate() );

        creationDate.ensureDebugId("license-creationDate");

        addRow( constants.licenseCreationDateColumn(), creationDate, true );



        configureDateBoxWidget( effectiveDate, uiLicense.getEffectiveDate() );

        effectiveDate.ensureDebugId("license-effectiveDate");

        addRow( constants.licenseEffectiveDateColumn(), effectiveDate, true );



        configureDateBoxWidget( expiryDate, uiLicense.getExpiryDate() );

        expiryDate.ensureDebugId("license-expiryDate");

        addRow( constants.licenseExpiryDateColumn(), expiryDate, true );



        notesTextArea.setCharacterWidth( NOTES_CHAR_WIDTH );

        notesTextArea.setVisibleLines( NOTES_VISIBLE_COUNT );

        notesTextArea.setValue( uiLicense.getNotes() );



        addRow( constants.licenseNotesColumn(), notesTextArea, false );



        contentProviderListBox = new TypedListBoxWidget<String>( new StringConverter() );

        loadContentProviderListBox( contentProviderListBox, uiLicense.getContentProvider().getProviderId() );

        addRow( constants.licenseContentProvider(), contentProviderListBox, false );

        if ( isEditing() ) {

            contentProviderListBox.setEnabled( false );

        }



        locationListBox = new ListBoxWidget<UiDeliveryLocation>( true );

        locationListBox.setWidth( CONTENT_LISTBOX_WIDTH );

        locationListBox.ensureDebugId("license-site");

        loadLocationListBox( locationListBox, uiLicense.getDeliveryLocations() );

        addRow( constants.licenseLocation(), locationListBox, true );



        platformListBox = new ListBoxWidget<UiPlatform>( true );

        platformListBox.setWidth( CONTENT_LISTBOX_WIDTH );

        platformListBox.addChangeHandler( new ChangeHandler() {



            @Override

            public void onChange( ChangeEvent event ) {

                List<UiPlatform> selectedPlatforms = new ArrayList<UiPlatform>();

                for ( int x = 0; x < platformListBox.getItemCount(); x++ ) {

                    if ( platformListBox.isItemSelected( x ) ) {

                        selectedPlatforms.add( platformListBox.getItem( x ) );

                    }

                }

                devicesLoaded = false;

                busyIndicator.center();

                List<UiDevice> selectedDevices = new ArrayList<UiDevice>();

                for ( int x=0; x<deviceListBox.getItemCount(); x++ ) {

                    if ( deviceListBox.isItemSelected( x ) ) {

                        selectedDevices.add( deviceListBox.getItem( x ) );

                    }

                }

                loadDeviceListBox( deviceListBox, selectedPlatforms, selectedDevices );

            }

        } );

        loadPlatformListBox( platformListBox, uiLicense.getPlatforms() );

        addRow( constants.licensePlatform(), platformListBox, false );



        deviceListBox = new ListBoxWidget<UiDevice>( true );

        deviceListBox.setWidth( CONTENT_LISTBOX_WIDTH );

        loadDeviceListBox( deviceListBox, uiLicense.getPlatforms(), uiLicense.getDevices() );

        addRow( constants.licenseDevice(), deviceListBox, false );



        contractManagerService

        .getLicenseUserDefinedFields( new NeptuneAsyncCallback<List<UiUserDefinedField>>() {



            @Override

            public void onNeptuneFailure( Throwable caught ) {

                errorPanel.showMessage( caught.getLocalizedMessage() );

                fieldsLoaded = true;

                stopBusyIndicator();

            }



            @Override

            public void onNeptuneSuccess( List<UiUserDefinedField> result ) {

                uiLicense.getUserDefinedFields().clear();

                uiLicense.getUserDefinedFields().addAll( result );

                CustomFieldFactory factory = new CustomFieldFactory( null );



                factory.addFieldsToForm( LicenseMainForm.this,

                        uiLicense.getUserDefinedFields( CustomFieldFactory.LICENSE_SCREEN ),

                        widgetCustomFieldMap );

                createUpdateUserDefinedFieldValues();

                updateFormFromUserDefinedFieldValues( uiLicense.getUserDefinedFieldsValues() );

                fieldsLoaded = true;



                addRow( "", new LabelWidget() );

                addRow( constants.copyrightHolderUploadDocument(), form );

                documentsList = uiLicense.getDocumentsList();

                for ( UiDocument doc : documentsList ) {

                    documentComponent.addRow( doc );

                }



                addRow( "", new LabelWidget() );

                assetsTable = new AssetsTable( uiLicense, errorPanel );

                addRow( constants.storageAssetsInLicenseColumn(), assetsTable );

                stopBusyIndicator();

            }



        } );



    }



    private boolean isEditing() {

        return uiLicense.getKey() != null;

    }



    private void createUpdateUserDefinedFieldValues() {

        for ( UiUserDefinedField uiUserDefinedField : widgetCustomFieldMap.values() ) {

            UiUserDefinedFieldValue uiUserDefinedFieldValue = findUiUserDefinedFieldValue(

                    uiUserDefinedField.getIdUserDefinedField(), uiLicense.getUserDefinedFieldsValues() );

            if ( uiUserDefinedFieldValue == null ) {

                uiUserDefinedFieldValue = new UiUserDefinedFieldValue();

                uiUserDefinedFieldValue.setIdUserDefinedField( uiUserDefinedField.getIdUserDefinedField() );

                uiUserDefinedFieldValue.setValue( uiUserDefinedField.getDefaultValue() );

                uiLicense.getUserDefinedFieldsValues().add( uiUserDefinedFieldValue );

            }

        }

    }



    private UiUserDefinedFieldValue findUiUserDefinedFieldValue( Long idUserDefinedField,

            List<UiUserDefinedFieldValue> userDefinedFieldsValues ) {

        UiUserDefinedFieldValue uiUserDefinedFieldValue = null;

        for ( UiUserDefinedFieldValue fieldValue : userDefinedFieldsValues ) {

            if ( fieldValue.getIdUserDefinedField() != null

                    && fieldValue.getIdUserDefinedField().equals( idUserDefinedField ) ) {

                uiUserDefinedFieldValue = fieldValue;

                break;

            }

        }

        return uiUserDefinedFieldValue;

    }



    private TypedListBoxWidget<Long> loadCopyrightHolderListBox(

            final TypedListBoxWidget<Long> lbCopyrightHolder, final Long selected ) {



        contractManagerDropDownService

        .getCopyrightHolderKeyNameList( new NeptuneAsyncCallback<List<UiKeyName>>() {



            @Override

            public void onNeptuneFailure( Throwable caught ) {

                errorPanel.addMessage( constants.failureGettingCopyrightHolders() );

                copyrightHoldersLoaded = true;

                stopBusyIndicator();

            }



            @Override

            public void onNeptuneSuccess( List<UiKeyName> result ) {

                fillListBox( lbCopyrightHolder, selected, result );

                copyrightHoldersLoaded = true;

                stopBusyIndicator();

            }

        } );



        return lbCopyrightHolder;

    }



    private void loadContractListBox( final TypedListBoxWidget<Long> lbContract, Long copyrightHolderKey,

            final Long selected ) {

        lbContract.clear();

        contractManagerDropDownService.getContractKeyNameList( copyrightHolderKey,

                new NeptuneAsyncCallback<List<UiKeyName>>() {



            @Override

            public void onNeptuneFailure( Throwable caught ) {

                errorPanel.addMessage( constants.failureGettingContracts() );

                contractsLoaded = true;

                stopBusyIndicator();

            }



            @Override

            public void onNeptuneSuccess( List<UiKeyName> result ) {

                fillListBox( lbContract, selected, result );

                contractsLoaded = true;

                stopBusyIndicator();

            }

        } );



    }



    private void loadDealListBox( final TypedListBoxWidget<Long> lbDeal, Long contractKey, final Long selected ) {

        lbDeal.clear();

        contractManagerDropDownService.getDealKeyNameList( contractKey,

                new NeptuneAsyncCallback<List<UiKeyName>>() {



            @Override

            public void onNeptuneFailure( Throwable caught ) {

                errorPanel.addMessage( constants.failureGettingDeals() );

                dealsLoaded = true;

                stopBusyIndicator();

            }



            @Override

            public void onNeptuneSuccess( List<UiKeyName> result ) {

                fillListBox( lbDeal, selected, result );

                dealsLoaded = true;

                stopBusyIndicator();

            }



        } );

    }



    private void loadTypeListBox( final TypedListBoxWidget<Long> lbType, final Long selected ) {

        lbType.clear();

        contractManagerDropDownService.getGenericDropDownKeyNameList( 0, 0, "", true,

                ConfigurableFieldTypeEnum.LicenseType, new NeptuneAsyncCallback<UiKeyNames>() {



            @Override

            public void onNeptuneFailure( Throwable caught ) {

                errorPanel.addMessage( constants.failureGettingTypes() );

                typesLoaded = true;

                stopBusyIndicator();

            }



            @Override

            public void onNeptuneSuccess( UiKeyNames result ) {

                fillListBox( lbType, selected, result.getRecords() );

                typesLoaded = true;

                stopBusyIndicator();

            }

        } );

    }



    private void loadContentProviderListBox( final TypedListBoxWidget<String> lbContentProvider,

            final String selected ) {



        lbContentProvider.clear();

        contractManagerDropDownService.getContentProvidersList( new NeptuneAsyncCallback<List<UiContentProvider>>() {



            @Override

            public void onNeptuneFailure( Throwable caught ) {

                errorPanel.addMessage( constants.failureGettingContentProviders() );

                contentProvidersLoaded = true;

                stopBusyIndicator();

            }



            @Override

            public void onNeptuneSuccess( List<UiContentProvider> result ) {

                lbContentProvider.addItem( "", null );

                Collections.sort(result);

                for ( UiContentProvider contentProvider : result ) {

                    lbContentProvider.addItem( contentProvider.getName(), contentProvider.getProviderId() );

                }

                lbContentProvider.setSelectedItem( selected );

                for ( int x = 0; x < lbContentProvider.getItemCount(); x++ ) {

                    if (selected != null && selected.equals(lbContentProvider.getItem(x))) {

                        lbContentProvider.setItemSelected(x, true);

                        break;

                    }

                }

                contentProvidersLoaded = true;

                stopBusyIndicator();

            }

        } );

    }



    private void loadLocationListBox( final ListBoxWidget<UiDeliveryLocation> lbLocation,

            final List<UiDeliveryLocation> selectedLocations ) {

        lbLocation.clear();

        contractManagerDropDownService

        .getDeliveryLocationList( new NeptuneAsyncCallback<List<UiDeliveryLocation>>() {



            @Override

            public void onNeptuneFailure( Throwable caught ) {

                errorPanel.addMessage( constants.failureGettingDeliveryLocations() );

                locationsLoaded = true;

                stopBusyIndicator();

            }



            @Override

            public void onNeptuneSuccess( List<UiDeliveryLocation> result ) {

                Collections.sort( result, new Comparator<UiDeliveryLocation>() {



                    @Override

                    public int compare( UiDeliveryLocation location1, UiDeliveryLocation location2 ) {

                        return location1.getName().toUpperCase()

                                .compareTo( location2.getName().toUpperCase() );

                    }

                } );



                for ( UiDeliveryLocation location : result ) {

                    lbLocation.addItem( location.getName(), location );

                    for ( UiDeliveryLocation selectedLocation : selectedLocations ) {

                        if ( selectedLocation.getName().equals( location.getName() ) ) {

                            lbLocation.setItemSelected( lbLocation.getIndex( location ), true );

                            break;

                        }

                    }

                }

                locationsLoaded = true;

                stopBusyIndicator();

            }

        } );

    }



    private void loadPlatformListBox( final ListBoxWidget<UiPlatform> lbPlatform,

            final List<UiPlatform> selectedPlatforms ) {

        lbPlatform.clear();

        contractManagerDropDownService.getPlatformList( new NeptuneAsyncCallback<List<UiPlatform>>() {



            @Override

            public void onNeptuneFailure( Throwable caught ) {

                errorPanel.addMessage( constants.failureGettingPlatforms() );

                platformsLoaded = true;

                stopBusyIndicator();

            }



            @Override

            public void onNeptuneSuccess( List<UiPlatform> result ) {

                Collections.sort( result, new Comparator<UiPlatform>() {



                    @Override

                    public int compare( UiPlatform platform1, UiPlatform platform2 ) {

                        return platform1.getName().toUpperCase()

                                .compareTo( platform2.getName().toUpperCase() );

                    }

                } );



                for ( UiPlatform platform : result ) {

                    lbPlatform.addItem( platform.getName(), platform );

                }

                for ( UiPlatform platform : result ) {

                    for ( UiPlatform selectedPlatform : selectedPlatforms ) {

                        if ( selectedPlatform.getKey().equals( platform.getKey() ) ) {

                            lbPlatform.setItemSelected( lbPlatform.getIndex( platform ), true );

                            break;

                        }

                    }

                }

                platformsLoaded = true;

                stopBusyIndicator();

            }

        } );

    }



    private void loadDeviceListBox( final ListBoxWidget<UiDevice> lbDevice,

            final List<UiPlatform> selectedPlatforms, final List<UiDevice> selectedDevices ) {

        contractManagerDropDownService.getDeviceList( selectedPlatforms,

                new NeptuneAsyncCallback<List<UiDevice>>() {



            @Override

            public void onNeptuneFailure( Throwable caught ) {

                errorPanel.addMessage( constants.failureGettingDevices() );

                devicesLoaded = true;

                stopBusyIndicator();

            }



            @Override

            public void onNeptuneSuccess( List<UiDevice> result ) {



                Collections.sort( result, new Comparator<UiDevice>() {



                    @Override

                    public int compare( UiDevice device1, UiDevice device2 ) {

                        int compareResult = device1.getPlatform().getName().toUpperCase()

                                .compareTo( device2.getPlatform().getName().toUpperCase() );

                        if ( compareResult == 0 ) {

                            compareResult = device1.getName().toUpperCase()

                                    .compareTo( device2.getName().toUpperCase() );

                        }

                        return compareResult;

                    }

                } );



                lbDevice.clear();

                for ( UiDevice device : result ) {

                    lbDevice.addItem( device.getName() + " (" + device.getPlatform().getName() + ")",

                            device );

                    for ( UiDevice selectedDevice : selectedDevices ) {

                        if ( selectedDevice.getKey().equals( device.getKey() ) ) {

                            lbDevice.setItemSelected( lbDevice.getIndex( device ), true );

                            break;

                        }

                    }

                }

                devicesLoaded = true;

                stopBusyIndicator();

            }

        } );

    }



    private void fillListBox( final TypedListBoxWidget<Long> listBox, final Long selected,

            List<UiKeyName> result ) {

        listBox.addItem( "", null );

        for ( UiKeyName keyName : result ) {

            listBox.addItem( keyName.getName(), keyName.getKey() );

        }

        listBox.setSelectedItem( selected );

    }



    private void configureDateBoxWidget( TypedDateBoxWidget dateBox, Date date ) {

        dateBox.setTextValue( convertDateToString( date, constants.dateFormat() ) );

        dateBox.getTextBox().setMaxLength( VISIBLE_LENGTH );

        dateBox.getTextBox().setVisibleLength( VISIBLE_LENGTH );

        dateBox.setToolTip( constants.validDateTitle() + " " + constants.dateFormat() );

        dateBox.setErrorToolTip( constants.validDateTitle() + " " + constants.dateFormat() );

    }



    private String convertDateToString( Date date, String dateFormat ) {

        String dateText = "";

        if ( date != null ) {

            DateTimeFormat dateFormatter = DateTimeFormat.getFormat( dateFormat );

            dateText = dateFormatter.format( date );

        }

        return dateText;

    }



    public void setDeal( UiDeal deal ) {

        this.uiDeal = deal;

    }





    public void commit() {



        UiContentProvider uiContentProvider = new UiContentProvider( contentProviderListBox.getSelectedItem() );

        uiContentProvider.setName( contentProviderListBox.getItemText( contentProviderListBox

                .getSelectedIndex() ) );

        uiLicense.setContentProvider( uiContentProvider );

        uiLicense.setAllAssets( assetsTable.allAssetsSelected() );



        uiLicense.setCreationDate( creationDate.getDatePicker().getValue() );

        uiLicense.setEffectiveDate( effectiveDate.getDatePicker().getValue() );

        uiLicense.setExpiryDate( expiryDate.getDatePicker().getValue() );

        uiLicense.setName( nameTextBox.getValue() );

        uiLicense.setNotes( notesTextArea.getValue() );

        uiLicense.setType( new UiKeyName( typeListBox.getSelectedItem() ) );

        uiLicense.setDocumentsList(documentsList );

        uiLicense.setActive(activeCheckBox.getValue());

        uiLicense.setExternalId(externalIdTextBox.getText() != null ? externalIdTextBox.getText().trim() : null);







        uiLicense.getDeliveryLocations().clear();

        for ( int x = 0; x < locationListBox.getItemCount(); x++ ) {

            if ( locationListBox.isItemSelected( x ) ) {

                UiDeliveryLocation deliveryLocation = locationListBox.getItem( x );

                if ( deliveryLocation != null ) {

                    uiLicense.getDeliveryLocations().add( deliveryLocation );

                }

            }

        }



        uiLicense.getPlatforms().clear();

        for ( int x = 0; x < platformListBox.getItemCount(); x++ ) {

            if ( platformListBox.isItemSelected( x ) ) {

                UiPlatform platform = platformListBox.getItem( x );

                if ( platform != null ) {

                    uiLicense.getPlatforms().add( platform );

                }

            }

        }



        uiLicense.getDevices().clear();

        for ( int x = 0; x < deviceListBox.getItemCount(); x++ ) {

            if ( deviceListBox.isItemSelected( x ) ) {

                UiDevice device = deviceListBox.getItem( x );

                if ( device != null ) {

                    uiLicense.getDevices().add( device );

                }

            }

        }



        updateUserDefinedFieldsValuesFromForm( uiLicense.getUserDefinedFieldsValues() );

    }



    private void updateUserDefinedFieldsValuesFromForm( Collection<UiUserDefinedFieldValue> oldValuesList ) {

        Set<Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = widgetCustomFieldMap.entrySet();

        for ( Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet ) {

            DataTypeWidget<?> dataTypeWidget = entry.getKey();

            UiUserDefinedField userDefinedField = entry.getValue();

            UiUserDefinedFieldValue userDefinedFieldValue = getValueForFieldType( oldValuesList,

                    userDefinedField.getIdUserDefinedField() );

            if ( userDefinedFieldValue != null ) {

                userDefinedFieldValue.setValue( dataTypeWidget.getTextValue() );

            }

        }

    }



    private void updateFormFromUserDefinedFieldValues( Collection<UiUserDefinedFieldValue> newValuesList ) {



        Set<Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = widgetCustomFieldMap.entrySet();

        for ( Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet ) {

            DataTypeWidget<?> dataTypeWidget = entry.getKey();

            UiUserDefinedField userDefinedField = entry.getValue();

            UiUserDefinedFieldValue userDefinedFieldValue = getValueForFieldType( newValuesList,

                    userDefinedField.getIdUserDefinedField() );

            if ( userDefinedFieldValue != null ) {

                dataTypeWidget.setTextValue( userDefinedFieldValue.getValue() );

            }

        }

    }



    private UiUserDefinedFieldValue getValueForFieldType( Collection<UiUserDefinedFieldValue> newValuesList,

            Long idUserDefinedField ) {

        UiUserDefinedFieldValue userDefinedFieldValue = null;

        for ( UiUserDefinedFieldValue newUserDefinedFieldValue : newValuesList ) {

            Long newIdUserDefinedField = newUserDefinedFieldValue.getIdUserDefinedField();

            if ( newIdUserDefinedField.equals( idUserDefinedField ) ) {

                userDefinedFieldValue = newUserDefinedFieldValue;

                break;

            }

        }



        return userDefinedFieldValue;

    }



    private void stopBusyIndicator() {

        if ( copyrightHoldersLoaded && contractsLoaded && dealsLoaded && contentProvidersLoaded

                && locationsLoaded && platformsLoaded && devicesLoaded && typesLoaded && fieldsLoaded ) {

            busyIndicator.hide();

        }

    }



    private void validateCustomFields( List<String> validationMessages ) {

        Set<Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = widgetCustomFieldMap.entrySet();

        for ( Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet ) {

            DataTypeWidget<?> dataTypeWidget = entry.getKey();

            UiUserDefinedField field = entry.getValue();

            CustomFieldValidator.validate( dataTypeWidget, field );

            if ( !dataTypeWidget.isValidValue() || dataTypeWidget.hasValidationError() ) {

                String tooltip = dataTypeWidget.getToolTip();

                if ( tooltip == null ) {

                    tooltip = "";

                }

                validationMessages.add( messages.invalidFieldValue( field.getLabel() ) + tooltip );

            }

        }

    }



}

