package com.ericsson.cms.contractmgmt.client.tab.license;

import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Represents a license record in the license list view.
 * 
 * @author Daniel Paranhos
 * 
 */
public class UiLicenseRecord implements Record<Long>, IsSerializable {

    private UiLicense license;

    public UiLicenseRecord() {
    }

    public UiLicenseRecord( UiLicense license ) {
        super();
        this.license = license;
    }

    @Override
    public Long getKey() {
        return license.getKey();
    }

    /**
     * @return the license
     */
    public UiLicense getLicense() {
        return license;
    }

    /**
     * @param license
     *            the license to set
     */
    public void setLicense( UiLicense license ) {
        this.license = license;
    }

}
