package com.ericsson.cms.contractmgmt.client.tab.license.tab;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.license.AbstractLicenseTab;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseDetailView;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class AssetEnhancementTab extends AbstractLicenseTab {

    private final ContractFormContainer formContainer = new ContractFormContainer(
            HasHorizontalAlignment.ALIGN_LEFT );
    private RadioButtonWidget watermarkingRequiredYes;
    private RadioButtonWidget watermarkingRequiredNo;
    private RadioButtonWidget fingerprintingRequiredYes;
    private RadioButtonWidget fingerprintingRequiredNo;
    private RadioButtonWidget transcodingRequiredYes;
    private RadioButtonWidget transcodingRequiredNo;
    private RadioButtonWidget adRemovalAllowedYes;
    private RadioButtonWidget adRemovalAllowedNo;
    private RadioButtonWidget contentEditAllowedYes;
    private RadioButtonWidget contentEditAllowedNo;
    private RadioButtonWidget qualityCheckRequiredYes;
    private RadioButtonWidget qualityCheckRequiredNo;
    private RadioButtonWidget contentSecurityRequiredYes;
    private RadioButtonWidget contentSecurityRequiredNo;

    public AssetEnhancementTab( UiLicense license, LicenseDetailView detailView ) {
        super( license, detailView );
        initForm();
        fillForm();
    }

    private void initForm() {

        watermarkingRequiredYes = new RadioButtonWidget( "watermarking", constants.yes() );
        watermarkingRequiredYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        watermarkingRequiredNo = new RadioButtonWidget( "watermarking", constants.no() );
        watermarkingRequiredNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        HorizontalContainer watermarkingRequired = createRadioContainer( watermarkingRequiredYes,
                watermarkingRequiredNo );
        formContainer.addRow( constants.assetWatermarkingColumn(), watermarkingRequired );

        fingerprintingRequiredYes = new RadioButtonWidget( "fingerprinting", constants.yes() );
        fingerprintingRequiredYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        fingerprintingRequiredNo = new RadioButtonWidget( "fingerprinting", constants.no() );
        fingerprintingRequiredNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        HorizontalContainer fingerprintingRequired = createRadioContainer( fingerprintingRequiredYes,
                fingerprintingRequiredNo );
        formContainer.addRow( constants.assetFingerprintingColumn(), fingerprintingRequired );

        transcodingRequiredYes = new RadioButtonWidget( "transcoding", constants.yes() );
        transcodingRequiredYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        transcodingRequiredNo = new RadioButtonWidget( "transcoding", constants.no() );
        transcodingRequiredNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        HorizontalContainer transcodingRequired = createRadioContainer( transcodingRequiredYes,
                transcodingRequiredNo );
        formContainer.addRow( constants.assetTranscodingColumn(), transcodingRequired );

        adRemovalAllowedYes = new RadioButtonWidget( "adRemoval", constants.yes() );
        adRemovalAllowedYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        adRemovalAllowedNo = new RadioButtonWidget( "adRemoval", constants.no() );
        adRemovalAllowedNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        HorizontalContainer adRemovalAllowed = createRadioContainer( adRemovalAllowedYes, adRemovalAllowedNo );
        formContainer.addRow( constants.assetAdRemovalColumn(), adRemovalAllowed );

        contentEditAllowedYes = new RadioButtonWidget( "contentEdit", constants.yes() );
        contentEditAllowedYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        contentEditAllowedNo = new RadioButtonWidget( "contentEdit", constants.no() );
        contentEditAllowedNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        HorizontalContainer contentEditAllowed = createRadioContainer( contentEditAllowedYes,
                contentEditAllowedNo );
        formContainer.addRow( constants.assetContentEditColumn(), contentEditAllowed );

        qualityCheckRequiredYes = new RadioButtonWidget( "qualityCheck", constants.yes() );
        qualityCheckRequiredYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        qualityCheckRequiredNo = new RadioButtonWidget( "qualityCheck", constants.no() );
        qualityCheckRequiredNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        HorizontalContainer qualityCheckAllowed = createRadioContainer( qualityCheckRequiredYes,
                qualityCheckRequiredNo );
        formContainer.addRow( constants.assetQualityCheckColumn(), qualityCheckAllowed );

        contentSecurityRequiredYes = new RadioButtonWidget( "contentSecurity", constants.yes() );
        contentSecurityRequiredYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        contentSecurityRequiredNo = new RadioButtonWidget( "contentSecurity", constants.no() );
        contentSecurityRequiredNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        HorizontalContainer contentSecurityAllowed = createRadioContainer( contentSecurityRequiredYes,
                contentSecurityRequiredNo );
        formContainer.addRow( constants.assetContentSecurityColumn(), contentSecurityAllowed );

        CustomFieldFactory factory = new CustomFieldFactory( this );
        List<UiUserDefinedField> userDefinedFields = getLicense().getUserDefinedFields(
                CustomFieldFactory.ASSET_ENHANCEMENT_SCREEN );
        factory.addFieldsToForm( formContainer, userDefinedFields, widgetCustomFieldMap );

        
        boolean isCreating = getLicense().getKey() == null;
        if ( ( isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE ) )
                || ( !isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) ) ) {
            formContainer.addButton( getApplyChangesButton() );
        }
        contentPanel.add( formContainer );
    }

    private HorizontalContainer createRadioContainer( RadioButtonWidget radio1, RadioButtonWidget radio2 ) {
        HorizontalContainer container = new HorizontalContainer();

        container.add( radio1 );

        HorizontalPanel space = new HorizontalPanel();
        LabelWidget label = new LabelWidget();
        space.add( label );
        space.setCellWidth( label, "10" );
        container.add( space );

        radio2.setValue( true );
        container.add( radio2 );

        return container;
    }

    @Override
    public String getName() {
        return CustomFieldFactory.ASSET_ENHANCEMENT_SCREEN;
    }

    @Override
    public String getDisplayName() {
        return constants.assetTabDisplayName();
    }

    @Override
    public void fillForm() {
        formContainer.clearAllValidationErrors();

        fillRadioValues( watermarkingRequiredYes, watermarkingRequiredNo,
                currentTreeObject.getAeWaterMarking() );
        fillRadioValues( fingerprintingRequiredYes, fingerprintingRequiredNo,
                currentTreeObject.getAeFingerPrinting() );
        fillRadioValues( transcodingRequiredYes, transcodingRequiredNo, currentTreeObject.getAeTranscoding() );
        fillRadioValues( adRemovalAllowedYes, adRemovalAllowedNo, currentTreeObject.getAeAdRemoval() );
        fillRadioValues( contentEditAllowedYes, contentEditAllowedNo, currentTreeObject.getAeContentEdit() );
        fillRadioValues( qualityCheckRequiredYes, qualityCheckRequiredNo,
                currentTreeObject.getAeQualityCheck() );
        fillRadioValues( contentSecurityRequiredYes, contentSecurityRequiredNo,
                currentTreeObject.getAeContentSecurity() );

        updateFormFromUserDefinedFieldValues( currentTreeObject.getUserDefinedFieldValues() );
    }

    private void fillRadioValues( RadioButtonWidget radio1, RadioButtonWidget radio2, Boolean value ) {
        if ( ( value != null ) &&  value ) {
            radio1.setValue( true );
            radio2.setValue( false );
        } else {
            radio1.setValue( false );
            radio2.setValue( true );
        }
    }

    @Override
    public void validate() throws ValidationException {
        formContainer.clearAllValidationErrors();
        List<String> validationMessages = new ArrayList<String>();
        if ( !formContainer.validate() ) {
            validationMessages.add( messages.formHasValidationErrors() );
        }

        validateCustomFields( validationMessages );
        
        if ( !validationMessages.isEmpty() ) {
            throw new ValidationException( validationMessages );
        }
    }

    @Override
    public void commit() throws ValidationException {
        currentTreeObject.setModified( true );
        currentTreeObject.setAeAdRemoval( adRemovalAllowedYes.getValue() );
        currentTreeObject.setAeContentEdit( contentEditAllowedYes.getValue() );
        currentTreeObject.setAeContentSecurity( contentSecurityRequiredYes.getValue() );
        currentTreeObject.setAeFingerPrinting( fingerprintingRequiredYes.getValue() );
        currentTreeObject.setAeQualityCheck( qualityCheckRequiredYes.getValue() );
        currentTreeObject.setAeTranscoding( transcodingRequiredYes.getValue() );
        currentTreeObject.setAeWaterMarking( watermarkingRequiredYes.getValue() );

        updateUserDefinedFieldsValuesFromForm( currentTreeObject.getUserDefinedFieldValues() );

        overrideChildrenValues();
    }

    private void overrideChildrenValues() {
        if ( currentTreeObject != null ) {
            for ( UiLicenseDetails licenseDetails : currentTreeObject.getAllChildren() ) {
                licenseDetails.setModified( true );
                LicenseDetailsUtils.copyAssetEnhancementValues( currentTreeObject, licenseDetails );
                copyUserDefinedFieldValues( licenseDetails.getUserDefinedFieldValues() );
            }
        }
    }

}
