package com.ericsson.cms.contractmgmt.client.tab.license.tab;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionListValues;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionManagement;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.license.AbstractLicenseTab;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseDetailView;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class DistributionTab extends AbstractLicenseTab {

    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT
            .create( IContractManagerDropDownService.class );

    private final ContractFormContainer formContainer = new ContractFormContainer(
            HasHorizontalAlignment.ALIGN_LEFT );
    private UiDistributionListValues distributionListValues;

    private HorizontalContainer distributionTableContainer;
    private DistributionTable distributionTable;

    public DistributionTab( UiLicense license, final LicenseDetailView detailView ) {
        super( license, detailView );
        busyIndicator.center();
        contractManagerDropDownService
        .getDistributionListValues( new NeptuneAsyncCallback<UiDistributionListValues>() {

            @Override
            public void onNeptuneFailure( Throwable caught ) {
                detailView.getErrorPanel().showMessage( caught.getLocalizedMessage() );
                busyIndicator.hide();
            }

            @Override
            public void onNeptuneSuccess( UiDistributionListValues result ) {
                distributionListValues = result;
                initForm();
                fillForm();
                busyIndicator.hide();
            }
        } );

    }

    private void initForm() {

        LabelWidget spaceLabel = new LabelWidget();
        contentPanel.add( spaceLabel );
        contentPanel.setCellHeight( spaceLabel, "10" );

        distributionTableContainer = new HorizontalContainer();
        distributionTable = createDistributionTable();
        distributionTableContainer.add( distributionTable );
        contentPanel.add( distributionTableContainer );

        CustomFieldFactory factory = new CustomFieldFactory( this );
        List<UiUserDefinedField> userDefinedFields = getLicense().getUserDefinedFields(
                CustomFieldFactory.DISTRIBUTION_SCREEN );
        factory.addFieldsToForm( formContainer, userDefinedFields, widgetCustomFieldMap );

        boolean isCreating = getLicense().getKey() == null;
        if ( isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE )
                || !isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) ) {
            formContainer.addButton( getApplyChangesButton() );
        }

        contentPanel.add( formContainer );
    }

    private DistributionTable createDistributionTable() {
        boolean isEditing = getLicense().getKey() != null;
        DistributionTable distribution = new DistributionTable( distributionListValues, this, isEditing );
        List<UiDistributionManagement> distributionMgmtList = currentTreeObject
                .getDistributionManagementList();
        if ( distributionMgmtList != null && !distributionMgmtList.isEmpty() ) {
            for ( UiDistributionManagement distributionPlatform : distributionMgmtList ) {
                distribution.addRow( distributionPlatform );
            }
        } else {
            // Add blank row
            distribution.addRow();
        }
        return distribution;
    }

    @Override
    public String getName() {
        return CustomFieldFactory.DISTRIBUTION_SCREEN;
    }

    @Override
    public String getDisplayName() {
        return constants.distributionTabDisplayName();
    }

    @Override
    public void validate() throws ValidationException {

        formContainer.clearAllValidationErrors();

        validateUnique();

        List<String> validationMessages = new ArrayList<String>();
        if ( !formContainer.validate() ) {
            validationMessages.add( messages.formHasValidationErrors() );
        }

        Date licenseEffectiveDate = getLicense().getEffectiveDate();
        Date licenseExpiryDate = getLicense().getExpiryDate();
        List<UiDistributionManagement> dmList = distributionTable.getDistributionManagementList();
        for ( int x = 0; x < dmList.size(); x++ ) {
            UiDistributionManagement dm = dmList.get( x );
            Date deliveryDate = dm.getDeliveryDate();
            Date dueDate = dm.getDueDate();
            Date returnDate = dm.getReturnDate();

            if ( returnDate != null ) {
                if ( deliveryDate == null ) {
                    validationMessages.add( messages.deliveryDateRequired() );
                } else {
                    if ( !deliveryDate.before( returnDate ) ) {
                        validationMessages.add( messages.deliveryDateNotBeforeReturn() );
                    }
                }
            }

            if (dueDate != null && deliveryDate != null && deliveryDate.before(dueDate)) {
                validationMessages.add(messages.deliveryDateBeforeDue());
            }

            validateDatesWithin( deliveryDate, constants.platformDeliveryDateColumn(), licenseEffectiveDate,
                    licenseExpiryDate, x, validationMessages );
            validateDatesWithin( dueDate, constants.platformDueDateColumn(), licenseEffectiveDate,
                    licenseExpiryDate, x, validationMessages );
            validateDatesWithin( returnDate, constants.platformReturnDateColumn(), licenseEffectiveDate,
                    licenseExpiryDate, x, validationMessages );

        }

        validateCustomFields( validationMessages );

        if ( !validationMessages.isEmpty() ) {
            throw new ValidationException( validationMessages );
        }

    }

    private void validateDatesWithin( Date date, String field, Date d1, Date d2, int row,
            List<String> validationMessages ) {
        if (date != null && (date.compareTo(d1) < 0 || date.compareTo(d2) > 0)) {
            DateTimeFormat dateFormatter = DateTimeFormat.getFormat(constants.dateFormat());
            String d1Text = dateFormatter.format(d1);
            String d2Text = dateFormatter.format(d2);
            validationMessages.add(messages.dateNotWithinError(row + 1, field, d1Text, d2Text));
        }
    }

    private void validateUnique() throws ValidationException {
        List<UiDistributionManagement> distributionManagementList = distributionTable
                .getDistributionManagementList();
        for ( int x = 0; x < distributionManagementList.size(); x++ ) {
            UiDistributionManagement dm1 = distributionManagementList.get( x );
            Long methodKey1 = dm1.getDeliveryMethod().getKey();
            Long mediaKey1 = dm1.getMediaType().getKey();
            String formatKey1 = dm1.getMetaFormat().getName();

            for ( int y = x + 1; y < distributionManagementList.size(); y++ ) {
                UiDistributionManagement dm2 = distributionManagementList.get( y );
                Long methodKey2 = dm2.getDeliveryMethod().getKey();
                Long mediaKey2 = dm2.getMediaType().getKey();
                String formatKey2 = dm2.getMetaFormat().getName();
                if ( compareLongs( methodKey1, methodKey2 ) && compareLongs( mediaKey1, mediaKey2 )
                        && compareStrings( formatKey1, formatKey2 ) ) {
                    List<String> validationMessages = new ArrayList<String>();
                    validationMessages.add( messages.distributionManagementUniqueViolation() );
                    throw new ValidationException( validationMessages );
                }

            }
        }

    }

    private boolean compareLongs( Long value1, Long value2 ) {
        boolean isEqual = value1 == value2;
        if (!isEqual && value1 != null && value1.equals(value2)) {
            isEqual = true;
        }

        return isEqual;
    }

    private boolean compareStrings( String value1, String value2 ) {
        boolean isEqual = value1 == value2;
        if (!isEqual && value1 != null && value1.equals(value2)) {
            isEqual = true;
        }

        return isEqual;
    }

    @Override
    public void fillForm() {
        formContainer.clearAllValidationErrors();
        distributionTableContainer.clear();
        distributionTable = createDistributionTable();
        distributionTableContainer.add( distributionTable );

        updateFormFromUserDefinedFieldValues( currentTreeObject.getUserDefinedFieldValues() );
    }

    @Override
    public void commit() throws ValidationException {
        currentTreeObject.setModified( true );
        currentTreeObject.getDistributionManagementList().clear();
        currentTreeObject.getDistributionManagementList().addAll(
                distributionTable.getDistributionManagementList() );

        updateUserDefinedFieldsValuesFromForm( currentTreeObject.getUserDefinedFieldValues() );

        overrideChildrenValues();
    }

    private void overrideChildrenValues() {
        if ( currentTreeObject != null ) {
            for ( UiLicenseDetails licenseDetails : currentTreeObject.getAllChildren() ) {
                licenseDetails.setModified( true );
                LicenseDetailsUtils.copyDistributionValues( currentTreeObject, licenseDetails );
                copyUserDefinedFieldValues( licenseDetails.getUserDefinedFieldValues() );
            }
        }
    }
}
