package com.ericsson.cms.contractmgmt.client.tab.license.tab;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.Changeable;
import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.model.UiDeliveryMethod;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionListValues;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionManagement;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiMediaType;
import com.ericsson.cms.contractmgmt.client.model.UiMetaFormat;
import com.ericsson.cms.contractmgmt.client.model.UiOwnership;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.FloatConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class DistributionTable extends Composite {

    private VerticalContainer mainContainer;
    private FlexTableContainer table;
    private String name;

    /* Styles */
    private static final String TABLE_STYLE = "contract-table";
    private static final String ROW_STYLE = "contract-table-row";
    private static final String ROW_HEADER_STYLE = "contract-table-row-header";
    private static final String ROW_BODY_STYLE = "contract-table-row-body";
    private static final String CELL_STYLE = "contract-table-cell";
    private static final String CELL_HEADER_STYLE = "contract-table-cell-header";
    private static final String CELL_BODY_STYLE = "contract-table-cell-body";
    private static final String CELL_HEADER_LABEL_STYLE = "contract-table-header-text";
    public static final String CELL_DELETE_COLUMN_STYLE = "contract-table-cell-body-delete";

    private static final int VISIBLE_LENGTH = 10;

    private ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    private ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create( ContractComponentMessages.class );

    private UiDistributionListValues distributionPlatformListValues;
    private Changeable changeable;
    private boolean isEditing;

    public DistributionTable( UiDistributionListValues distributionPlatformListValues, Changeable changeable, boolean isEditing ) {
        this.changeable = changeable;
        this.distributionPlatformListValues = distributionPlatformListValues;
        this.isEditing = isEditing;

        mainContainer = new VerticalContainer();
        table = new FlexTableContainer();
        table.addStyleName( TABLE_STYLE );

        /* Create the header row */
        table.insertRow( 0 );
        table.getRowFormatter().addStyleName( 0, ROW_STYLE );
        table.getRowFormatter().addStyleName( 0, ROW_HEADER_STYLE );

        initTable();
        mainContainer.add( table );

        if ( changeEnabled() ) {
            addButtons();
        }

        initWidget( mainContainer );
    }

    private boolean changeEnabled() {
        return ( !isEditing && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE ) )
                || ( isEditing && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) );
    }

    public String getName() {
        return name;
    }

    private void addButtons() {
        HorizontalContainer buttonsContainer = new HorizontalContainer();
        buttonsContainer.setSpacing( 5 );

        ButtonWidget addButton = new ButtonWidget( constants.addButtonName(), new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                addRow( null );
            }

        } );
        addButton.addStyleDependentName( StyleNames.ACTION_BUTTON_STYLE );

        ButtonWidget removeButton = new ButtonWidget( constants.removeButtonName(), new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                removeSelectedRows();
            }

        } );
        removeButton.addStyleDependentName( StyleNames.ACTION_BUTTON_STYLE );

        buttonsContainer.add( addButton );
        buttonsContainer.add( removeButton );

        mainContainer.add( buttonsContainer );

    }

    private void removeSelectedRows() {
        for ( int x = table.getRowCount() - 1; x > 0; x-- ) {
            CheckBoxWidget checkBox = (CheckBoxWidget) table.getWidget( x, 0 );
            if ( checkBox.getValue() ) {
                table.removeRow( x );
                if ( changeable != null ) {
                    changeable.setChanged( true );
                }
            }
        }
    }

    private void initTable() {
        if ( changeEnabled() ) {
            addHeading( "" );
        }
        addHeading( constants.platformMediaTypeColumn() );
        addHeading( constants.platformMetaFormatColumn() );
        addHeading( constants.platformDeliveryMethodColumn() );
        addHeading( constants.platformDueDateColumn() );
        addHeading( constants.platformDeliveryDateColumn() );
        addHeading( constants.platformReturnDateColumn() );
        addHeading( constants.platformOwnershipColumn() );
        addHeading( constants.platformCostColumn() );
    }

    public void addRow() {
        addRow( null );
    }

    public void addRow( UiDistributionManagement distributionManagement ) {
        int rowIndex = addRow( getRowCount() );

        if ( changeEnabled() ) {
            // Checkbox
            CheckBoxWidget checkBox = new CheckBoxWidget();
            addCell( rowIndex, checkBox );
        }

        // Type of Media
        TypedListBoxWidget<Long> mediaTypeListBox = new TypedListBoxWidget<Long>( new IntegerConverter() );
        mediaTypeListBox.addValueChangeHandler( new TabValueChangeHandler<Long>( changeable ) );
        fillListBox( mediaTypeListBox, null, distributionPlatformListValues.getMediaTypeValues(), true );
        addCell( rowIndex, mediaTypeListBox );

        // Metadata Format
        TypedListBoxWidget<Long> metaFormatListBox = new TypedListBoxWidget<Long>( new IntegerConverter() );
        metaFormatListBox.addValueChangeHandler( new TabValueChangeHandler<Long>( changeable ) );
        fillListBox( metaFormatListBox, null, distributionPlatformListValues.getMetaFormatValues(), true );
        addCell( rowIndex, metaFormatListBox );

        // Delivery Method
        TypedListBoxWidget<Long> deliveryMethodListBox = new TypedListBoxWidget<Long>( new IntegerConverter() );
        deliveryMethodListBox.addValueChangeHandler( new TabValueChangeHandler<Long>( changeable ) );
        fillListBox( deliveryMethodListBox, null, distributionPlatformListValues.getDeliveryMethodValues(),
                true );
        addCell( rowIndex, deliveryMethodListBox );
        
        // Due Date
        TypedDateBoxWidget dueDate = new TypedDateBoxWidget( new DateConverter( constants.dateFormat(),
                constants.dateFormat() ) );
        dueDate.addValueChangeHandler( new TabValueChangeHandler<String>( changeable ) );
        configureDateBox( dueDate );
        addCell( rowIndex, dueDate );

        // Delivery Date
        TypedDateBoxWidget deliveryDate = new TypedDateBoxWidget( new DateConverter( constants.dateFormat(),
                constants.dateFormat() ) );
        deliveryDate.addValueChangeHandler( new TabValueChangeHandler<String>( changeable ) );
        configureDateBox( deliveryDate );
        addCell( rowIndex, deliveryDate );

        // Return Date
        TypedDateBoxWidget returnDate = new TypedDateBoxWidget( new DateConverter( constants.dateFormat(),
                constants.dateFormat() ) );
        returnDate.addValueChangeHandler( new TabValueChangeHandler<String>( changeable ) );
        configureDateBox( returnDate );
        addCell( rowIndex, returnDate );

        // Ownership
        TypedListBoxWidget<Long> ownershipListBox = new TypedListBoxWidget<Long>( new IntegerConverter() );
        ownershipListBox.addValueChangeHandler( new TabValueChangeHandler<Long>( changeable ) );
        fillListBox( ownershipListBox, null, distributionPlatformListValues.getOwnershipValues(), true );
        addCell( rowIndex, ownershipListBox );

        // Cost
        TypedTextBoxWidget<String> costTextBox = new TypedTextBoxWidget<String>( new FloatConverter() );
        costTextBox.addValueChangeHandler( new TabValueChangeHandler<String>( changeable ) );
        costTextBox.setVisibleLength( VISIBLE_LENGTH );
        costTextBox.setErrorToolTip( messages.floatValidationErrorTooltip() );
        addCell( rowIndex, costTextBox );

        if ( distributionManagement != null ) {
            if ( distributionManagement.getCost() != null ) {
                costTextBox.setValue( String.valueOf( distributionManagement.getCost() ) );
            }
            if ( distributionManagement.getMediaType() != null ) {
                mediaTypeListBox.setValue( distributionManagement.getMediaType().getKey() );
            }
            if ( distributionManagement.getDeliveryMethod() != null ) {
                deliveryMethodListBox.setValue( distributionManagement.getDeliveryMethod().getKey() );
            }
            if ( distributionManagement.getOwnership() != null ) {
                ownershipListBox.setValue( distributionManagement.getOwnership().getKey() );
            }
            
            if ( distributionManagement.getMetaFormat() != null ) {
                for ( int x=0; x<metaFormatListBox.getItemCount(); x++ ) {
                    if ( metaFormatListBox.getItemText( x ).equals( distributionManagement.getMetaFormat().getName() ) ) {
                        metaFormatListBox.setItemSelected( x, true );
                        break;
                    }
                }
            }

            DateTimeFormat dateFormatter = DateTimeFormat.getFormat( constants.dateFormat() );
            if ( distributionManagement.getDeliveryDate() != null ) {
                deliveryDate.setValue( dateFormatter.format( distributionManagement.getDeliveryDate() ) );
            }
            if ( distributionManagement.getDueDate() != null ) {
                dueDate.setValue( dateFormatter.format( distributionManagement.getDueDate() ) );
            }
            if ( distributionManagement.getReturnDate() != null ) {
                returnDate.setValue( dateFormatter.format( distributionManagement.getReturnDate() ) );
            }

        }
    }

    public List<UiDistributionManagement> getDistributionManagementList() {
        List<UiDistributionManagement> distributionPlatforms = new ArrayList<UiDistributionManagement>();
        for ( int x = 1; x < table.getRowCount(); x++ ) {
            TypedListBoxWidget<Long> mediaTypeListBox = (TypedListBoxWidget<Long>) table.getWidget( x, 1 );
            TypedListBoxWidget<Long> metaFormatListBox = (TypedListBoxWidget<Long>) table.getWidget( x, 2 );
            TypedListBoxWidget<Long> deliveryMethodListBox = (TypedListBoxWidget<Long>) table.getWidget( x, 3 );
            TypedDateBoxWidget dueDate = (TypedDateBoxWidget) table.getWidget( x, 4 );
            TypedDateBoxWidget deliveryDate = (TypedDateBoxWidget) table.getWidget( x, 5 );
            TypedDateBoxWidget returnDate = (TypedDateBoxWidget) table.getWidget( x, 6 );
            TypedListBoxWidget<Long> ownershipListBox = (TypedListBoxWidget<Long>) table.getWidget( x, 7 );
            TypedTextBoxWidget<String> costTextBox = (TypedTextBoxWidget<String>) table.getWidget( x, 8 );
            
            UiDistributionManagement distributionMgmt = new UiDistributionManagement();
            DateTimeFormat dateFormatter = DateTimeFormat.getFormat( constants.dateFormat() );
            if ( ( deliveryDate.getTextValue() != null ) && ( !deliveryDate.getTextValue().trim().isEmpty() ) ) {
                distributionMgmt.setDeliveryDate( dateFormatter.parse( deliveryDate.getTextValue() ) );
            } else {
                distributionMgmt.setDeliveryDate( null );
            }
            if ( ( dueDate.getTextValue() != null ) && ( !dueDate.getTextValue().trim().isEmpty() ) ) {
                distributionMgmt.setDueDate( dateFormatter.parse( dueDate.getTextValue() ) );
            } else {
                distributionMgmt.setDueDate( null );
            }
            if ( ( returnDate.getTextValue() != null ) && ( !returnDate.getTextValue().trim().isEmpty() ) ) {
                distributionMgmt.setReturnDate( dateFormatter.parse( returnDate.getTextValue() ) );
            } else {
                distributionMgmt.setReturnDate( null );
            }
            if ( ( costTextBox.getValue() != null ) && ( !costTextBox.getValue().trim().equals( "" ) ) ) {
                distributionMgmt.setCost( costTextBox.getValue() );
            } else {
                distributionMgmt.setCost( null );
            }
            
            distributionMgmt.setMediaType( new UiMediaType( mediaTypeListBox.getSelectedItem() ) );
            distributionMgmt
                    .setDeliveryMethod( new UiDeliveryMethod( deliveryMethodListBox.getSelectedItem() ) );
            distributionMgmt.setOwnership( new UiOwnership( ownershipListBox.getSelectedItem() ) );
            
            UiMetaFormat uiMetaFormat = new UiMetaFormat( metaFormatListBox.getSelectedItem() );
            uiMetaFormat.setName( metaFormatListBox.getItemText( metaFormatListBox.getSelectedIndex() ) );
            distributionMgmt.setMetaFormat( uiMetaFormat );

            distributionPlatforms.add( distributionMgmt );
        }

        return distributionPlatforms;
    }

    private void configureDateBox( TypedDateBoxWidget dateBox ) {
        dateBox.getTextBox().setMaxLength( VISIBLE_LENGTH );
        dateBox.getTextBox().setVisibleLength( VISIBLE_LENGTH );
        dateBox.setToolTip( constants.validDateTitle() + " " + constants.dateFormat() );
        dateBox.setErrorToolTip( constants.validDateTitle() + " " + constants.dateFormat() );
    }

    private void addHeading( String heading ) {
        /* Add the column to the header row */
        int column = table.getCellCount( 0 );
        table.insertCell( 0, column );

        /* Update the style of the header cells */
        table.getCellFormatter().addStyleName( 0, column, CELL_STYLE );
        table.getCellFormatter().addStyleName( 0, column, CELL_HEADER_STYLE );

        updateHeading( heading, column );
    }

    private void updateHeading( String heading, int column ) {
        /* Create new label widget or update existing widget */
        LabelWidget label = getHeadingWidget( column );
        if ( label == null ) {
            /* Update the widget displayed as the column header */
            label = new LabelWidget( heading );
            label.addStyleName( CELL_HEADER_LABEL_STYLE );
            table.setWidget( 0, column, label );
        } else {
            label.setText( heading );
        }
    }

    private LabelWidget getHeadingWidget( int column ) {
        Widget widget = table.getWidget( 0, column );
        return ( widget instanceof LabelWidget ) ? (LabelWidget) widget : null;
    }

    private void addCell( int row, Widget widget ) {
        this.addCell( row, getCellCount( row ), widget );
    }

    private void addCell( int row, int column, Widget widget ) {
        int tableRow = row + 1;
        table.insertCell( tableRow, column );

        /* Update the style of the body cell */
        table.getCellFormatter().addStyleName( tableRow, column, CELL_STYLE );
        table.getCellFormatter().addStyleName( tableRow, column, CELL_BODY_STYLE );

        updateCell( row, column, widget );
    }

    private void updateCell( int row, int column, Widget widget ) {
        int tableRow = row + 1;
        table.clearCell( tableRow, column );
        table.setWidget( tableRow, column, widget );
    }

    private int getCellCount( int row ) {
        return table.getCellCount( row + 1 );
    }

    private int addRow( int row ) {
        validateBodyRow( row );

        /* Shift the row index to account for the header row */
        int tableRow = row + 1;
        table.insertRow( tableRow );
        table.getRowFormatter().addStyleName( tableRow, ROW_STYLE );
        table.getRowFormatter().addStyleName( tableRow, ROW_BODY_STYLE );

        return row;
    }

    private void validateBodyRow( int row ) {
        if ( row < 0 ) {
            throw new IllegalArgumentException( "The row index cannot be less than 0." );
        }
    }

    private int getRowCount() {
        return table.getRowCount() - 1;
    }

    private void fillListBox( final TypedListBoxWidget<Long> listBox, final Long selected,
            List<UiKeyName> result, boolean blankValue ) {
        if ( blankValue ) {
            listBox.addItem( "", null );
        }
        for ( UiKeyName keyName : result ) {
            listBox.addItem( keyName.getName(), keyName.getKey() );
        }
        listBox.setSelectedItem( selected );
    }

}
