package com.ericsson.cms.contractmgmt.client.tab.license.tab;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionManagement;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.model.UiRevenuePricing;

public class LicenseDetailsUtils {

    public static void copyPricingValues( UiLicenseDetails source, UiLicenseDetails target ) {
        target.setPrActualLicenseFee( source.getPrActualLicenseFee() );
        target.setPrActualRetailPrice( source.getPrActualRetailPrice() );
        target.setPrCurrency( source.getPrCurrency() );
        target.setPrDeemedRetailPrice( source.getPrDeemedRetailPrice() );
        target.setPrGuaranteedBuyRate( source.getPrGuaranteedBuyRate() );
        target.setPrGuaranteedSubscribers( source.getPrGuaranteedSubscribers() );
        target.setPrInstallmentPlan( source.getPrInstallmentPlan() );
        target.setPrInstallmentPlanRequired( source.getPrInstallmentPlanRequired() );
        target.setPrLostBuys( source.getPrLostBuys() );
        target.setPrMinimumLicenseFee( source.getPrMinimumLicenseFee() );
        target.setPrOverage( source.getPrOverage() );
        target.setPrOverageRequired( source.getPrOverageRequired() );
        target.setPrRevenueShare( source.getPrRevenueShare() );
        target.setPrRevenueShareRequired( source.getPrRevenueShareRequired() );
        target.setPrTieredPricingRequired( source.getPrTieredPricingRequired() );
        target.setPrUpfrontPayment( source.getPrUpfrontPayment() );
        target.setPrUpfrontPaymentRequired( source.getPrUpfrontPaymentRequired() );
        target.getTieredPricingList().clear();
        for ( UiRevenuePricing uiRevenuePricing : source.getTieredPricingList() ) {
            target.getTieredPricingList().add( copyUiRevenuePricing( uiRevenuePricing ) );
        }
        target.getRevenueSharedList().clear();
        for ( UiRevenuePricing uiRevenuePricing : source.getRevenueSharedList() ) {
            target.getRevenueSharedList().add( copyUiRevenuePricing( uiRevenuePricing ) );
        }
    }

    private static UiRevenuePricing copyUiRevenuePricing( UiRevenuePricing uiRevenuePricing ) {
        UiRevenuePricing rp = new UiRevenuePricing();
        rp.setCurrency( uiRevenuePricing.getCurrency() );
        rp.setFromDate( uiRevenuePricing.getFromDate() );
        rp.setPenalty( uiRevenuePricing.getPenalty() );
        rp.setPrice( uiRevenuePricing.getPrice() );
        rp.setThreshold( uiRevenuePricing.getThreshold() );
        rp.setToDate( uiRevenuePricing.getToDate() );

        return rp;
    }

    public static void copyAssetEnhancementValues( UiLicenseDetails source, UiLicenseDetails target ) {
        target.setAeAdRemoval( source.getAeAdRemoval() );
        target.setAeContentEdit( source.getAeContentEdit() );
        target.setAeContentSecurity( source.getAeContentSecurity() );
        target.setAeFingerPrinting( source.getAeFingerPrinting() );
        target.setAeQualityCheck( source.getAeQualityCheck() );
        target.setAeTranscoding( source.getAeTranscoding() );
        target.setAeWaterMarking( source.getAeWaterMarking() );
    }

    public static void copyDistributionValues( UiLicenseDetails source, UiLicenseDetails target ) {
        target.getDistributionManagementList().clear();
        for ( UiDistributionManagement uiDistributionManagement : source.getDistributionManagementList() ) {
            target.getDistributionManagementList().add(
                    copyUiDistributionManagement( uiDistributionManagement ) );
        }
    }

    private static UiDistributionManagement copyUiDistributionManagement(
            UiDistributionManagement uiDistributionManagement ) {
        UiDistributionManagement dm = new UiDistributionManagement();
        dm.setCost( uiDistributionManagement.getCost() );
        dm.setDeliveryDate( uiDistributionManagement.getDeliveryDate() );
        dm.setDeliveryMethod( uiDistributionManagement.getDeliveryMethod() );
        dm.setDueDate( uiDistributionManagement.getDueDate() );
        dm.setMediaType( uiDistributionManagement.getMediaType() );
        dm.setMetaFormat( uiDistributionManagement.getMetaFormat() );
        dm.setOwnership( uiDistributionManagement.getOwnership() );
        dm.setReturnDate( uiDistributionManagement.getReturnDate() );

        return dm;
    }

    public static void copyStorageMetadataValues( UiLicenseDetails source, UiLicenseDetails target ) {
        target.setSmEffectiveDate( source.getSmEffectiveDate() );
        target.setSmExpiryDate( source.getSmExpiryDate() );
        target.setSmPosterArtRequired( source.getSmPosterArtRequired() );
        target.setSmPreviewRequired( source.getSmPreviewRequired() );
        target.getLanguageList().clear();
        target.getLanguageList().addAll( source.getLanguageList() );

    }

    public static void copyUserDefinedFieldValues( UiLicenseDetails source, UiLicenseDetails target ) {
        for ( UiUserDefinedFieldValue fromField : source.getUserDefinedFieldValues() ) {
            for ( UiUserDefinedFieldValue toField : target.getUserDefinedFieldValues() ) {
                if ( fromField.getIdUserDefinedField().equals( toField.getIdUserDefinedField() ) ) {
                    toField.setValue( fromField.getValue() );
                    break;
                }
            }
        }
    }
    
    public static void copy( UiLicenseDetails source, UiLicenseDetails target ) {
        LicenseDetailsUtils.copyAssetEnhancementValues( source, target );
        LicenseDetailsUtils.copyDistributionValues( source, target );
        LicenseDetailsUtils.copyPricingValues( source, target );
        LicenseDetailsUtils.copyStorageMetadataValues( source, target );
        LicenseDetailsUtils.copyUserDefinedFieldValues( source, target );
    }

}
