package com.ericsson.cms.contractmgmt.client.tab.license.tab;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;
import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.model.UiRevenuePricing;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.config.PercentageConverter;
import com.ericsson.cms.contractmgmt.client.tab.config.PositiveFloatConverter;
import com.ericsson.cms.contractmgmt.client.tab.config.PositiveIntegerConverter;
import com.ericsson.cms.contractmgmt.client.tab.license.AbstractLicenseTab;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseDetailView;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class PricingTab extends AbstractLicenseTab {

    private final ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    private static final String TEXTBOXWIDGET_WIDTH = "100px";
    private static final String OVERAGE_LABELWIDGET = "200px";
    private static final String CONTENT_LISTBOX_WIDTH = "235px";
    private static final int VISIBLE_LENGTH = 10;
    private static final long DATE_OPTION = 1L;
    private static final long THRESHOLD_OPTION = 2L;

    private final ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create( ContractComponentMessages.class );

    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT
            .create( IContractManagerDropDownService.class );

    /* style names */
    private static final String STYLE_DISCLOSURE_CONTAINER = "content-FileView-disclosureContainer";
    private static final String STYLE_DISCLOSURE_CONTENTS = "content-FileView-disclosureContents";
    private static final String STYLE_SCROLL_CONTENTS = "content-FileView-scrollContents";
    private static final String TABLE_STYLE = "contract-table";
    private static final String ROW_STYLE = "contract-table-row";
    private static final String ROW_HEADER_STYLE = "contract-table-row-header";
    private static final String ROW_BODY_STYLE = "contract-table-row-body";
    private static final String CELL_STYLE = "contract-table-cell";
    private static final String CELL_HEADER_STYLE = "contract-table-cell-header";
    private static final String CELL_HEADER_LABEL_STYLE = "contract-table-header-text";

    private final FlexTableContainer tablePricing;
    private final FlexTableContainer tableShare;

    private final ContractFormContainer formContainer;
    private final ContractFormContainer licenseFormContainer;
    private final ContractFormContainer paymentFormContainer;
    private final ContractFormContainer tieredPricingContainer;
    private final ContractFormContainer revenueShareFormContainer;

    private DisclosureContainer licenseDisclosureContainer;
    private DisclosureContainer paymentDisclosureContainer;
    private DisclosureContainer revenueShareDisclosureContainer;
    private DisclosureContainer tieredPricingDisclosureContainer;

    private RadioButtonWidget upfrontPaymentRequiredYes;
    private RadioButtonWidget upfrontPaymentRequiredNo;
    private RadioButtonWidget paymentScheduleRequiredYes;
    private RadioButtonWidget paymentScheduleRequiredNo;
    private RadioButtonWidget installmentPlanYes;
    private RadioButtonWidget installmentPlanNo;
    private RadioButtonWidget tieredPricingRequiredYes;
    private RadioButtonWidget tieredPricingRequiredNo;
    private RadioButtonWidget revenueShareRequiredYes;
    private RadioButtonWidget revenueShareRequiredNo;

    private TypedTextBoxWidget<Integer> subscribers;
    private TypedTextBoxWidget<String> buyRate;
    private TypedTextBoxWidget<String> deemedRetailPrice;
    private TypedTextBoxWidget<String> actualRetailPrice;
    private TypedTextBoxWidget<String> lostBuys;
    private TypedTextBoxWidget<String> revenueShare;
    private TypedTextBoxWidget<String> actualLicenseFee;
    private TypedTextBoxWidget<String> minimumLicenseFee;
    private TypedTextBoxWidget<String> upfrontPaymentRequired;
    private TypedTextBoxWidget<String> overageRequired;
    private TypedTextBoxWidget<String> installmentPlanText;

    private TypedListBoxWidget<Long> paymentCurrency;

    private final List<UiCurrency> currencyList;
    private final List<UiRevenuePricing> revenueList = new ArrayList<UiRevenuePricing>();
    private final List<UiRevenuePricing> tieredPricingList = new ArrayList<UiRevenuePricing>();

    private ButtonWidget addButtonPricing;
    private ButtonWidget removeButtonPricing;
    private ButtonWidget addButtonShare;
    private ButtonWidget removeButtonShare;

    public PricingTab( UiLicense license, final LicenseDetailView detailView ) {
        super( license, detailView );
        busyIndicator.center();
        currencyList = new ArrayList<UiCurrency>();
        tablePricing = new FlexTableContainer();
        tableShare = new FlexTableContainer();
        formContainer = new ContractFormContainer( HasHorizontalAlignment.ALIGN_LEFT );
        licenseFormContainer = new ContractFormContainer( HasHorizontalAlignment.ALIGN_LEFT );
        paymentFormContainer = new ContractFormContainer( HasHorizontalAlignment.ALIGN_LEFT );
        tieredPricingContainer = new ContractFormContainer( HasHorizontalAlignment.ALIGN_LEFT );
        revenueShareFormContainer = new ContractFormContainer( HasHorizontalAlignment.ALIGN_LEFT );

        contractManagerDropDownService.getCurrencies( new NeptuneAsyncCallback<List<UiCurrency>>() {

            @Override
            public void onNeptuneFailure( Throwable caught ) {
                detailView.getErrorPanel().showMessage( caught.getLocalizedMessage() );
                busyIndicator.hide();
            }

            @Override
            public void onNeptuneSuccess( List<UiCurrency> result ) {
                currencyList.clear();
                currencyList.addAll( result );
                init();
                contentPanel.add( formContainer );
                contentPanel.add( licenseDisclosureContainer );
                contentPanel.add( paymentDisclosureContainer );
                contentPanel.add( tieredPricingDisclosureContainer );
                contentPanel.add( revenueShareDisclosureContainer );
                boolean isCreating = getLicense().getKey() == null;
                if ( isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE )
                        || !isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) ) {
                    contentPanel.add( getApplyChangesButton() );
                }
                fillForm();
                busyIndicator.hide();
            }
        } );

    }

    private void init() {

        subscribers = new TypedTextBoxWidget<Integer>( new PositiveIntegerConverter() );
        subscribers.addValueChangeHandler( new TabValueChangeHandler<Integer>( this ) );
        configureNumberTextBox( subscribers, messages.positiveNumberValidationErrorTooltip() );

        buyRate = new TypedTextBoxWidget<String>( new PercentageConverter() );
        buyRate.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        configureNumberTextBox( buyRate, messages.pricingTabBuyRate() );

        deemedRetailPrice = new TypedTextBoxWidget<String>( new PositiveFloatConverter() );
        deemedRetailPrice.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        configureNumberTextBox( deemedRetailPrice, messages.positiveFloatValidationErrorTooltip() );

        actualRetailPrice = new TypedTextBoxWidget<String>( new PositiveFloatConverter() );
        actualRetailPrice.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        configureNumberTextBox( actualRetailPrice, messages.positiveFloatValidationErrorTooltip() );

        lostBuys = new TypedTextBoxWidget<String>( new PercentageConverter() );
        lostBuys.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        configureNumberTextBox( lostBuys, messages.pricingTabLostBuys() );

        revenueShare = new TypedTextBoxWidget<String>( new PercentageConverter() );
        revenueShare.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        configureNumberTextBox( revenueShare, messages.pricingTabRevenueShare() );

        buildLicenseDisclosure();
        buildPaymentDisclosure();
        buildTieredPricingDisclosure();
        buildRevenueShareDisclosure();

        formContainer.addRow( constants.pricingGuaranteedSubscribers(), subscribers );
        formContainer.addRow( constants.pricingGuaranteedBuyRate(), buyRate );
        formContainer.addRow( constants.pricingDeemedRetailPrice(), deemedRetailPrice );
        formContainer.addRow( constants.pricingActualRetailPrice(), actualRetailPrice );
        formContainer.addRow( constants.pricingLostBuys(), lostBuys );
        formContainer.addRow( constants.pricingRevenueShare(), revenueShare );

    }

    private void buildLicenseDisclosure() {
        licenseDisclosureContainer = new RoundedDisclosureContainer(
                constants.pricingLicenseSectionHeading(), true );
        licenseDisclosureContainer.addStyleName( STYLE_DISCLOSURE_CONTAINER );

        licenseFormContainer.addStyleName( STYLE_SCROLL_CONTENTS );

        actualLicenseFee = new TypedTextBoxWidget<String>( new PositiveFloatConverter() );
        actualLicenseFee.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        configureNumberTextBox( actualLicenseFee, messages.positiveFloatValidationErrorTooltip() );

        minimumLicenseFee = new TypedTextBoxWidget<String>( new PositiveFloatConverter() );
        minimumLicenseFee.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        configureNumberTextBox( minimumLicenseFee, messages.positiveFloatValidationErrorTooltip() );

        licenseFormContainer.addRow( constants.pricingActualLicenseFee(), actualLicenseFee );
        licenseFormContainer.addRow( constants.pricingMinimumLicenseFee(), minimumLicenseFee );

        ScrollContainer licenseDisclosureContents = new ScrollContainer( licenseFormContainer );
        licenseDisclosureContents.addStyleName( STYLE_DISCLOSURE_CONTENTS );

        licenseDisclosureContainer.setContent( licenseDisclosureContents );
    }

    private void buildPaymentDisclosure() {

        paymentDisclosureContainer = new RoundedDisclosureContainer( constants.pricingPaymentCurrency(), true );
        paymentDisclosureContainer.addStyleName( STYLE_DISCLOSURE_CONTAINER );

        paymentFormContainer.addStyleName( STYLE_SCROLL_CONTENTS );

        upfrontPaymentRequired = new TypedTextBoxWidget<String>( new PositiveFloatConverter() );
        upfrontPaymentRequired.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        upfrontPaymentRequired.setEnabled( false );
        configureNumberTextBox( upfrontPaymentRequired, messages.positiveFloatValidationErrorTooltip() );

        upfrontPaymentRequiredYes = new RadioButtonWidget( "upfrontPayment", constants.yes() );
        upfrontPaymentRequiredYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        upfrontPaymentRequiredYes.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                upfrontPaymentRequired.setText( "" );
                upfrontPaymentRequired.setEnabled( true );

            }
        } );
        upfrontPaymentRequiredNo = new RadioButtonWidget( "upfrontPayment", constants.no() );
        upfrontPaymentRequiredNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        upfrontPaymentRequiredNo.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                upfrontPaymentRequired.setText( "" );
                upfrontPaymentRequired.setEnabled( false );

            }
        } );

        HorizontalContainer upfrontPayment = createRadioContainer( upfrontPaymentRequiredYes,
                upfrontPaymentRequiredNo );

        addSpace( upfrontPayment );
        upfrontPayment.add( upfrontPaymentRequired );

        overageRequired = new TypedTextBoxWidget<String>( new PositiveFloatConverter() );
        overageRequired.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        overageRequired.setEnabled( false );
        configureNumberTextBox( overageRequired, messages.positiveFloatValidationErrorTooltip() );

        paymentScheduleRequiredYes = new RadioButtonWidget( "overage", constants.yes() );
        paymentScheduleRequiredYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        paymentScheduleRequiredYes.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                overageRequired.setText( "" );
                overageRequired.setEnabled( true );

            }
        } );
        paymentScheduleRequiredNo = new RadioButtonWidget( "overage", constants.no() );
        paymentScheduleRequiredNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        paymentScheduleRequiredNo.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                overageRequired.setText( "" );
                overageRequired.setEnabled( false );

            }
        } );

        HorizontalContainer overagePayment = createRadioContainer( paymentScheduleRequiredYes,
                paymentScheduleRequiredNo );

        addSpace( overagePayment );
        overagePayment.add( overageRequired );

        paymentCurrency = new TypedListBoxWidget<Long>( new IntegerConverter() );
        paymentCurrency.addValueChangeHandler( new TabValueChangeHandler<Long>( this ) );
        paymentCurrency.setWidth( CONTENT_LISTBOX_WIDTH );

        installmentPlanText = new TypedTextBoxWidget<String>( new PositiveFloatConverter() );
        installmentPlanText.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        installmentPlanText.setEnabled( false );
        configureNumberTextBox( installmentPlanText, messages.positiveFloatValidationErrorTooltip() );

        installmentPlanYes = new RadioButtonWidget( "installment", constants.yes() );
        installmentPlanYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        installmentPlanYes.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                installmentPlanText.setText( "" );
                installmentPlanText.setEnabled( true );

            }
        } );
        installmentPlanNo = new RadioButtonWidget( "installment", constants.no() );
        installmentPlanNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        installmentPlanNo.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                installmentPlanText.setText( "" );
                installmentPlanText.setEnabled( false );

            }
        } );

        HorizontalContainer installmentPlan = createRadioContainer( installmentPlanYes, installmentPlanNo );

        addSpace( installmentPlan );
        installmentPlan.add( installmentPlanText );

        paymentFormContainer.addRow( constants.pricingUpfrontPaymentRequired(), upfrontPayment, true );
        LabelWidget overageLabel = new LabelWidget( constants.pricingOveragePaymentRequired() );
        overageLabel.setWidth( OVERAGE_LABELWIDGET );
        paymentFormContainer.addRow( overageLabel, overagePayment, true );
        paymentFormContainer.addRow( constants.pricingPaymentCurrency(), paymentCurrency );
        paymentFormContainer.addRow( constants.pricingInstallmentPlan(), installmentPlan, true );

        ScrollContainer paymentDisclosureContents = new ScrollContainer( paymentFormContainer );
        paymentDisclosureContents.addStyleName( STYLE_DISCLOSURE_CONTENTS );

        paymentDisclosureContainer.setContent( paymentDisclosureContents );

    }

    private void buildTieredPricingDisclosure() {

        tieredPricingDisclosureContainer = new RoundedDisclosureContainer(
                constants.pricingTieredPricingSectionHeading(), true );
        tieredPricingDisclosureContainer.addStyleName( STYLE_DISCLOSURE_CONTAINER );

        tieredPricingContainer.addStyleName( STYLE_SCROLL_CONTENTS );

        tieredPricingRequiredYes = new RadioButtonWidget( "tiered", constants.yes() );
        tieredPricingRequiredYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        tieredPricingRequiredYes.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                enableTieredPricingTable();
            }

        } );
        tieredPricingRequiredNo = new RadioButtonWidget( "tiered", constants.no() );
        tieredPricingRequiredNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        tieredPricingRequiredNo.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                disableTieredPricingTable();
            }

        } );

        tieredPricingContainer.addRow( constants.pricingTieredPricingRequired(),
                createRadioContainer( tieredPricingRequiredYes, tieredPricingRequiredNo ) );

        ScrollContainer tieredPricingDisclosureContents = new ScrollContainer( tieredPricingContainer );
        tieredPricingDisclosureContents.addStyleName( STYLE_DISCLOSURE_CONTENTS );

        tablePricing.addStyleName( TABLE_STYLE );

        /* Create the header row */
        tablePricing.insertRow( 0 );
        tablePricing.getRowFormatter().addStyleName( 0, ROW_STYLE );
        tablePricing.getRowFormatter().addStyleName( 0, ROW_HEADER_STYLE );
        tieredPricingContainer.addRow( "", tablePricing );

        initTable( tablePricing, true );
        if ( changeEnabled() ) {
            addButtonsPricing();
        }

        tieredPricingDisclosureContainer.setContent( tieredPricingDisclosureContents );
    }

    private void enableTieredPricingTable() {
        if ( changeEnabled() ) {
            addButtonPricing.setEnabled( true );
            removeButtonPricing.setEnabled( true );
        }
    }

    private void disableTieredPricingTable() {
        if ( changeEnabled() ) {
            addButtonPricing.setEnabled( false );
            removeButtonPricing.setEnabled( false );
        }
        removeAllRows( tablePricing, tieredPricingList );
    }

    private void buildRevenueShareDisclosure() {

        revenueShareDisclosureContainer = new RoundedDisclosureContainer( constants.pricingRevenueShare(),
                true );
        revenueShareDisclosureContainer.addStyleName( STYLE_DISCLOSURE_CONTAINER );

        revenueShareFormContainer.addStyleName( STYLE_SCROLL_CONTENTS );

        revenueShareRequiredYes = new RadioButtonWidget( "revenue", constants.yes() );
        revenueShareRequiredYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        revenueShareRequiredYes.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                enableRevenueShareTable();
            }

        } );
        revenueShareRequiredNo = new RadioButtonWidget( "revenue", constants.no() );
        revenueShareRequiredNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );
        revenueShareRequiredNo.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                disableRevenueShareTable();
            }

        } );

        revenueShareFormContainer.addRow( constants.pricingRevenueShareRequired(),
                createRadioContainer( revenueShareRequiredYes, revenueShareRequiredNo ) );

        ScrollContainer revenueShareDisclosureContents = new ScrollContainer( revenueShareFormContainer );
        revenueShareDisclosureContents.addStyleName( STYLE_DISCLOSURE_CONTENTS );

        tableShare.addStyleName( TABLE_STYLE );

        /* Create the header row */
        tableShare.insertRow( 0 );
        tableShare.getRowFormatter().addStyleName( 0, ROW_STYLE );
        tableShare.getRowFormatter().addStyleName( 0, ROW_HEADER_STYLE );
        revenueShareFormContainer.addRow( "", tableShare );

        initTable( tableShare, false );
        if ( changeEnabled() ) {
            addButtonsShare();
        }

        revenueShareDisclosureContainer.setContent( revenueShareDisclosureContents );
    }

    private void enableRevenueShareTable() {
        if ( changeEnabled() ) {
            addButtonShare.setEnabled( true );
            removeButtonShare.setEnabled( true );
        }
    }

    private void disableRevenueShareTable() {
        if ( changeEnabled() ) {
            addButtonShare.setEnabled( false );
            removeButtonShare.setEnabled( false );
        }
        removeAllRows( tableShare, revenueList );
    }

    private void addButtonsPricing() {
        HorizontalContainer buttonsContainer = new HorizontalContainer();
        buttonsContainer.setSpacing( 5 );

        addButtonPricing = new ButtonWidget( constants.addButtonName(), new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                addRow( tablePricing, null, true );
            }

        } );

        addButtonPricing.addStyleDependentName( StyleNames.ACTION_BUTTON_STYLE );
        addButtonPricing.setEnabled( false );

        removeButtonPricing = new ButtonWidget( constants.removeButtonName(), new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                if ( anyRowSelected( tablePricing ) ) {
                    if ( Window.confirm( messages.deleteRecordConfirmation() ) ) {
                        removeRow( tablePricing, tieredPricingList, true );
                    }
                } else {
                    Window.alert( messages.noRecordSelected() );
                }
            }

        } );
        removeButtonPricing.addStyleDependentName( StyleNames.ACTION_BUTTON_STYLE );
        removeButtonPricing.setEnabled( false );

        buttonsContainer.add( addButtonPricing );
        buttonsContainer.add( removeButtonPricing );

        tieredPricingContainer.addRow( "", buttonsContainer );

    }

    private void addButtonsShare() {
        HorizontalContainer buttonsContainer = new HorizontalContainer();
        buttonsContainer.setSpacing( 5 );

        addButtonShare = new ButtonWidget( constants.addButtonName(), new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                addRow( tableShare, null, false );
            }

        } );
        addButtonShare.addStyleDependentName( StyleNames.ACTION_BUTTON_STYLE );
        addButtonShare.setEnabled( false );

        removeButtonShare = new ButtonWidget( constants.removeButtonName(), new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                if ( anyRowSelected( tableShare ) ) {
                    if ( Window.confirm( messages.deleteRecordConfirmation() ) ) {
                        removeRow( tableShare, revenueList, false );
                    }
                } else {
                    Window.alert( messages.noRecordSelected() );
                }
            }


        } );
        removeButtonShare.addStyleDependentName( StyleNames.ACTION_BUTTON_STYLE );
        removeButtonShare.setEnabled( false );

        buttonsContainer.add( addButtonShare );
        buttonsContainer.add( removeButtonShare );

        revenueShareFormContainer.addRow( "", buttonsContainer );

    }

    private boolean anyRowSelected( FlexTableContainer table ) {
        boolean anyRowSelected = false;
        for ( int i = 1; i < table.getRowCount(); i++ ) {
            if ( ( (CheckBoxWidget) table.getWidget( i, 0 ) ).getValue() == true ) {
                anyRowSelected = true;
                break;
            }
        }
        return anyRowSelected;
    }

    private HorizontalContainer createRadioContainer( RadioButtonWidget radio1, RadioButtonWidget radio2 ) {
        HorizontalContainer container = new HorizontalContainer();

        container.add( radio1 );
        addSpace( container );

        radio2.setValue( true );
        container.add( radio2 );

        return container;
    }

    private void addSpace( HorizontalContainer container ) {
        if ( container != null ) {
            HorizontalPanel space = new HorizontalPanel();
            LabelWidget label = new LabelWidget();
            space.add( label );
            space.setCellWidth( label, "10" );
            container.add( space );
        }
    }

    private void addHeading( String heading, FlexTableContainer table ) {
        /* Add the column to the header row */
        int column = table.getCellCount( 0 );
        table.insertCell( 0, column );

        /* Update the style of the header cells */
        table.getCellFormatter().addStyleName( 0, column, CELL_STYLE );
        table.getCellFormatter().addStyleName( 0, column, CELL_HEADER_STYLE );

        updateHeading( table, heading, column );
    }

    private void updateHeading( FlexTableContainer table, String heading, int column ) {
        /* Create new label widget or update existing widget */
        LabelWidget label = getHeadingWidget( table, column );
        if ( label == null ) {
            /* Update the widget displayed as the column header */
            label = new LabelWidget( heading );
            label.addStyleName( CELL_HEADER_LABEL_STYLE );
            table.setWidget( 0, column, label );
        } else {
            label.setText( heading );
        }
    }

    private LabelWidget getHeadingWidget( FlexTableContainer table, int column ) {
        Widget widget = table.getWidget( 0, column );
        return widget instanceof LabelWidget ? (LabelWidget) widget : null;
    }

    /**
     * @param table
     * @param priceHeader
     *            indicates whether the header displays "Price" when true, or
     *            "Percentage" when false.
     */
    private void initTable( FlexTableContainer table, boolean priceHeader ) {
        if ( changeEnabled() ) {
            addCheckBoxHeader( table );
        } else {
            addHeading( "", table );
        }
        if (priceHeader) {
            addHeading( constants.pricingTypeHeader(), table );
        }
        addHeading( priceHeader ? constants.pricingFromHeader() : constants.pricingFromHeader() + "*", table );
        addHeading( priceHeader ? constants.pricingToHeader() : constants.pricingToHeader() + "*", table );
        addHeading( constants.pricingThresholdHeader(), table );
        addHeading( priceHeader ? constants.pricingPriceHeader()+ "*" : constants.pricingPercentageHeader() + "*", table );
        addHeading( constants.pricingCurrencyHeader(), table );
        addHeading( constants.pricingPenaltyHeader(), table );
    }

    private void addCheckBoxHeader( final FlexTableContainer table ) {
        final CheckBoxWidget check = new CheckBoxWidget();
        check.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                if ( check.getValue() ) {
                    checkAll( table );
                } else {
                    uncheckAll( table );
                }
            }
        } );

        table.insertCell( 0, 0 );
        table.getCellFormatter().addStyleName( 0, 0, CELL_STYLE );
        table.getCellFormatter().addStyleName( 0, 0, CELL_HEADER_STYLE );
        table.setWidget( 0, 0, check );
    }

    private void checkAll( FlexTableContainer table ) {
        for ( int i = 0; i < table.getRowCount(); i++ ) {
            ( (CheckBoxWidget) table.getWidget( i, 0 ) ).setValue( true );
        }
    }

    private void uncheckAll( FlexTableContainer table ) {
        for ( int i = 0; i < table.getRowCount(); i++ ) {
            ( (CheckBoxWidget) table.getWidget( i, 0 ) ).setValue( false );
        }
    }

    private boolean changeEnabled() {
        boolean isCreating = getLicense().getKey() == null;
        return isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE )
                || !isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY );
    }

    public void addRow( FlexTableContainer table, UiRevenuePricing uiRevenuePricing, boolean hasType ) {
        int rowIndex = addRow( table );
        int colIndex = 1;

        if ( changeEnabled() ) {
            // adds the row checkbox
            CheckBoxWidget check = new CheckBoxWidget();
            table.setWidget( rowIndex, 0, check );
        }

        // adds the type
        TypedListBoxWidget<Long> typeListBox = new TypedListBoxWidget<Long>( new IntegerConverter() );
        if (hasType) {
            typeListBox.addValueChangeHandler( new TabValueChangeHandler<Long>( this ) );
            typeListBox.setWidth( TEXTBOXWIDGET_WIDTH );
            typeListBox.addItem( constants.date(), DATE_OPTION );
            typeListBox.addItem( constants.threshold(), THRESHOLD_OPTION );
            table.setWidget( rowIndex, colIndex++, typeListBox );
        }

        // adds the From
        final TypedDateBoxWidget fromDate = new TypedDateBoxWidget( new DateConverter( constants.dateFormat(),
                constants.dateFormat() ) );
        fromDate.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        configureDateBox( fromDate );
        table.setWidget( rowIndex, colIndex++, fromDate );

        // adds the To
        final TypedDateBoxWidget toDate = new TypedDateBoxWidget( new DateConverter( constants.dateFormat(),
                constants.dateFormat() ) );
        toDate.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        configureDateBox( toDate );
        table.setWidget( rowIndex, colIndex++, toDate );

        // adds the Threshold
        final TypedTextBoxWidget<String> thresholdTextBox = new TypedTextBoxWidget<String>( new PositiveFloatConverter() );
        thresholdTextBox.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        table.setWidget( rowIndex, colIndex++, thresholdTextBox );
        thresholdTextBox.setErrorToolTip( messages.positiveFloatValidationErrorTooltip() );
        thresholdTextBox.setVisibleLength( VISIBLE_LENGTH );
        if (hasType) {
            thresholdTextBox.setEnabled( false );
        }

        if (hasType) {
            // add ValueChanger for type
            typeListBox.addValueChangeHandler( new ValueChangeHandler<Long>() {

                @Override
                public void onValueChange( ValueChangeEvent<Long> event ) {
                    if ( event.getValue().equals( 1L ) ) {
                        fromDate.setEnabled( true );
                        toDate.setEnabled( true );
                        thresholdTextBox.setEnabled( false );
                        thresholdTextBox.setValue( null );
                    } else if ( event.getValue().equals( 2L ) ) {
                        fromDate.setEnabled( false );
                        toDate.setEnabled( false );
                        thresholdTextBox.setEnabled( true );
                        fromDate.setValue( null );
                        toDate.setValue( null );
                    }

                }
            } );
        }

        // adds the price
        TypedTextBoxWidget<String> price = new TypedTextBoxWidget<String>( new PositiveFloatConverter() );
        price.setErrorToolTip( messages.positiveFloatValidationErrorTooltip() );
        price.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        table.setWidget( rowIndex, colIndex++, price );
        price.setVisibleLength( VISIBLE_LENGTH );

        // adds the currency
        TypedListBoxWidget<Long> currencyMethodListBox = new TypedListBoxWidget<Long>( new IntegerConverter() );
        currencyMethodListBox.addValueChangeHandler( new TabValueChangeHandler<Long>( this ) );
        currencyMethodListBox.setWidth( TEXTBOXWIDGET_WIDTH );
        table.setWidget( rowIndex, colIndex++, currencyMethodListBox );
        fillTypedList( currencyMethodListBox );

        // adds the penalty
        TypedTextBoxWidget<String> penalty = new TypedTextBoxWidget<String>( new PositiveFloatConverter() );
        penalty.setErrorToolTip( messages.positiveFloatValidationErrorTooltip() );
        penalty.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );
        table.setWidget( rowIndex, colIndex++, penalty );
        penalty.setVisibleLength( VISIBLE_LENGTH );

        if ( uiRevenuePricing != null ) {
            DateTimeFormat dateFormatter = DateTimeFormat.getFormat( constants.dateFormat() );
            if (hasType) {
                if ( uiRevenuePricing.getFromDate() != null && uiRevenuePricing.getToDate() != null ) {
                    fromDate.setValue( dateFormatter.format( uiRevenuePricing.getFromDate() ) );
                    fromDate.setEnabled( true );
                    toDate.setValue( dateFormatter.format( uiRevenuePricing.getToDate() ) );
                    toDate.setEnabled( true );
                    thresholdTextBox.setEnabled( false );
                    typeListBox.setSelectedItem( DATE_OPTION );
                } else if ( uiRevenuePricing.getThreshold() != null ) {
                    thresholdTextBox.setTextValue( uiRevenuePricing.getThreshold() );
                    thresholdTextBox.setEnabled( true );
                    toDate.setEnabled( false );
                    fromDate.setEnabled( false );
                    typeListBox.setSelectedItem( THRESHOLD_OPTION );
                }
            } else {
                if ( uiRevenuePricing.getFromDate() != null && uiRevenuePricing.getToDate() != null ) {
                    fromDate.setValue( dateFormatter.format( uiRevenuePricing.getFromDate() ) );
                    toDate.setValue( dateFormatter.format( uiRevenuePricing.getToDate() ) );
                }
                if ( uiRevenuePricing.getThreshold() != null ) {
                    thresholdTextBox.setTextValue( uiRevenuePricing.getThreshold() );
                }
            }

            if ( uiRevenuePricing.getPrice() != null ) {
                price.setTextValue( uiRevenuePricing.getPrice() );
            }
            if ( uiRevenuePricing.getCurrency() != null ) {
                currencyMethodListBox.setValue( uiRevenuePricing.getCurrency().getKey() );
            }
            if ( uiRevenuePricing.getPenalty() != null ) {
                penalty.setTextValue( uiRevenuePricing.getPenalty() );
            }
        }
    }

    private void removeRow( FlexTableContainer table, List<UiRevenuePricing> uiRevenuePricingList, boolean hasType ) {
        if ( table.getRowCount() > 1 ) {
            // Skip the header
            for ( int i = 1; i < table.getRowCount(); i++ ) {
                // if the row is checked remove it
                if ( ( (CheckBoxWidget) table.getWidget( i, 0 ) ).getValue() == true ) {
                    table.removeRow( i );
                    i = i - 1;
                }
            }
        }
        updateRevenuePricingList( uiRevenuePricingList, table, hasType );
        setChanged( true );
    }

    private int addRow( FlexTableContainer table ) {

        table.insertRow( table.getRowCount() );
        table.getRowFormatter().addStyleName( getRowIndex( table ), ROW_STYLE );
        table.getRowFormatter().addStyleName( getRowIndex( table ), ROW_BODY_STYLE );
        return getRowIndex( table );
    }

    /*
     * Returns the last index of the rows
     */
    private int getRowIndex( FlexTableContainer table ) {
        return table.getRowCount() - 1;
    }

    @SuppressWarnings("unchecked")
    private void updateRevenuePricingList( List<UiRevenuePricing> uiRevenuePrincingList,
            FlexTableContainer table, boolean hasType ) {
        uiRevenuePrincingList.clear();
        DateTimeFormat dateFormatter = DateTimeFormat.getFormat( constants.dateFormat() );
        if ( table.getRowCount() > 1 ) {
            // Skip the header
            for ( int i = 1; i < table.getRowCount(); i++ ) {
                UiRevenuePricing uiRevenuePricing = new UiRevenuePricing();
                uiRevenuePricing.setCurrency( getCurrency( ( (TypedListBoxWidget<Long>) table
                        .getWidget( i, hasType ? 6 : 5 ) ).getSelectedItem() ) );
                String fromDateText = ( (TypedDateBoxWidget) table.getWidget( i, hasType ? 2 : 1 ) ).getTextValue();
                if ( fromDateText != null && !fromDateText.trim().isEmpty() ) {
                    uiRevenuePricing.setFromDate( dateFormatter.parse( fromDateText ) );
                } else {
                    uiRevenuePricing.setFromDate( null );
                }

                String toDateText = ( (TypedDateBoxWidget) table.getWidget( i, hasType ? 3 : 2 ) ).getTextValue();
                if ( toDateText != null && !toDateText.trim().isEmpty() ) {
                    uiRevenuePricing.setToDate( dateFormatter.parse( toDateText ) );
                } else {
                    uiRevenuePricing.setToDate( null );
                }
                uiRevenuePricing.setPenalty(( (TypedTextBoxWidget<String>) table.getWidget( i, hasType ? 7 : 6 ) ).getValue());
                uiRevenuePricing.setPrice(( (TypedTextBoxWidget<String>) table.getWidget( i, hasType ? 5 : 4 ) ).getValue());
                uiRevenuePricing.setThreshold(( (TypedTextBoxWidget<String>) table.getWidget( i, hasType ? 4 : 3 ) ).getValue());

                uiRevenuePrincingList.add( uiRevenuePricing );
            }
        }
    }

    private void removeAllRows( FlexTableContainer table, List<UiRevenuePricing> uiRevenuePricingList ) {
        for ( int i = 1; i < table.getRowCount(); i++ ) {
            table.removeRow( i );
            i = i - 1;
        }
        uiRevenuePricingList.clear();
    }

    private void configureDateBox( TypedDateBoxWidget dateBox ) {
        dateBox.getTextBox().setMaxLength( VISIBLE_LENGTH );
        dateBox.getTextBox().setVisibleLength( VISIBLE_LENGTH );
        dateBox.setToolTip( constants.validDateTitle() + " " + constants.dateFormat() );
        dateBox.setErrorToolTip( constants.validDateTitle() + " " + constants.dateFormat() );
    }

    private void configureNumberTextBox( TypedTextBoxWidget<?> textBox, String errorTooltip ) {
        textBox.setWidth( TEXTBOXWIDGET_WIDTH );
        textBox.setErrorToolTip( errorTooltip );
    }

    private void fillRadioValues( RadioButtonWidget radio1, RadioButtonWidget radio2, Boolean value ) {
        if ( value != null && value ) {
            radio1.setValue( true );
            radio2.setValue( false );
        } else {
            radio1.setValue( false );
            radio2.setValue( true );
        }
    }

    @Override
    public String getName() {
        return CustomFieldFactory.PRICING_SCREEN;
    }

    @Override
    public String getDisplayName() {
        return constants.pricingTabDisplayName();
    }

    @Override
    public void validate() throws ValidationException {

        List<String> validationMessages = new ArrayList<String>();
        if ( !formContainer.validate() ) {
            validationMessages.add( messages.formHasValidationErrors() );
        }

        if ( !licenseFormContainer.validate() ) {
            validationMessages.add( messages.licenseFormHasValidationErrors() );
        }

        if ( !paymentFormContainer.validate() ) {
            validationMessages.add( messages.paymentFormHasValidationErrors() );
        }

        if ( !tieredPricingContainer.validate() ) {
            validationMessages.add( messages.tieredPricingFormHasValidationErrors() );
        }

        if ( !revenueShareFormContainer.validate() ) {
            validationMessages.add( messages.revenueShareFormHasValidationErrors() );
        }

        if ( buyRate.getValue() != null ) {
            Float buyrate = new Float( buyRate.getValue() );
            if ( buyrate < 0.0F || buyrate > 100.0F ) {
                validationMessages.add( messages.pricingTabBuyRate() );
            }
        }

        if ( lostBuys.getValue() != null ) {
            Float lost = new Float( lostBuys.getValue() );
            if ( lost < 0.0F || lost > 100.0F ) {
                validationMessages.add( messages.pricingTabLostBuys() );
            }
        }

        if ( revenueShare.getValue() != null ) {
            Float revenue = new Float( revenueShare.getValue() );
            if ( revenue < 0.0F || revenue > 100.0F ) {
                validationMessages.add( messages.pricingTabRevenueShare() );
            }
        }

        updateRevenuePricingList( tieredPricingList, tablePricing, true );
        validateRows( tieredPricingList, validationMessages, constants.pricingTieredPricingSectionHeading() );

        updateRevenuePricingList( revenueList, tableShare, false );
        validateRows( revenueList, validationMessages, constants.pricingRevenueShare() );

        if ( !validationMessages.isEmpty() ) {
            throw new ValidationException( validationMessages );
        }

    }

    private void validateRows( List<UiRevenuePricing> rows, List<String> validationMessages, String type ) {
        DateTimeFormat dateFormatter = DateTimeFormat.getFormat( constants.dateFormat() );
        boolean overlap = false;
        Set<UiRevenuePricing> rpTempSet = new HashSet<UiRevenuePricing>();
        for ( int i = 0; i < rows.size(); i++ ) {
            UiRevenuePricing rp1 = rows.get( i );
            rpTempSet.add( rp1 );

            if ( rp1.getPrice() == null ) {
                validationMessages.add( messages.pricingTabPriceRequired( type, i + 1, type.equals(constants.pricingRevenueShare()) ? constants.percentage() : constants.pricingPriceHeader() ) );
            }

            if (rp1.getThreshold() == null || type.equals(constants.pricingRevenueShare())) {
                // It should be a date range
                if ( rp1.getToDate() != null && rp1.getFromDate() != null ) {

                    validateRevenuePricingDate(validationMessages, type,
                            dateFormatter, i, rp1);

                    if ( !overlap ) {
                        for ( int j = 0; j < rows.size(); j++ ) {
                            UiRevenuePricing rp2 = rows.get( j );
                            if (!rpTempSet.contains(rp2) && rp2.getFromDate() != null && rp2.getToDate() != null) {
                                if (!rp2.getFromDate().before(rp1.getFromDate())  // NOSONAR
                                        && !rp2.getFromDate().after(rp1.getToDate())
                                        || !rp2.getToDate().before(rp1.getFromDate())
                                        && !rp2.getToDate().after(rp1.getToDate())) {
                                    if (type.equals(constants.pricingRevenueShare()) && rp1.getThreshold() != null
                                            && rp2.getThreshold() != null) {
                                        // Date Overlaps are allowed for Revenue Share section
                                        Float rp1FloatVal = Float.parseFloat(rp1.getThreshold());
                                        Float rp2FloatVal = Float.parseFloat(rp2.getThreshold());
                                        if (rp1FloatVal.floatValue() == rp2FloatVal.floatValue()) {
                                            validationMessages.add(messages.pricingTabDatesThresholdOverlap(type));
                                            overlap = true;
                                            break;
                                        }
                                    } else {
                                        validationMessages.add(messages.pricingTabDatesOverlap(type));
                                        overlap = true;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    validationMessages.add( messages.pricingTabThresholdOrDateRangeRequired( type, i + 1 ) );
                }

            }
        }
    }

    /**
     * @param validationMessages
     * @param type
     * @param dateFormatter
     * @param i
     * @param rp1
     */
    private void validateRevenuePricingDate(List<String> validationMessages,
            String type, DateTimeFormat dateFormatter, int i,
            UiRevenuePricing rp1) {
        // the "To" date cannot be earlier than "From" date
        if ( rp1.getToDate().before( rp1.getFromDate() ) ) {
            validationMessages.add( messages.pricingTabToDateBeforeFrom( type, i + 1 ) );
        }

        // The "From" / "To" date range cannot be outside of the License Effective date and Expiry date
        if ( getLicense().getEffectiveDate() != null && getLicense().getExpiryDate() != null
                && rp1.getToDate() != null && rp1.getFromDate() != null ) {
            if ( getLicense().getEffectiveDate().after( rp1.getFromDate() ) ) {
                String effectiveDateText = dateFormatter.format( getLicense().getEffectiveDate() );
                validationMessages.add( messages.pricingTabLicenseEffectiveAfterFromDate( type,
                        i + 1, effectiveDateText ) );
            }

            if ( getLicense().getExpiryDate().before( rp1.getToDate() ) ) {
                String expiryDateText = dateFormatter.format( getLicense().getExpiryDate() );
                validationMessages.add( messages.pricingTabLicenseExpiryBeforeToDate( type, i + 1, expiryDateText ) );
            }
        }
    }

    @Override
    public void fillForm() {
        formContainer.clearAllValidationErrors();
        licenseFormContainer.clearAllValidationErrors();
        paymentFormContainer.clearAllValidationErrors();
        tieredPricingContainer.clearAllValidationErrors();
        revenueShareFormContainer.clearAllValidationErrors();
        removeAllRows( tablePricing, tieredPricingList );
        removeAllRows( tableShare, revenueList );

        installmentPlanText.setEnabled( false );
        fillRadioValues( installmentPlanYes, installmentPlanNo,
                currentTreeObject.getPrInstallmentPlanRequired() );
        if ( currentTreeObject.getPrInstallmentPlanRequired() ) {
            installmentPlanText.setEnabled( true );
        }
        overageRequired.setEnabled( false );
        fillRadioValues( paymentScheduleRequiredYes, paymentScheduleRequiredNo,
                currentTreeObject.getPrOverageRequired() );
        if ( currentTreeObject.getPrOverageRequired() ) {
            overageRequired.setEnabled( true );
        }

        fillRadioValues( revenueShareRequiredYes, revenueShareRequiredNo,
                currentTreeObject.getPrRevenueShareRequired() );
        if ( currentTreeObject.getPrRevenueShareRequired() != null
                && currentTreeObject.getPrRevenueShareRequired() ) {
            enableRevenueShareTable();
        } else {
            disableRevenueShareTable();
        }
        fillRadioValues( tieredPricingRequiredYes, tieredPricingRequiredNo,
                currentTreeObject.getPrTieredPricingRequired() );
        if ( currentTreeObject.getPrTieredPricingRequired() != null
                && currentTreeObject.getPrTieredPricingRequired() ) {
            enableTieredPricingTable();
        } else {
            disableTieredPricingTable();
        }

        upfrontPaymentRequired.setEnabled( false );
        fillRadioValues( upfrontPaymentRequiredYes, upfrontPaymentRequiredNo,
                currentTreeObject.getPrUpfrontPaymentRequired() );
        if ( currentTreeObject.getPrUpfrontPaymentRequired() != null
                && currentTreeObject.getPrUpfrontPaymentRequired() ) {
            upfrontPaymentRequired.setEnabled( true );
        }

        actualLicenseFee.setTextValue(currentTreeObject.getPrActualLicenseFee());
        actualRetailPrice.setTextValue(currentTreeObject.getPrActualRetailPrice());
        deemedRetailPrice.setTextValue(currentTreeObject.getPrDeemedRetailPrice());
        buyRate.setTextValue(currentTreeObject.getPrGuaranteedBuyRate());
        if ( currentTreeObject.getPrGuaranteedSubscribers() != null ) {
            subscribers.setValue( currentTreeObject.getPrGuaranteedSubscribers().intValue() );
        } else {
            subscribers.setValue( null );
        }
        installmentPlanText.setTextValue(currentTreeObject.getPrInstallmentPlan());
        lostBuys.setTextValue(currentTreeObject.getPrLostBuys());
        minimumLicenseFee.setTextValue(currentTreeObject.getPrMinimumLicenseFee());
        overageRequired.setTextValue(currentTreeObject.getPrOverage());
        revenueShare.setTextValue(currentTreeObject.getPrRevenueShare());
        upfrontPaymentRequired.setTextValue(currentTreeObject.getPrUpfrontPayment());

        fillTypedList( paymentCurrency );

        if ( currentTreeObject.getPrCurrency() != null ) {
            paymentCurrency.setSelectedItem( currentTreeObject.getPrCurrency().getKey() );
        } else {
            paymentCurrency.setSelectedItem( null );
        }

        if ( currentTreeObject.getRevenueSharedList() != null ) {
            revenueList.clear();
            revenueList.addAll( currentTreeObject.getRevenueSharedList() );
            for ( UiRevenuePricing revenue : revenueList ) {
                addRow( tableShare, revenue, false );
            }
        }

        if ( currentTreeObject.getTieredPricingList() != null ) {
            tieredPricingList.clear();
            tieredPricingList.addAll( currentTreeObject.getTieredPricingList() );
            for ( UiRevenuePricing revenue : tieredPricingList ) {
                addRow( tablePricing, revenue, true );
            }
        }

        updateFormFromUserDefinedFieldValues( currentTreeObject.getUserDefinedFieldValues() );

    }

    private void fillTypedList( TypedListBoxWidget<Long> widget ) {
        widget.clear();
        widget.addItem( "", null );
        if ( currencyList != null ) {
            for ( UiCurrency cur : currencyList ) {
                widget.addItem( cur.getName() + " (" + cur.getSymbol() + ")", cur.getKey() );
            }
        }
    }

    @Override
    public void commit() {
        currentTreeObject.setModified( true );

        currentTreeObject.setPrActualLicenseFee(actualLicenseFee.getValue());
        currentTreeObject.setPrActualRetailPrice(actualRetailPrice.getValue());
        currentTreeObject.setPrCurrency( getCurrency( paymentCurrency.getSelectedItem() ) );
        currentTreeObject.setPrDeemedRetailPrice(deemedRetailPrice.getValue());
        currentTreeObject.setPrGuaranteedBuyRate(buyRate.getValue());
        if ( subscribers.getValue() != null ) {
            currentTreeObject.setPrGuaranteedSubscribers( subscribers.getValue().longValue() );
        } else {
            currentTreeObject.setPrGuaranteedSubscribers( null );
        }
        currentTreeObject.setPrInstallmentPlan(installmentPlanText.getValue());
        if ( installmentPlanNo.getValue() ) {
            currentTreeObject.setPrInstallmentPlan( null );
        }
        currentTreeObject.setPrInstallmentPlanRequired( installmentPlanYes.getValue() );
        currentTreeObject.setPrLostBuys(lostBuys.getValue());
        currentTreeObject.setPrMinimumLicenseFee(minimumLicenseFee.getValue());
        currentTreeObject.setPrOverage(overageRequired.getValue());
        if ( paymentScheduleRequiredNo.getValue() ) {
            currentTreeObject.setPrOverage( null );
        }
        currentTreeObject.setPrOverageRequired( paymentScheduleRequiredYes.getValue() );
        currentTreeObject.setPrRevenueShare(revenueShare.getValue());
        currentTreeObject.setPrRevenueShareRequired( revenueShareRequiredYes.getValue() );
        currentTreeObject.setPrTieredPricingRequired( tieredPricingRequiredYes.getValue() );
        currentTreeObject.setPrUpfrontPayment(upfrontPaymentRequired.getValue());
        if ( upfrontPaymentRequiredNo.getValue() ) {
            currentTreeObject.setPrUpfrontPayment( null );
        }

        currentTreeObject.setPrUpfrontPaymentRequired( upfrontPaymentRequiredYes.getValue() );
        updateUserDefinedFieldsValuesFromForm( currentTreeObject.getUserDefinedFieldValues() );

        currentTreeObject.getTieredPricingList().clear();
        currentTreeObject.getTieredPricingList().addAll( tieredPricingList );

        currentTreeObject.getRevenueSharedList().clear();
        currentTreeObject.getRevenueSharedList().addAll( revenueList );

        overrideChildrenValues();
    }

    private UiCurrency getCurrency( Long key ) {
        if ( key != null ) {
            for ( UiCurrency currency : currencyList ) {
                if ( currency.getKey().equals( key ) ) {
                    return currency;
                }
            }
        }

        return null;
    }

    private void overrideChildrenValues() {
        if ( currentTreeObject != null ) {
            for ( UiLicenseDetails licenseDetails : currentTreeObject.getAllChildren() ) {
                licenseDetails.setModified( true );
                LicenseDetailsUtils.copyPricingValues( currentTreeObject, licenseDetails );
                copyUserDefinedFieldValues( licenseDetails.getUserDefinedFieldValues() );
            }
        }
    }

}
