package com.ericsson.cms.contractmgmt.client.tab.license.tab;



import java.util.ArrayList;

import java.util.Date;

import java.util.List;



import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;

import com.ericsson.cms.contractmgmt.client.Permissions;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;

import com.ericsson.cms.contractmgmt.client.model.UiKeyName;

import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;

import com.ericsson.cms.contractmgmt.client.model.UiLanguage;

import com.ericsson.cms.contractmgmt.client.model.UiLicense;

import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;

import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;

import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;

import com.ericsson.cms.contractmgmt.client.tab.license.AbstractLicenseTab;

import com.ericsson.cms.contractmgmt.client.tab.license.LicenseDetailView;

import com.google.gwt.core.client.GWT;

import com.google.gwt.event.dom.client.ChangeEvent;

import com.google.gwt.event.dom.client.ChangeHandler;

import com.google.gwt.event.dom.client.ClickEvent;

import com.google.gwt.event.dom.client.ClickHandler;

import com.google.gwt.i18n.client.DateTimeFormat;

import com.google.gwt.user.client.ui.HasHorizontalAlignment;

import com.google.gwt.user.client.ui.HorizontalPanel;

import com.google.gwt.user.datepicker.client.CalendarUtil;

import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;

import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;

import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;



public class StorageMetadataTab extends AbstractLicenseTab {



    private final ContractComponentConstants constants = (ContractComponentConstants) GWT

            .create( ContractComponentConstants.class );



    private final ContractComponentMessages messages = (ContractComponentMessages) GWT

            .create( ContractComponentMessages.class );



    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT

            .create( IContractManagerDropDownService.class );



    private static final int VISIBLE_LENGTH = 10;



    private ListBoxWidget<Long> language;

    private final ContractFormContainer formContainer = new ContractFormContainer(

            HasHorizontalAlignment.ALIGN_LEFT );

    private RadioButtonWidget posterArtRequiredYes;

    private RadioButtonWidget posterArtRequiredNo;

    private RadioButtonWidget previewRequiredYes;

    private RadioButtonWidget previewRequiredNo;

    private RadioButtonWidget inheritFromDeal1;

    private RadioButtonWidget specify1;

    private RadioButtonWidget inheritFromDeal2;

    private RadioButtonWidget specify2;

    private final TypedDateBoxWidget contentEffectiveDate = new TypedDateBoxWidget( new DateConverter(

            constants.dateFormat(), constants.dateFormat() ) );

    private final TypedDateBoxWidget contentExpiryDate = new TypedDateBoxWidget( new DateConverter(

            constants.dateFormat(), constants.dateFormat() ) );



    public StorageMetadataTab( UiLicense license, final LicenseDetailView detailView ) {

        super( license, detailView );

        busyIndicator.center();

        init();

        contentPanel.add( formContainer );

        contractManagerDropDownService.getGenericDropDownKeyNameList( 0, 0, "", true,

                ConfigurableFieldTypeEnum.Language, new NeptuneAsyncCallback<UiKeyNames>() {



            @Override

            public void onNeptuneFailure( Throwable caught ) {

                detailView.getErrorPanel().showMessage( caught.getLocalizedMessage() );

                busyIndicator.hide();

            }



            @Override

            public void onNeptuneSuccess( UiKeyNames result ) {

                for ( UiKeyName ui : result.getRecords() ) {

                    language.addItem( ui.getName(), ui.getKey() );

                }

                fillForm();

                busyIndicator.hide();

            }



        } );



    }



    public void init() {

        final DateTimeFormat dateFormatter = DateTimeFormat.getFormat( constants.dateFormat() );



        language = new ListBoxWidget<Long>( true );

        language.addChangeHandler( new ChangeHandler() {



            @Override

            public void onChange( ChangeEvent event ) {

                setChanged( true );

            }

        } );

        language.setWidth( "190px" );

        language.ensureDebugId("license-language");



        posterArtRequiredYes = new RadioButtonWidget( "posterArt", constants.yes() );

        posterArtRequiredYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );

        posterArtRequiredYes.ensureDebugId("license-posterArtRequiredYes");

        posterArtRequiredNo = new RadioButtonWidget( "posterArt", constants.no() );

        posterArtRequiredNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );

        posterArtRequiredNo.ensureDebugId("license-posterArtRequiredNo");

        HorizontalContainer posterArtRequired = createRadioContainer( posterArtRequiredYes,

                posterArtRequiredNo );



        previewRequiredYes = new RadioButtonWidget( "preview", constants.yes() );

        previewRequiredYes.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );

        previewRequiredYes.ensureDebugId("license-previewRequiredYes");

        previewRequiredNo = new RadioButtonWidget( "preview", constants.no() );

        previewRequiredNo.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );

        previewRequiredNo.ensureDebugId("license-previewRequiredNo");

        HorizontalContainer previewRequired = createRadioContainer( previewRequiredYes, previewRequiredNo );



        contentEffectiveDate.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );

        configureDateBox( contentEffectiveDate );

        contentEffectiveDate.setEnabled( false );

        contentEffectiveDate.ensureDebugId("license-contentEffectiveDate");

        if ( getLicense().getEffectiveDate() != null ) {

            contentEffectiveDate.setValue( dateFormatter.format( getLicense().getEffectiveDate() ) );

        }

        inheritFromDeal1 = new RadioButtonWidget( "effective", constants.storageInheritLicense() );

        inheritFromDeal1.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );

        inheritFromDeal1.setValue( true );

        inheritFromDeal1.ensureDebugId("license-inheritFromLicense1");



        inheritFromDeal1.addClickHandler( new ClickHandler() {

            @Override

            public void onClick( ClickEvent event ) {

                contentEffectiveDate.setValue( dateFormatter.format( getLicense().getEffectiveDate() ) );

                contentEffectiveDate.setEnabled( false );

            }

        } );

        specify1 = new RadioButtonWidget( "effective", constants.specify() );

        specify1.ensureDebugId("license-specify1");

        specify1.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );

        specify1.addClickHandler( new ClickHandler() {

            @Override

            public void onClick( ClickEvent event ) {

                contentEffectiveDate.setEnabled( true );

                contentEffectiveDate.setFocus( true );

            }

        } );



        HorizontalContainer effective = createRadioContainer( inheritFromDeal1, specify1 );

        specify1.setValue( false );

        addSpace( effective );

        effective.add( contentEffectiveDate );



        contentExpiryDate.addValueChangeHandler( new TabValueChangeHandler<String>( this ) );

        configureDateBox( contentExpiryDate );

        contentExpiryDate.setEnabled( false );

        contentExpiryDate.ensureDebugId("license-contentExpiryDate");

        if ( getLicense().getExpiryDate() != null ) {

            contentExpiryDate.setValue( dateFormatter.format( getLicense().getExpiryDate() ) );

        }

        inheritFromDeal2 = new RadioButtonWidget( "expiry", constants.storageInheritLicense() );

        inheritFromDeal2.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );

        inheritFromDeal2.setValue( true );

        inheritFromDeal2.ensureDebugId("license-inheritFromLicense2");

        inheritFromDeal2.addClickHandler( new ClickHandler() {

            @Override

            public void onClick( ClickEvent event ) {

                contentExpiryDate.setValue( dateFormatter.format( getLicense().getExpiryDate() ) );

                contentExpiryDate.setEnabled( false );

            }

        } );

        specify2 = new RadioButtonWidget( "expiry", constants.specify() );

        specify2.ensureDebugId("license-specify2");

        specify2.addValueChangeHandler( new TabValueChangeHandler<Boolean>( this ) );

        specify2.addClickHandler( new ClickHandler() {

            @Override

            public void onClick( ClickEvent event ) {

                contentExpiryDate.setEnabled( true );

                contentExpiryDate.setFocus( true );

            }

        } );



        HorizontalContainer expiry = createRadioContainer( inheritFromDeal2, specify2 );

        specify2.setValue( false );

        addSpace( expiry );

        expiry.add( contentExpiryDate );



        formContainer.addRow( constants.storageLanguageColumn(), language, true );

        formContainer.addRow( constants.storagePosterArtRequiredColumn(), posterArtRequired, true );

        formContainer.addRow( constants.storagePreviewRequiredColumn(), previewRequired, true );

        formContainer.addRow( constants.storageEffectiveDateColumn(), effective, true );

        formContainer.addRow( constants.storageExpiryDateColumn(), expiry, true );



        CustomFieldFactory factory = new CustomFieldFactory( this );

        List<UiUserDefinedField> userDefinedFields = getLicense().getUserDefinedFields(

                CustomFieldFactory.STORAGE_METADATA_SCREEN );

        factory.addFieldsToForm( formContainer, userDefinedFields, widgetCustomFieldMap );



        boolean isCreating = getLicense().getKey() == null;

        if ( isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE )

                || !isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) ) {

            formContainer.addButton( getApplyChangesButton() );

        }



    }



    private void configureDateBox( TypedDateBoxWidget dateBox ) {

        dateBox.getTextBox().setMaxLength( VISIBLE_LENGTH );

        dateBox.getTextBox().setVisibleLength( VISIBLE_LENGTH );

        dateBox.setToolTip( constants.validDateTitle() + " " + constants.dateFormat() );

        dateBox.setErrorToolTip( constants.validDateTitle() + " " + constants.dateFormat() );

    }



    private HorizontalContainer createRadioContainer( RadioButtonWidget radio1, RadioButtonWidget radio2 ) {

        HorizontalContainer container = new HorizontalContainer();



        container.add( radio1 );

        addSpace( container );



        radio2.setValue( true );

        container.add( radio2 );



        return container;

    }



    private void addSpace( HorizontalContainer container ) {

        if ( container != null ) {

            HorizontalPanel space = new HorizontalPanel();

            LabelWidget label = new LabelWidget();

            space.add( label );

            space.setCellWidth( label, "10" );

            container.add( space );

        }

    }



    private void fillRadioValues( RadioButtonWidget radio1, RadioButtonWidget radio2, Boolean value ) {

        if ( value != null && value ) {

            radio1.setValue( true );

            radio2.setValue( false );

        } else {

            radio1.setValue( false );

            radio2.setValue( true );

        }

    }



    @Override

    public String getName() {

        return CustomFieldFactory.STORAGE_METADATA_SCREEN;

    }



    @Override

    public String getDisplayName() {

        return constants.storageTabDisplayName();

    }



    @Override

    public void commit() {

        currentTreeObject.setModified( true );

        if ( specify1.getValue() ) {

            currentTreeObject.setSmEffectiveDate( contentEffectiveDate.getDatePicker().getValue() );

        } else {

            currentTreeObject.setSmEffectiveDate( getLicense().getEffectiveDate() );

        }



        if ( specify2.getValue() ) {

            currentTreeObject.setSmExpiryDate( contentExpiryDate.getDatePicker().getValue() );

        } else {

            currentTreeObject.setSmExpiryDate( getLicense().getExpiryDate() );

        }



        currentTreeObject.getLanguageList().clear();

        currentTreeObject.getLanguageList().addAll( createSelectedLanguageList() );

        currentTreeObject.setSmPosterArtRequired( posterArtRequiredYes.getValue() );

        currentTreeObject.setSmPreviewRequired( previewRequiredYes.getValue() );

        updateUserDefinedFieldsValuesFromForm( currentTreeObject.getUserDefinedFieldValues() );



        overrideChildrenValues();



    }



    private List<UiLanguage> createSelectedLanguageList() {

        List<UiLanguage> languageList = new ArrayList<UiLanguage>();

        for ( int i = 0; i < language.getItemCount(); i++ ) {

            if ( language.isItemSelected( i ) ) {

                UiLanguage uiLanguage = new UiLanguage();

                uiLanguage.setKey( language.getItem( i ) );

                uiLanguage.setName( language.getItemText( i ) );

                languageList.add( uiLanguage );

            }

        }

        return languageList;

    }



    @Override

    public void fillForm() {

        formContainer.clearAllValidationErrors();

        fillRadioValues( posterArtRequiredYes, posterArtRequiredNo,

                currentTreeObject.getSmPosterArtRequired() );

        fillRadioValues( previewRequiredYes, previewRequiredNo, currentTreeObject.getSmPreviewRequired() );



        for ( int i = 0; i < language.getItemCount(); i++ ) {

            language.setItemSelected( i, false );

        }



        for ( UiLanguage ui : currentTreeObject.getLanguageList() ) {

            language.setItemSelected( language.getIndex( ui.getKey() ), true );

        }



        DateTimeFormat dateFormatter = DateTimeFormat.getFormat( constants.dateFormat() );

        if ( currentTreeObject.getSmEffectiveDate() != null ) {

            if ( CalendarUtil.isSameDate( currentTreeObject.getSmEffectiveDate(), getLicense()

                    .getEffectiveDate() ) ) {

                inheritFromDeal1.setValue( true );

                contentEffectiveDate.setValue( dateFormatter.format( getLicense().getEffectiveDate() ) );

                contentEffectiveDate.setEnabled( false );

            } else {

                specify1.setValue( true );

                contentEffectiveDate.setEnabled( true );

                contentEffectiveDate.setValue( dateFormatter.format( currentTreeObject.getSmEffectiveDate() ) );

            }

        } else {

            contentEffectiveDate.setValue( dateFormatter.format( getLicense().getEffectiveDate() ) );

            contentEffectiveDate.setEnabled( false );

        }



        if ( currentTreeObject.getSmExpiryDate() != null ) {

            if ( CalendarUtil.isSameDate( currentTreeObject.getSmExpiryDate(), getLicense().getExpiryDate() ) ) {

                inheritFromDeal2.setValue( true );

                contentExpiryDate.setValue( dateFormatter.format( getLicense().getExpiryDate() ) );

                contentExpiryDate.setEnabled( false );

            } else {

                specify2.setValue( true );

                contentExpiryDate.setEnabled( true );

                contentExpiryDate.setValue( dateFormatter.format( currentTreeObject.getSmExpiryDate() ) );

            }

        } else {

            contentExpiryDate.setValue( dateFormatter.format( getLicense().getExpiryDate() ) );

            contentExpiryDate.setEnabled( false );

        }



        updateFormFromUserDefinedFieldValues( currentTreeObject.getUserDefinedFieldValues() );



    }



    @Override

    public void validate() throws ValidationException {



        List<String> validationMessages = new ArrayList<String>();



        if ( !formContainer.validate() ) {

            validationMessages.add( messages.formHasValidationErrors() );

        }



        if (specify1.getValue() && contentEffectiveDate.getDatePicker().getValue() != null) {

            Date effective = contentEffectiveDate.getDatePicker().getValue();

            if (!CalendarUtil.isSameDate(effective, getLicense().getEffectiveDate())

                    && effective.before(getLicense().getEffectiveDate())) {

                validationMessages.add(messages.storageDateMessage(constants.storageEffectiveDateColumn()));

            }

        }



        if (specify2.getValue() && contentExpiryDate.getDatePicker().getValue() != null) {

            Date expiry = contentExpiryDate.getDatePicker().getValue();

            if (!CalendarUtil.isSameDate(expiry, getLicense().getExpiryDate())

                    && expiry.after(getLicense().getExpiryDate())) {

                validationMessages.add(messages.storageDateMessage(constants.storageExpiryDateColumn()));

            }

        }



        validateCustomFields( validationMessages );



        if ( !validationMessages.isEmpty() ) {

            throw new ValidationException( validationMessages );

        }



    }



    private void overrideChildrenValues() {

        if ( currentTreeObject != null ) {

            for ( UiLicenseDetails licenseDetails : currentTreeObject.getAllChildren() ) {

                licenseDetails.setModified( true );

                LicenseDetailsUtils.copyStorageMetadataValues( currentTreeObject, licenseDetails );

                copyUserDefinedFieldValues( licenseDetails.getUserDefinedFieldValues() );

            }

        }

    }



}

