package com.ericsson.cms.contractmgmt.client.tab.license.tree;

import java.util.Iterator;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.HelpWidget;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class DeviceTreePanel extends VerticalContainer {

    private final LabelWidget defaultLabel;
    private final HorizontalContainer defaultContainer;
    private DeviceTree deviceTree;
    private UiLicense license;

    protected ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    protected ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create( ContractComponentMessages.class );

    public DeviceTreePanel( final UiLicense license, final TreeListener treeListener ) {
        this.license = license;
        deviceTree = createDeviceTree( license, treeListener );

        defaultLabel = new LabelWidget( constants.treeDefaultNode() );
        defaultContainer = new HorizontalContainer();
        defaultContainer.add( defaultLabel );
        defaultContainer.setCellWidth( defaultLabel, "5%" );
        defaultLabel.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                treeListener.nodeSelected( license.getDefaultLicenseDetails() );
                deviceTree.selectNone();
                setDefaultSelected( true );
            }
        } );
        
        LabelWidget spaceLabel = new LabelWidget("");
        defaultContainer.add( spaceLabel );
        defaultContainer.setCellWidth( spaceLabel, "5px" );
        defaultContainer.add( new HelpWidget( messages.treeDefaultNodeWarning() ) );

        add( defaultContainer );
        ScrollPanel sp = new ScrollPanel();
        sp.setAlwaysShowScrollBars( false );
        sp.add( deviceTree );
        add( sp );

        setDefaultSelected( true );
    }

    private DeviceTree createDeviceTree( final UiLicense license, final TreeListener treeListener ) {
        DeviceTree device = new DeviceTree( license.getLicenseDetailsList(),
                license.getDefaultLicenseDetails(), treeListener );
        device.addSelectionHandler( new SelectionHandler<TreeItem>() {

            @Override
            public void onSelection( SelectionEvent<TreeItem> event ) {
                setDefaultSelected( false );
            }
        } );
        return device;
    }

    public void updateModifiedItems() {
        if ( license.getDefaultLicenseDetails().isModified() ) {
            defaultLabel.setText( constants.treeDefaultNode() + "*" );
        } else {
            defaultLabel.setText( constants.treeDefaultNode() );
        }

        Iterator<TreeItem> iterator = deviceTree.treeItemIterator();
        while ( iterator.hasNext() ) {
            TreeItem treeItem = iterator.next();
            String name = treeItem.getText();
            boolean disabled = false;
            UiLicenseDetails licenseDetails = (UiLicenseDetails) treeItem.getUserObject();
            if ( licenseDetails != null ) {
                if ( licenseDetails.isModified() && ( !( name.lastIndexOf( "*" ) == name.length() - 1 ) ) ) {
                    name += "*";
                }
            } else {
                disabled = true;
            }
            treeItem.setWidget( deviceTree.buildTreeItemWidget( name, disabled ) );
        }

    }

    public void setDefaultSelected( boolean selected ) {
        if ( selected ) {
            defaultContainer.setStyleName( "contract-DeviceTree-item-default-selected" );
        } else {
            defaultContainer.setStyleName( "contract-DeviceTree-item-default" );
        }
    }

}
