package com.ericsson.cms.epgmgmt.client;

import static com.ericsson.cms.epgmgmt.client.model.UIConstants.ACTIVITY_LOG;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_MANAGER;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_NORMALIZATION_RULES;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_PROVIDER;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_RECEIVER;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_VALIDATION_RULES;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.JOB_MANAGEMENT;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.PLUGIN_MANAGEMENT;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.PROGRAM_GUIDE;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.RULE_ENGINE;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyViewWidgetFactory;

/**
 * 
 * @author epatanu
 *
 */

public class EPGComponent extends ComponentBase {

    private final EPGComponentConstants constants;

    public EPGComponent(){
        // initialize epg  manager constants class
        constants = GWT.create(EPGComponentConstants.class);

    }

    @Override
    public List<PortletFactory> listPortlets(NeptuneSecurity security) {

        return new ArrayList<PortletFactory>();

    }

    @Override
    public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
        List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();

        /* Build the menu items for the 'epg' entity */
        MenuItemBase menuItem = buildEPGManagerMenuItem();
        if (menuItem != null) {
            tabs.add(menuItem);
        }

        return tabs;
    }

    /**
     * 
     * @return
     */

    private MenuItemBase  buildEPGManagerMenuItem(){

        List<MenuItemBase> epgManagerGroup = new ArrayList<MenuItemBase>();
        String displayName = constants.menuItemEPGManager();
        GroupMenuItem menuItem = new GroupMenuItem(EPG_MANAGER, displayName, epgManagerGroup );

        // view provider sub-menu
        if (ClientAuthorizationManager.isAuthorized(Permissions.EPG_VIEW)) {
            // program guide panel
            final LazyProgramGuideView programGuideLazyViewFactory = new LazyProgramGuideView();
            WidgetMenuItem programViewMenuItem = new WidgetMenuItem(PROGRAM_GUIDE, constants.programGuide(), programGuideLazyViewFactory, programGuideLazyViewFactory.getAnchorChangeListener() );
            epgManagerGroup.add(programViewMenuItem);
            
            // provider view panel
            final ProviderViewWidgetFactory providerFactory = new ProviderViewWidgetFactory();
            WidgetMenuItem providerMenuItem = new WidgetMenuItem(EPG_PROVIDER, constants.viewProvider(), providerFactory,
                    providerFactory.getAnchorChangeListener());
            epgManagerGroup.add(providerMenuItem);
            
            // receiver view panel
            final LazyViewWidgetFactory  publisherLazyViewFactory = new LazyViewWidgetFactory(new LazyPublisherPanel());
            WidgetMenuItem publisherMenuItem = new WidgetMenuItem(EPG_RECEIVER, constants.publisher(),
                    publisherLazyViewFactory, publisherLazyViewFactory.getAnchorChangeListener());
            epgManagerGroup.add(publisherMenuItem);
            
            buildRulesMenuItem(menuItem);
            
            // Job panel
            final LazyJobListView jobStatusView = new LazyJobListView();
            WidgetMenuItem jobStatusMenuItem = new WidgetMenuItem(JOB_MANAGEMENT, constants.jobManagement(), jobStatusView,
                    jobStatusView.getAnchorChangeListener());
            epgManagerGroup.add(jobStatusMenuItem);
            
            //Activity log panel
            final LazyActivityLogView activityLogViewFactory = new LazyActivityLogView();
            WidgetMenuItem activityViewMenuItem = new WidgetMenuItem(ACTIVITY_LOG, constants.activityLog(), activityLogViewFactory , activityLogViewFactory.getAnchorChangeListener());
            epgManagerGroup.add(activityViewMenuItem);
            
            // plug-in management panel
            final LazyPluginMgmtView pluginMgmtFactory = new LazyPluginMgmtView();
            WidgetMenuItem pluginMgmtViewMenuItem = new WidgetMenuItem(PLUGIN_MANAGEMENT, constants.pluginMgmt(),
                    pluginMgmtFactory, pluginMgmtFactory.getAnchorChangeListener());
            epgManagerGroup.add(pluginMgmtViewMenuItem);
        }
        
        return menuItem;
    }

    private void buildRulesMenuItem(GroupMenuItem parentMenuItem) {
        List<MenuItemBase> ruleGroup = new ArrayList<MenuItemBase>();
        String displayName = constants.ruleEngine();
        GroupMenuItem menuItem = new GroupMenuItem(RULE_ENGINE, displayName, ruleGroup);
        parentMenuItem.getSubPanels().add(menuItem);
        
        // Normalization Rules panel
        final LazyEPGNormalizationRulesView normalizationRulesLazyViewFactory = new LazyEPGNormalizationRulesView();
        WidgetMenuItem normalizationRulesViewMenuItem = new WidgetMenuItem(EPG_NORMALIZATION_RULES, constants.normalizationRules(), normalizationRulesLazyViewFactory, normalizationRulesLazyViewFactory.getAnchorChangeListener() );
        ruleGroup.add(normalizationRulesViewMenuItem);

        // Validation Rules panel
        final LazyEPGValidationRulesView validationRulesLazyViewFactory = new LazyEPGValidationRulesView();
        WidgetMenuItem validationRulesViewMenuItem = new WidgetMenuItem(EPG_VALIDATION_RULES, constants.validationRules(), validationRulesLazyViewFactory, validationRulesLazyViewFactory.getAnchorChangeListener() );
        ruleGroup.add(validationRulesViewMenuItem);
    }

    @Override
    public <E extends Service> List<E> listServices(Class<E> clazz,
            NeptuneSecurity security) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public String getName() {
        return "EPGComponent";
    }

    @Override
    public String getDisplayName() {

        return constants.componentDisplayName();
    }

}
