package com.ericsson.cms.epgmgmt.client;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * Widget used to display error messages for the contract manager module.
 * 
 * @author Daniel Paranhos
 * 
 */
public class ErrorPanel extends SimpleContainer {

    private static final String ERROR_MESSAGE_STYLE = "contract-ValidationView-error ";
    private static final String SECTION_HEADING1_STYLE = "contract-ValidationView-sectionHeading1";
    private static final String SECTION_HEADING2_STYLE = "contract-ValidationView-sectionHeading2";
    private static final String PANEL_STYLE = "contract-ValidationView";
    private static final int PANEL_SPACING = 5;

    private final VerticalContainer mainContainer;
    private final VerticalContainer messageContainer;



    public ErrorPanel() {
        super();

        mainContainer = new VerticalContainer();
        mainContainer.addStyleName( PANEL_STYLE );
        mainContainer.addStyleName( ERROR_MESSAGE_STYLE );
        mainContainer.setSpacing( PANEL_SPACING );
        // or else border doesn't show up
        mainContainer.setWidth( "99%" );
        mainContainer.setVisible( false );

        messageContainer = new VerticalContainer();
        mainContainer.add( messageContainer );

        add( mainContainer );
    }

    /**
     * Sets the message text with the given value.
     * 
     * @param message
     */
    public void showMessage( String message ) {
        messageContainer.clear();
        addMessage( message );
    }

    /**
     * Adds the message text with the given value.
     * 
     * @param message
     */
    public void addMessage( String message ) {
        if ( message != null && !message.trim().equals( "" ) ) {
            mainContainer.setVisible( true );
            messageContainer.add( createMessageLabel( "", message, SECTION_HEADING1_STYLE ) );
        }
    }

    /**
     * Adds the heading level 1 text with the given value.
     * 
     * @param message
     */
    public void addHeading1( String message ) {
        if ( message != null && !message.trim().equals( "" ) ) {
            mainContainer.setVisible( true );
            messageContainer.add( createMessageLabel( "", message, SECTION_HEADING1_STYLE ) );
        }
    }
    /**
     * Adds the heading level 2 text with the given value.
     * 
     * @param message
     */
    public void addHeading2( String message ) {
        if ( message != null && !message.trim().equals( "" ) ) {
            mainContainer.setVisible( true );
            messageContainer.add( createMessageLabel( "- ", message, SECTION_HEADING2_STYLE ) );
        }
    }


    private LabelWidget createMessageLabel( String prefix, String message, String style ) {
        LabelWidget messageLabel = new LabelWidget();

        messageLabel.setText( prefix + message );
        messageLabel.addStyleName( style );
        messageLabel.addStyleName( ERROR_MESSAGE_STYLE );
        messageLabel.setWordWrap( true );
        return messageLabel;
    }

    /**
     * Clears the text in all contained widgets.
     * 
     */
    public void reset() {
        messageContainer.clear();
        mainContainer.setVisible( false );
    }

}
