package com.ericsson.cms.epgmgmt.client;

import java.util.Date;

import com.ericsson.cms.epgmgmt.client.alarmactivitylog.ActivityLogDetailView;
import com.ericsson.cms.epgmgmt.client.alarmactivitylog.ActivityLogFilterView;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UIActivityLog;
import com.ericsson.cms.epgmgmt.client.model.enumeration.LogSourceTypeEnum;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PluginLogComponentEnum;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PluginLogSeverityEnum;
import com.ericsson.cms.epgmgmt.client.utils.DateConvert;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class LazyActivityLogView implements WidgetFactory {

    private static final String ANCHOR_ACTIVITY_LOG_RESULT = "ActivityLogFilter.Result";
    private final SimpleContainer baseWidget;

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);

    public LazyActivityLogView(){
        baseWidget = new SimpleContainer();
    }

    public AnchorChangeListener getAnchorChangeListener() {
        return new AnchorChangeListener() {
            @Override
            public void anchorChanged(String anchor) {
                changeAnchor(anchor);
            }
        };
    }

    private void changeAnchor(String anchor) {
        // Show Activity Log Filter Criteria
        if (anchor == null || anchor.trim().length() == 0) {
            baseWidget.setWidget(new ActivityLogFilterView());
        } else if(anchor.startsWith(ANCHOR_ACTIVITY_LOG_RESULT)) { // Activity Log details based on filter criteria
            String parameters = anchor.substring(anchor.indexOf('?')+1);
            baseWidget.setWidget(new ActivityLogDetailView(getUiActivityLog(parameters)));
        } else {
            Window.alert("Invalid URL");
        }
    }

    @Override
    public Widget getInstance() {
        return baseWidget;
    }

    @Override
    public void release(Widget widget) {
        baseWidget.clear();
    }

    private UIActivityLog getUiActivityLog(String parameters){
        UIActivityLog uiActivityLog = new UIActivityLog();

        String[] ptokens = parameters.split("&");
        int i=0;
        while (i < ptokens.length){
            String[] param =  ptokens[i].split("=");
            if (param[1] != null){
                if (param[0].equalsIgnoreCase("severity")) {
                    uiActivityLog.setSeverity(PluginLogSeverityEnum
                            .getEnumNameByValue(Integer.parseInt(param[1])));
                } else if (param[0].equalsIgnoreCase("component")) {
                    uiActivityLog.setComponent(PluginLogComponentEnum
                            .getEnumNameByValue(Integer.parseInt(param[1])));
                } else if(param[0].equalsIgnoreCase("sourceType")) {
                    uiActivityLog.setSourceType(LogSourceTypeEnum.getEnumNameByValue(Integer.parseInt(param[1])));
                } else if(param[0].equalsIgnoreCase("partner")) {
                    uiActivityLog.setSourceId(Long.parseLong(param[1]));
                } else if (param[0].equalsIgnoreCase("startDate")) {
                    Date startDate = DateConvert.parseDate(constants.activityLogDateFormat(), param[1]);
                    uiActivityLog.setStartDate(startDate.getTime());
                } else if (param[0].equalsIgnoreCase("endDate")) {
                    Date endDate = DateConvert.parseDate(constants.activityLogDateFormat(), param[1]);
                    uiActivityLog.setEndDate(endDate.getTime());
                }
            }
            i++;
        }
        return uiActivityLog;
    }

}
