package com.ericsson.cms.epgmgmt.client;

import com.ericsson.cms.epgmgmt.client.rules.NormalizationDetailsView;
import com.ericsson.cms.epgmgmt.client.rules.RulesListViewPanel;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class LazyEPGNormalizationRulesView implements WidgetFactory {
    private static final String ANCHOR_ID_PREFIX = "Edit?id=";
    private static final String ANCHOR_CREATE = "Create";

    private final SimpleContainer baseWidget;

    public LazyEPGNormalizationRulesView() {
        baseWidget = new SimpleContainer();
    }

    public AnchorChangeListener getAnchorChangeListener() {
        return new AnchorChangeListener() {
            @Override
            public void anchorChanged(String anchor) {
                changeAnchor(anchor);
            }
        };
    }

    private void changeAnchor(String anchor) {
        // list the rule sets
        if (anchor == null || anchor.trim().length() == 0) {
            baseWidget.setWidget(new RulesListViewPanel(true));
        } else if(anchor.startsWith(ANCHOR_ID_PREFIX)) { // view or edit a rule set
            // TODO: Handle the tab from which the edit click happened
            // Or does the table widget handle it?
            String idStr = anchor.substring(ANCHOR_ID_PREFIX.length());
            long id;
            try {
                id = Long.parseLong(idStr);
            } catch(Exception e) {
                Window.alert("Invalid id.");
                return;
            }
            baseWidget.setWidget(new NormalizationDetailsView(id));
        } else if(anchor.startsWith(ANCHOR_CREATE)) { // create a normalization rule set
            baseWidget.setWidget(new NormalizationDetailsView(null));
        } else {
            Window.alert("Invalid URL");
        }
    }

    @Override
    public Widget getInstance() {
        return baseWidget;
    }

    @Override
    public void release(Widget widget) {
        baseWidget.clear();
    }

}
