package com.ericsson.cms.epgmgmt.client;

import com.ericsson.cms.epgmgmt.client.plugin.EPGPluginListViewPanel;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class LazyPluginMgmtView implements WidgetFactory {

    private final SimpleContainer baseWidget;

    public LazyPluginMgmtView() {
        baseWidget = new SimpleContainer();
    }

    public AnchorChangeListener getAnchorChangeListener() {
        return new AnchorChangeListener() {
            @Override
            public void anchorChanged(String anchor) {
                changeAnchor(anchor);
            }
        };
    }

    private void changeAnchor(String anchor) {
        if (anchor == null || anchor.trim().length() == 0) {
            baseWidget.setWidget(new EPGPluginListViewPanel());
        } else {
            Window.alert("Invalid URL");
        }
    }

    @Override
    public Widget getInstance() {
        return baseWidget;
    }

    @Override
    public void release(Widget widget) {
        baseWidget.clear();
    }
}
