package com.ericsson.cms.epgmgmt.client;

import java.util.Date;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UiProgramGuideFilter;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PGSortPropertyEnum;
import com.ericsson.cms.epgmgmt.client.programguide.ProgramGuideDisplayPanel;
import com.ericsson.cms.epgmgmt.client.programguide.ProgramGuideViewPanel;
import com.ericsson.cms.epgmgmt.client.utils.DateConvert;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class LazyProgramGuideView implements WidgetFactory {
    private static final String ANCHOR_GUIDEDATA_PREFIX = "GuideData?";
    private SimpleContainer baseWidget = null;
    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);

    private final EPGComponentMessages messages = (EPGComponentMessages) GWT
            .create(EPGComponentMessages.class);


    public LazyProgramGuideView() {
        baseWidget = new SimpleContainer();
    }

    public AnchorChangeListener getAnchorChangeListener() {
        return new AnchorChangeListener() {
            @Override
            public void anchorChanged(String anchor) {
                replaceWidget(anchor);
            }
        };
    }

    private void replaceWidget(String anchor) {
        // show the guide data filter
        if (anchor == null || anchor.trim().length() == 0) {
            ProgramGuideViewPanel programGuideFilterPanel = new ProgramGuideViewPanel();

            baseWidget.setWidget(programGuideFilterPanel);
        } else if(anchor.startsWith(ANCHOR_GUIDEDATA_PREFIX)) {
            String params = anchor.substring(ANCHOR_GUIDEDATA_PREFIX.length());
            UiProgramGuideFilter filter = getUiProgramGuideFilter(params);
            if (filter == null) {
                Window.alert(messages.invalidUrl());
                return;
            } else {
                baseWidget.setWidget(new ProgramGuideDisplayPanel(filter, baseWidget));
            }
        } else {
            Window.alert(messages.invalidUrl());
        }
    }

    private UiProgramGuideFilter getUiProgramGuideFilter(String params) {
        UiProgramGuideFilter filter = new UiProgramGuideFilter() ;
        long startDateInMilliSeconds = 0l;
        long endDateInMilliSeconds = 0l;

        String[] paramArray = params.split("&");
        for (int i = 0; i < paramArray.length; i++) {
            String[] param =  paramArray[i].split("=");
            if (param.length == 2 && param[1] != null) {
                if (param[0].equalsIgnoreCase("isAscending")) {
                    filter.setAscending(Boolean.parseBoolean(param[1]));
                }
                else if (param[0].equalsIgnoreCase("duration")) {
                    filter.setDuration(param[1]);
                }
                else if (param[0].equalsIgnoreCase("providerId")) {
                    filter.setProviderId(param[1]);
                }
                else if (param[0].equalsIgnoreCase("headendIds")) {
                    filter.setHeadendIds(param[1]);
                }
                else if (param[0].equalsIgnoreCase("headendExclude")) {
                    filter.setHeandendExclude(Boolean.parseBoolean(param[1]));
                }
                else if (param[0].equalsIgnoreCase("stationIds")) {
                    filter.setStationIds(param[1]);
                }
                else if (param[0].equalsIgnoreCase("stationExclude")) {
                    filter.setStationExclude(Boolean.parseBoolean(param[1]));
                }
                else if (param[0].equalsIgnoreCase("sortBy")) {
                    filter.setSortType(getSort(param[1]));
                }
                else if (param[0].equalsIgnoreCase("startDate")){
                    Date startDate = DateConvert.parseDate(constants.dateFormat(), param[1]);
                    filter.setStartDate(startDate);
                }
                else if (param[0].equalsIgnoreCase("time")) {
                    filter.setTime(param[1]);
                }
                else if (param[0].equalsIgnoreCase("timeKey")) {
                    filter.setTimeKey(param[1]);
                }
            }
        }

        startDateInMilliSeconds = DateConvert.constructDateInMilliSeconds(filter.getStartDate(), filter.getTime());
        if (startDateInMilliSeconds != 0){
            filter.setStartDateInMilliSeconds(startDateInMilliSeconds);

            endDateInMilliSeconds = filter.getEndDateFromStartDate(startDateInMilliSeconds);
            filter.setEndDateInMilliSeconds(endDateInMilliSeconds);
        }

        if (filter.isParamMissing()) {
            return null;
        }
        return filter;
    }

    private PGSortPropertyEnum getSort(String sortBy) {
        if (sortBy.equalsIgnoreCase("Call Sign")) {
            return PGSortPropertyEnum.callSign;
        } else if (sortBy.equalsIgnoreCase("Channel Number")) {
            return PGSortPropertyEnum.stationId;
        } else if (sortBy.equalsIgnoreCase("Affiliation")) {
            return PGSortPropertyEnum.affiliation;
        }
        return PGSortPropertyEnum.callSign;
    }

    @Override
    public Widget getInstance() {
        return baseWidget;
    }

    @Override
    public void release(Widget widget) {
        baseWidget.clear();
    }
}
