package com.ericsson.cms.epgmgmt.client;


/**
 * The permissions used by the epgmgmt component, and verification of the current user permissions
 * 
 * @author epatanu
 */
public final class Permissions {

	/* Cannot instantiate */
	private Permissions() {
	}

	/**
	 * View permission for a epgmgmt
	 */
	public static final String EPG_VIEW = "EPGManager_View";

	/**
	 * Create permission for a epgmgmt
	 */
	public static final String EPG_CREATE = "EPGManager_Create";

	/**
	 * Modify permission for a epgmgmt
	 */
	public static final String EPG_MODIFY = "EPGManager_Modify";

	/**
	 * Delete permission for a epgmgmt
	 */
	public static final String EPG_DELETE = "EPGManager_Delete";

    /**
     * Plugin manager permission for a epgmgmt
     */
	public static final String EPG_PLUGIN_MGMT = "EPGManager_Plugin";
	

}
