package com.ericsson.cms.epgmgmt.client;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UIPluginProperty;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGPluginManagerService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGPluginManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.gwtext.client.widgets.form.Hidden;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.MultiTaskBusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class PluginPropertiesForm extends Composite{

    private static final String STYLE_HEAD = "epg-channels-properties-head";
    private static final String STYLE_BODY = "epg-channels-properties-body";
    private static final String STYLE_TEXTBOX = "epg-properties-text-textbox";
    private static final String STYLE_TEXTBOX_FIELD = "epg-properties-fields-textbox";
    private static final String UI_LABEL_ELLIPSIS = "epg-programguide-ellipsis-text";
    private FlexTableContainer table ;
    private final VerticalContainer mainPanel;
    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    private final IEPGPluginManagerServiceAsync pluginManagerService = GWT.create( IEPGPluginManagerService.class );
    private final EPGComponentConstants providerConstants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    private final MultiTaskBusyIndicator busyIndicator = new MultiTaskBusyIndicator();
    private Long formatID=0L;
    private long propertiesSize=0L;
    public PluginPropertiesForm() {
        mainPanel = new VerticalContainer();
        mainPanel.clear();
        propertiesSize=0L;
        initWidget(mainPanel);
    }

    public void setPluginProperties(Long formatid){
        getPluginRecords(formatid);
    }

    public void setPluginPropertiesForUpdate(List<UIPluginProperty> pluginPropertyValues ){
        initializeProperties( pluginPropertyValues) ;
    }

    public void initializeProperties(List<UIPluginProperty> props) {
        mainPanel.clear();
        this.propertiesSize=0L;
        table = new FlexTableContainer();
        table.removeAllRows();
        this.propertiesSize = props.size();
        if (props.size() > 0) {
            table.setWidget(0, 0, new LabelWidget(constants.pluginFieldName()));
            table.setWidget(0, 1, new LabelWidget(constants.pluginFieldValue()));
            table.setWidget(0, 2, new LabelWidget(constants.pluginUseDefaultDisplayMsg()));
            table.setWidget(0, 3, new Hidden());
            table.setWidget(0, 4, new Hidden());
            table.setWidget(0, 5, new Hidden());
            table.setWidget(0, 6, new Hidden());
            table.getRowFormatter().addStyleName(0, STYLE_HEAD);
            for(UIPluginProperty p : props){
                addPluginProperty(p);
            }
        }
        mainPanel.add(table);
    }

    public long getPropertiesSize() {
        return this.propertiesSize;
    }

    private void addPluginProperty(final UIPluginProperty pp) {

        int rowIndex = table.getRowCount();

        String tip = "";
        if ((pp.getUiToolTip() != null) && !pp.getUiToolTip().isEmpty()) {
            tip = pp.getUiToolTip().trim();
        }
        table.getRowFormatter().addStyleName(rowIndex, STYLE_BODY);
        LabelWidget uiPropertyNameWidget = new LabelWidget(pp.getPropertyName());
        uiPropertyNameWidget.setWordWrap(false);
        uiPropertyNameWidget.addStyleDependentName(UI_LABEL_ELLIPSIS);
        uiPropertyNameWidget.addStyleName(STYLE_TEXTBOX_FIELD);
        uiPropertyNameWidget.setTitle(pp.getPropertyName());
        table.setWidget(rowIndex, 0, uiPropertyNameWidget);
        final TextBoxWidget actualValueWidget = new TextBoxWidget(pp.getPropertyValue());
        actualValueWidget.setMaxLength(255);
        actualValueWidget.addStyleName(STYLE_TEXTBOX);
        actualValueWidget.setTitle(tip);
        ButtonWidget defaultButton= new ButtonWidget("  "+constants.buttonLabelDefault());
        defaultButton.addStyleDependentName("commit-button");
        defaultButton.setTitle(constants.pluginDefaultMsg());
        Hidden defaultHiddenValue =  new Hidden();
        defaultHiddenValue.setValue(pp.getPropertyDefaultValue());
        Hidden propertyNameHiddenValue =  new Hidden();
        propertyNameHiddenValue.setValue(pp.getPropertyName());
        Hidden uiTooltipHiddenValue =  new Hidden();
        uiTooltipHiddenValue.setValue(tip);
        defaultButton.addClickHandler(new ClickHandler(){
            @Override
            public void onClick(ClickEvent event) {
                actualValueWidget.setText(pp.getPropertyDefaultValue());
            }
        });
        Hidden id = new Hidden("pluginPropertyValueId", String.valueOf(pp.getId()));
        table.setWidget(rowIndex, 1, actualValueWidget);
        table.setWidget(rowIndex, 2, defaultButton);
        table.setWidget(rowIndex, 3, defaultHiddenValue);
        table.setWidget(rowIndex, 4, propertyNameHiddenValue);
        table.setWidget(rowIndex, 5, uiTooltipHiddenValue);
        table.setWidget(rowIndex, 6, id);
    }

    public List<UIPluginProperty> setPluginPropertiesForm() {
        List<UIPluginProperty> properties = new ArrayList<UIPluginProperty>();
        if (table != null) {
            for (int i = 1; i < table.getRowCount(); ++i) {
                UIPluginProperty pp = new UIPluginProperty();
                pp.setId(getId(i));
                pp.setPropertyName(getFieldName(i));
                pp.setPropertyValue(getConfigValue(i));
                pp.setPropertyDefaultValue(getConfigDefaultValue(i));
                pp.setUiLabel(getUIPropertyName(i));
                pp.setUiToolTip(getToolTipValue(i));
                properties.add(pp);
            }
        }
        return properties;
    }

    private long getId(int row) {
        long id = 0L;
        Hidden nameWidget = (Hidden) table.getWidget(row, 6);
        String idStr = nameWidget.getValueAsString();
        if (idStr != null) {
            id = Long.parseLong(idStr.trim());
        }
        return id;
    }

    private String getFieldName(int rowIndex) {

        LabelWidget nameWidget = (LabelWidget) table.getWidget(rowIndex,0);
        String name = nameWidget.getText();
        if(name != null) {
            name = name.trim();
        }
        return name;
    }

    private String getUIPropertyName(int rowIndex) {
        Hidden propertyNameWidget = (Hidden) table.getWidget(rowIndex, 4);
        String value = propertyNameWidget.getValueAsString();
        if(value != null) {
            value = value.trim();
        }
        return value;
    }

    private String getConfigValue(int rowIndex) {
        TextBoxWidget valueWidget = (TextBoxWidget) table.getWidget(rowIndex, 1);
        String value = valueWidget.getText();
        if(value != null) {
            value = value.trim();
        }
        return value;
    }

    private String getConfigDefaultValue(int rowIndex) {
        Hidden defaultvalueWidget = (Hidden) table.getWidget(rowIndex, 3);
        String value = defaultvalueWidget.getValueAsString();
        if(value != null) {
            value = value.trim();
        }
        return value;
    }

    private String getToolTipValue(int rowIndex) {
        Hidden toolTipValueWidget = (Hidden) table.getWidget(rowIndex, 5);
        String value = toolTipValueWidget.getValueAsString();
        if(value != null) {
            value = value.trim();
        }
        return value;
    }

    public void getPluginRecords(Long formatid) {

        mainPanel.clear();


        if((formatid != 0) && (formatid !=null)){
            busyIndicator.center();

            pluginManagerService.getPluginProperties(formatid ,new NeptuneAsyncCallback<List<UIPluginProperty>>(){
                @Override
                public void onNeptuneFailure( Throwable caught ) {

                    Window.alert(providerConstants.loadingError() + " | " + providerConstants.reason() + ": " + (caught != null ? caught.getLocalizedMessage() : ""));
                    busyIndicator.hide();
                }
                @Override
                public void onNeptuneSuccess(List<UIPluginProperty> result) {

                    initializeProperties(result);
                    busyIndicator.hide();
                }
            } );
        }
    }

    public Long getFormatID() {
        return formatID;
    }

    public void setFormatID(Long formatID) {
        this.formatID = formatID;
    }
}
