package com.ericsson.cms.epgmgmt.client;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * Widget used to display success messages for the contract manager module.
 * 
 * @author Daniel Paranhos
 * 
 */
public class SuccessPanel extends SimpleContainer {

    private final VerticalContainer mainContainer;
    private final VerticalContainer messageContainer;
    private static final String SUCCESS_MESSAGE_STYLE1 = "contract-success-message-1";
    private static final String SUCCESS_MESSAGE_STYLE2 = "contract-success-message-2";

    public SuccessPanel() {
        super();
        mainContainer = new VerticalContainer();
        messageContainer = new VerticalContainer();
        mainContainer.add(messageContainer);
        add(mainContainer);
    }

    private LabelWidget createMessageLabel(String message) {
        LabelWidget messageLabel = new LabelWidget();

        messageLabel.setText(message);
        messageLabel.addStyleName(SUCCESS_MESSAGE_STYLE1);
        messageLabel.addStyleName(SUCCESS_MESSAGE_STYLE2);
        messageLabel.setWordWrap(true);

        return messageLabel;
    }

    /**
     * Sets the message text with the given value.
     * 
     * @param message
     */
    public void showMessage(String message) {
        messageContainer.clear();
        if ( message != null && !message.trim().equals( "" ) ) {
            messageContainer.add( createMessageLabel( message ) );
        }
    }

    /**
     * Adds the message text with the given value.
     * 
     * @param message
     */
    public void addMessage(String message) {
        messageContainer.add( createMessageLabel( message ) );
    }

    /**
     * Clears the text in all contained widgets.
     * 
     */
    public void reset() {
        messageContainer.clear();
    }
}
