package com.ericsson.cms.epgmgmt.client.alarmactivitylog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.ActivityLogResult;
import com.ericsson.cms.epgmgmt.client.model.UIActivityLog;
import com.ericsson.cms.epgmgmt.client.model.UIActivityLogRecord;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGActivityLogService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGActivityLogServiceAsync;
import com.ericsson.cms.epgmgmt.client.utils.DateConvert;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class ActivityLogDataProvider implements DataProvider<Long, UIActivityLogRecord> {

    //Filter
    private UIActivityLog uiActivityLog;

    // columns for this table
    private final List<Column<?, UIActivityLogRecord>> columns;
    private final ColumnBase<String, UIActivityLogRecord> dateColumn;
    private final ColumnBase<String, UIActivityLogRecord> severityColumn;
    private final ColumnBase<String, UIActivityLogRecord> componentColumn;
    private final ColumnBase<String, UIActivityLogRecord> descriptionColumn;

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);

    private IBusyNotifier busyNotifier;

    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, UIActivityLogRecord> parentSortFeature;

    private final IEPGActivityLogServiceAsync activityLogService = GWT.create(IEPGActivityLogService.class);

    // column names
    private static final String DATE_COLUMN = "activityDate";
    private static final String SEVERITY_COLUMN = "severity";
    private static final String COMPONENT_COLUMN = "component";
    private static final String DESCRIPTION_COLUMN = "description";
    private static final String PARTNER_COLUMN = "partner";

    public ActivityLogDataProvider(ActivityLogDetailView aalView, boolean hidePartner){
        columns = new ArrayList<Column<?, UIActivityLogRecord>>();
        //Activity Date
        dateColumn = new ColumnBase<String, UIActivityLogRecord>(DATE_COLUMN, constants.activityLogCreateDate()){
            @Override
            public View<String> getView(UIActivityLogRecord record){
                Date activityDate = new Date(record.getUiActivityLog().getActivityDate());
                return new LabelStringView(DateConvert.formatDate(constants.activityLogTimeFormat(), activityDate));
            }
        };
        dateColumn.setCellStyle(TableConstants.STYLE_DATACELL_DATE);
        columns.add(dateColumn);
        
        if(hidePartner) {
            //Partner
            ColumnBase<String, UIActivityLogRecord> sourceColumn = new ColumnBase<String, UIActivityLogRecord>(PARTNER_COLUMN, constants.activityLogPartnerLabel()) {
                @Override
                public View<String> getView(UIActivityLogRecord record){
                    return new LabelStringView(String.valueOf(record.getUiActivityLog().getPartnerName()));
                }
            };
            sourceColumn.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
            columns.add(sourceColumn);
        }

        //severity
        severityColumn = new ColumnBase<String, UIActivityLogRecord>(SEVERITY_COLUMN, constants.activityLogSeverityLabel()){
            @Override
            public View<String> getView(UIActivityLogRecord record){
                return new LabelStringView(String.valueOf(record.getUiActivityLog().getSeverity()));
            }
        };
        severityColumn.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
        columns.add(severityColumn);
        //Component
        componentColumn = new ColumnBase<String, UIActivityLogRecord>(COMPONENT_COLUMN, constants.activityLogComponentLabel()){
            @Override
            public View<String> getView(UIActivityLogRecord record){
                return new LabelStringView(String.valueOf(record.getUiActivityLog().getComponent()));
            }
        };
        componentColumn.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
        columns.add(componentColumn);
       
        //Description
        descriptionColumn = new ColumnBase<String, UIActivityLogRecord>(DESCRIPTION_COLUMN, constants.activityLogDescriptionLabel()){
            @Override
            public View<String> getView(UIActivityLogRecord record){
                return new LabelStringView(String.valueOf(record.getUiActivityLog().getDescription()));
            }
        };
        descriptionColumn.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
        columns.add(descriptionColumn);
        
    }

    public ColumnBase<String, UIActivityLogRecord> getDefaultSortColumn() {
        return dateColumn;
    }

    public List<Column<?, UIActivityLogRecord>> getSortColumns() {
        return columns;
    }

    @Override
    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess( null );
    }

    @Override
    public List<Column<?, UIActivityLogRecord>> getColumns() {
        return columns;
    }

    @Override
    public void getRecord(Long key, final AsyncCallback<UIActivityLogRecord> callback) {
    }

    @Override
    public void getRecords(final AsyncCallback<List<UIActivityLogRecord>> callback) {
        int length = getParentPageFeature().getPageSize();
        int pageNumber = getParentPageFeature().getPageNumber();
        notifyBusyStart();


        activityLogService.findActivityLogByFilter(pageNumber, length,getParentSortFeature().getSortColumnName(),
                getParentSortFeature().isAscending(), uiActivityLog, new NeptuneAsyncCallback<ActivityLogResult>() {

            @Override
            public void onNeptuneFailure(Throwable caught) {
                getParentPageFeature().setRecordCount(-1);
                callback.onFailure(caught);
                notifyBusyFinish();
            }

            @Override
            public void onNeptuneSuccess(ActivityLogResult result ) {
                getParentPageFeature().setRecordCount(result.getTotalCount());
                List<UIActivityLogRecord> uiActivityLogRecords = new ArrayList<UIActivityLogRecord>();
                for (UIActivityLog activityLog : result.getActivityLog()) {
                    uiActivityLogRecords.add(new UIActivityLogRecord(activityLog));
                }
                callback.onSuccess(uiActivityLogRecords);
                notifyBusyFinish();
            }

        } );
    }


    @Override
    public boolean isRecordCountEnabled() {
        return true;
    }

    @Override
    public boolean isCheckboxEnabled() {
        return false;
    }

    public PageFeature getParentPageFeature() {
        return parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    public SortFeatureImpl<Long, UIActivityLogRecord> getParentSortFeature() {
        return parentSortFeature;
    }

    public void setParentSortFeature(
            SortFeatureImpl<Long, UIActivityLogRecord> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }

    public void setActivityLogFilter(UIActivityLog uiActivityLog){
        this.uiActivityLog = uiActivityLog;
    }

    public static interface IBusyNotifier {
        void startingToBeBusy();

        void doneBeingBusy();
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    private void notifyBusyStart() {
        if (busyNotifier != null) {
            busyNotifier.startingToBeBusy();
        }
    }

    private void notifyBusyFinish() {
        if (busyNotifier != null) {
            busyNotifier.doneBeingBusy();
        }
    }

}
