package com.ericsson.cms.epgmgmt.client.alarmactivitylog;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UIActivityLog;
import com.ericsson.cms.epgmgmt.client.model.UIActivityLogRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class ActivityLogDetailView extends Composite {


    private static final String BUTTON_PANEL_STYLE = "epg-tabContainer-buttonPanel";
    private static final String STYLE_NAME = "content-AlarmActivityLog";
    private static final String TAB_CONTAINER_STYLE = "epg-tabContainer";
    private static final String REFRESH_CHECKBOX_STYPE = "epg-refreshCheckBox";
    private static final int HEADER_MENU_SIZE_PX = 115;
    private static final int DEFAULT_PAGE_SIZE = 25; // NOSONAR
    private static final int DEFAULT_REFRESH_INTERVAL = 15000; // NOSONAR
    private final Long[] intervalValue = new Long[] { 15L, 30L, 60L };

    // widgets used in this view
    private final HorizontalContainer buttonPanel = new HorizontalContainer();
    private final ScrollContainer tableContainer = new ScrollContainer();
    private final CheckBoxWidget refreshCheck = new CheckBoxWidget("AutoRefresh");
    private Timer refreshTimer;

    private HeaderPanel header;
    private final VerticalContainer mainContainer = new VerticalContainer();
    private final TabContainer tabContainer = new TabContainer();
    private final MessageArea messageArea = new MessageArea();
    private final TypedListBoxWidget<Long> refreshInterval = new TypedListBoxWidget<Long>(new IntegerConverter());

    private Table<Long, UIActivityLogRecord> table;

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);

    public ActivityLogDetailView(UIActivityLog uiActivityLog){

        if (!ClientAuthorizationManager.isAuthorized(Permissions.EPG_VIEW)) {
            Window.alert("You do not have permissions to view this page...");
            return;
        }

        boolean hidePartnerName = uiActivityLog.getSourceType().equalsIgnoreCase("ALL") && uiActivityLog.getSourceId() <= 0;

        mainContainer.setStylePrimaryName(STYLE_NAME);
        header = new HeaderPanel(constants.activityLog());
        mainContainer.add(header);

        messageArea.reset();
        mainContainer.add(messageArea);

        //tab
        tabContainer.addStyleName(TAB_CONTAINER_STYLE);
        mainContainer.add(tabContainer);

        ActivityLogDataProvider dataProvider = new ActivityLogDataProvider(this, hidePartnerName);
        dataProvider.setActivityLogFilter(uiActivityLog);

        table = new Table<Long, UIActivityLogRecord>(dataProvider);
        table.addTableViewChangeHandler(new TableViewChangeHandler<Long, UIActivityLogRecord>(){
            @Override
            public void onShowDetailView(TableDetailViewEvent<Long, UIActivityLogRecord> event){
            }

            @Override
            public void onShowListView(TableViewEvent event){
                header.setLabel(constants.activityLog());
            }
        });

        PageFeatureImpl pageFeature = new PageFeatureImpl();
        pageFeature.setPageSize(DEFAULT_PAGE_SIZE);
        dataProvider.setParentPageFeature(pageFeature);

        SortFeatureImpl<Long, UIActivityLogRecord> sortFeature = new SortFeatureImpl<Long, UIActivityLogRecord>(
                dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING );
        for (Column<?, UIActivityLogRecord> col : dataProvider.getSortColumns()){
            sortFeature.addSortableColumn(col);
        }
        dataProvider.setParentSortFeature(sortFeature);

        BookmarkFeatureImpl bookmarkFeature = new BookmarkFeatureImpl();

        table.addSortFeature(sortFeature);
        table.addPageFeature(pageFeature);
        table.addBookmarkFeature(bookmarkFeature);

        table.initialize(new NeptuneAsyncCallback<Void>(){
            @Override
            public void onNeptuneFailure(Throwable caught){
            }

            @Override
            public void onNeptuneSuccess(Void result){
            }
        } );

        tableContainer.setWidget(table);
        tabContainer.add(tableContainer, constants.activityLogSearchResultsTab());
        tabContainer.selectTab(0);

        createButtonPanel();
        initWidget(mainContainer);
        refreshTable();
        Scheduler.get().scheduleDeferred(new ScheduledCommand() {
            @Override
            public void execute() {
                updateTableContainerSize();
            }
        });
    }

    private void createButtonPanel() {
        buttonPanel.setStyleName(BUTTON_PANEL_STYLE);
        buttonPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        // cancel button
        ButtonWidget cancelButton = new ButtonWidget(constants.buttonLabelCancel());
        cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
        cancelButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                History.newItem("EPGManager.ActivityLog");
            }
        });
        buttonPanel.add(cancelButton);

        addSpace(buttonPanel, "5");

        ButtonWidget refreshButton = new ButtonWidget(constants.buttonLabelRefresh());
        refreshButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);
        refreshButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                refreshTable();
            }
        });

        buttonPanel.add(refreshButton);

        addSpace(buttonPanel, "10");
        refreshTimer = setupRefreshTimer();

        refreshCheck.setValue(false);
        refreshCheck.addStyleName(REFRESH_CHECKBOX_STYPE);
        setupRefreshInterval();
        refreshCheck.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                if (refreshCheck.getValue()) {
                    int interval = refreshInterval.getValue().intValue();
                    if (interval < intervalValue[0] || interval > intervalValue[2]) {
                        refreshTimer.scheduleRepeating(DEFAULT_REFRESH_INTERVAL);
                    }else {
                        refreshTimer.scheduleRepeating(interval * DEFAULT_REFRESH_INTERVAL
                                / intervalValue[0].intValue());
                    }
                    refreshTimer.run();
                } else {
                    if (refreshTimer != null) {
                        refreshTimer.cancel();
                    }
                }
            }
        });

        buttonPanel.add(refreshCheck);
        addSpace(buttonPanel, "5");

        LabelWidget byLabel = new LabelWidget("by");
        buttonPanel.add(byLabel);
        addSpace(buttonPanel, "5");

        buttonPanel.add(refreshInterval);
        mainContainer.add(buttonPanel);
    }

    private void updateTableContainerSize() {
        int height = Window.getClientHeight() - HEADER_MENU_SIZE_PX
                - header.getOffsetHeight()
                - messageArea.getOffsetHeight()
                - tabContainer.getTabBar().getOffsetHeight()
                - buttonPanel.getOffsetHeight() - 14;
        /* adjustment for borders and spacing at the bottom */
        tableContainer.setHeight(height + "px");
    }

    private void refreshTable() {
        if (!this.table.isInitialized()) {
            this.table.initialize(new NeptuneAsyncCallback<Void>() {
                @Override
                public void onNeptuneFailure(Throwable caught) {
                    Window.alert("get initialize table failed!! \n " + caught);
                }

                @Override
                public void onNeptuneSuccess(Void result) {
                    table.refresh();
                }
            });
        } else {
            this.table.refresh();
        }
    }

    private void addSpace(HorizontalContainer container, String width) {
        if (container != null) {
            HorizontalPanel space = new HorizontalPanel();
            LabelWidget label = new LabelWidget();
            space.add(label);
            space.setCellWidth(label, width);
            container.add(space);
        }
    }

    private Timer setupRefreshTimer() {
        Timer t = new Timer() {
            @Override
            public void run() {
                refreshTable();
            }
        };

        t.cancel();
        return t;
    }

    private void setupRefreshInterval() {
        refreshInterval.clear();

        for (int i = 0; i < intervalValue.length; i++) {
            refreshInterval.addItem(intervalValue[i].intValue() + "s", intervalValue[i]);
        }

        refreshInterval.setSelectedItem(intervalValue[0]);

        refreshInterval.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                if (refreshCheck.getValue()) {
                    int interval = refreshInterval.getValue().intValue();
                    if (interval < intervalValue[0] || interval > intervalValue[2]) {
                        refreshTimer.scheduleRepeating(DEFAULT_REFRESH_INTERVAL);
                    } else {
                        refreshTimer.scheduleRepeating(interval * DEFAULT_REFRESH_INTERVAL
                                / intervalValue[0].intValue());
                    }
                }
            }
        });
    }
}
