package com.ericsson.cms.epgmgmt.client.alarmactivitylog;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.EPGFormContainer;
import com.ericsson.cms.epgmgmt.client.ErrorPanel;
import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.SuccessPanel;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.enumeration.LogSourceTypeEnum;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PluginLogComponentEnum;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PluginLogSeverityEnum;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGActivityLogService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGActivityLogServiceAsync;
import com.ericsson.cms.epgmgmt.client.utils.DefaultAsyncCallback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class ActivityLogFilterView extends Composite {

    private final TypedListBoxWidget<String> severityListBox;
    private final TypedListBoxWidget<String> componentListBox;
    private final TypedListBoxWidget<String> sourceTypeListBox;
    private final TypedListBoxWidget<Long> partnerListBox;
    private final TypedDateBoxWidget startDate;
    private final TypedDateBoxWidget endDate;
    private final ButtonWidget searchButton;

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    private final IEPGActivityLogServiceAsync activityLogService = GWT.create(IEPGActivityLogService.class);

    private static final String STYLE_NAME = "content-AlarmActivityLog";
    private static final String TAB_CONTAINER_STYLE = "epg-tabContainer";

    private final EPGFormContainer filterContainer;
    private final HeaderPanel header;
    private final VerticalContainer mainContainer = new VerticalContainer();
    private final TabContainer tabContainer = new TabContainer();

    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    private final HorizontalContainer partnerPanel = new HorizontalContainer();
    private final List<UIPartner> providers= new LinkedList<UIPartner>();
    private final List<UIPartner> publishers = new LinkedList<UIPartner>();
    private final List<UIPartner> partners = new LinkedList<UIPartner>();

    public ActivityLogFilterView(){

        mainContainer.setStylePrimaryName(STYLE_NAME);
        mainContainer.add(successPanel);
        mainContainer.add(errorPanel);

        header = new HeaderPanel(constants.activityLog());
        mainContainer.add(header);

        filterContainer = new EPGFormContainer(HorizontalContainer.ALIGN_LEFT);
        severityListBox = new TypedListBoxWidget<String>(new StringConverter());
        fillSeverityListBox(severityListBox);
        componentListBox = new TypedListBoxWidget<String>(new StringConverter());
        fillComponentListBox(componentListBox);
        sourceTypeListBox = new TypedListBoxWidget<String>(new StringConverter());
        fillSourceTypeListBox(sourceTypeListBox);
        partnerListBox = new TypedListBoxWidget<Long>(new IntegerConverter());
        fillSourceListBox();

        sourceTypeListBox.addValueChangeHandler(new ValueChangeHandler<String>() {

            @Override
            public void onValueChange(ValueChangeEvent<String> event) {
                if(LogSourceTypeEnum.getEnumByValue(Integer.parseInt(sourceTypeListBox.getSelectedItem())) == LogSourceTypeEnum.PROVIDER) {
                    fillProviderListBox();
                } else if(LogSourceTypeEnum.getEnumByValue(Integer.parseInt(sourceTypeListBox.getSelectedItem())) == LogSourceTypeEnum.PUBLISHER){
                    fillPublisherListBox();
                } else {
                    fillSourceListBox();
                }
            }
        });

        startDate = new TypedDateBoxWidget(new DateConverter(constants.activityLogDateFormat(), constants.activityLogDateFormat()));
        setDefaultDate(startDate);
        endDate = new TypedDateBoxWidget(new DateConverter(constants.activityLogDateFormat(), constants.activityLogDateFormat()));
        setDefaultDate(endDate);

        partnerPanel.add(sourceTypeListBox);
        addSpace(partnerPanel, "10");
        partnerPanel.add(partnerListBox);


        filterContainer.addRow(constants.activityLogSeverityLabel(), severityListBox);
        filterContainer.addRow(constants.activityLogComponentLabel(), componentListBox );
        filterContainer.addRow(constants.activityLogSourceTypeLabel(), partnerPanel);
        filterContainer.addRow(constants.activityLogStartDateLabel(), startDate);
        filterContainer.addRow(constants.activityLogEndDateLabel(), endDate);

        searchButton = new ButtonWidget(constants.activityLogShowActivityLog());
        searchButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);
        searchButton.addClickHandler(new ClickHandler(){

            @Override
            public void onClick(ClickEvent event) {
                if (validate()) {
                    String urlQuery = commit();
                    History.newItem("EPGManager.ActivityLog.ActivityLogFilter.Result?" + urlQuery);
                }
            }

        });
        filterContainer.addButton(searchButton);

        //tab
        tabContainer.addStyleName(TAB_CONTAINER_STYLE);
        mainContainer.add(tabContainer);

        VerticalContainer tabPanel = new VerticalContainer();
        tabContainer.add(tabPanel, constants.activityLogSearchTab());
        tabContainer.selectTab(0);

        tabPanel.add(filterContainer);

        verifyPermissions();
        initWidget(mainContainer);
    }

    private void addSpace(HorizontalContainer container, String width) {
        if (container != null) {
            HorizontalPanel space = new HorizontalPanel();
            LabelWidget label = new LabelWidget();
            space.add(label);
            space.setCellWidth(label, width);
            container.add(space);
        }
    }


    private void fillSeverityListBox(TypedListBoxWidget<String> severityListBox) {
        for(PluginLogSeverityEnum severity : PluginLogSeverityEnum.values()) {
            severityListBox.addItem(severity.toString(), Integer.toString(severity.getValue()));
        }
    }

    private void fillComponentListBox(TypedListBoxWidget<String> componentListBox) {
        for(PluginLogComponentEnum component : PluginLogComponentEnum.values()) {
            componentListBox.addItem(component.toString(), Integer.toString(component.getValue()));
        }
    }

    private void fillSourceTypeListBox(TypedListBoxWidget<String> sourceTypeListBox) {
        for(LogSourceTypeEnum sourceType : LogSourceTypeEnum.values()) {
            sourceTypeListBox.addItem(sourceType.toString(), Integer.toString(sourceType.getValue()));
        }
        sourceTypeListBox.setSelectedIndex(0);
    }

    private void fillSourceListBox() {
        if(partners.isEmpty()){
            activityLogService.getAllPartner(new FillPartnerHandler(partners));
        }else{
            fillPartnerListBox(partners);
        }
    }

    private void fillPublisherListBox() {
        if(publishers.isEmpty()){
            activityLogService.getPublishers(new FillPartnerHandler(publishers));
        }else{
            fillPartnerListBox(publishers);
        }
    }

    private void fillProviderListBox() {
        if(publishers.isEmpty()){
            activityLogService.getProviders(new FillPartnerHandler(providers));
        }else{
            fillPartnerListBox(providers);
        }
    }

    private void fillPartnerListBox(List<UIPartner> partnerList) {
        // currently, publisher filter is single, default select no provider filter
        partnerListBox.clear();
        partnerListBox.addItem("", -1L);
        if (partnerList != null && partnerList.size() > 0) {
            for (UIPartner p : partnerList) {
                partnerListBox.addItem(p.getName(), p.getId());
            }
        }
    }
    private void setDefaultDate(TypedDateBoxWidget date) {
        Date today = new Date();
        String dateString = DateTimeFormat.getFormat(constants.activityLogDateFormat()).format(today);
        date.setTextValue(dateString);
    }

    private boolean validate(){
        Date stDate = startDate.getDatePicker().getValue();
        Date edDate = endDate.getDatePicker().getValue();

        errorPanel.reset();
        boolean valid = true;

        if (stDate != null && edDate != null && !(edDate.after(stDate) || edDate.equals(stDate))) {
            valid = false;
            startDate.showValidationError(constants.activityLogDateValidation());
            errorPanel.addHeading1(constants.activityLogDateValidation());
        }

        return valid;
    }

    private String commit(){
        StringBuilder urlQuery = new StringBuilder();
        checkDates();
        urlQuery.append("severity=").append(severityListBox.getSelectedItem());
        urlQuery.append("&component=").append(componentListBox.getSelectedItem());
        urlQuery.append("&sourceType=").append(sourceTypeListBox.getSelectedItem());
        urlQuery.append("&partner=").append(partnerListBox.getSelectedItem());
        urlQuery.append("&startDate=").append(startDate.getTextValue());
        urlQuery.append("&endDate=").append(endDate.getTextValue());
        return urlQuery.toString();
    }

    private void checkDates(){
        if(startDate.getTextValue().trim().isEmpty()){
            startDate.getDatePicker().setValue(null);
        }
        if(endDate.getTextValue().trim().isEmpty()){
            endDate.getDatePicker().setValue(null);
        }
    }

    private void verifyPermissions(){
        if (!ClientAuthorizationManager.isAuthorized(Permissions.EPG_VIEW)) {
            searchButton.setEnabled(false);
        }
    }
    private final class FillPartnerHandler extends DefaultAsyncCallback<List<UIPartner>> {
        private final List<UIPartner> partners;

        private FillPartnerHandler(List<UIPartner> partners) {
            super(null);
            this.partners = partners;
        }

        @Override
        public void onNeptuneSuccess(List<UIPartner> partnerList) {
            partners.clear();
            partners.addAll(partnerList);
            fillPartnerListBox(partnerList);
        }
    }
}
