package com.ericsson.cms.epgmgmt.client.alarmactivitylog;

import java.util.Map;

import com.ericsson.cms.epgmgmt.client.ErrorPanel;
import com.ericsson.cms.epgmgmt.client.SuccessPanel;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class ActivityLogViewPanel extends Composite implements AnchorChangeListener{
	
	private static final String STYLE_NAME = "content-AlarmActivityLog";
	private static final int SPACING = 5;
	private EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
	
	private HeaderPanel header;
	private VerticalContainer mainContainer;
	
	private ActivityLogFilterView activityLogFilterView;
	
	private final SuccessPanel successPanel = new SuccessPanel();
	private final ErrorPanel errorPanel = new ErrorPanel();
	
	public ActivityLogViewPanel(NeptuneSecurity security, Map<String, String> info) {

		mainContainer = new VerticalContainer();
		mainContainer.setStylePrimaryName(STYLE_NAME);
		mainContainer.add(successPanel);
		mainContainer.add(errorPanel);

		init();
		initWidget(mainContainer);

	}
	
	private void init() {		
		header = new HeaderPanel(constants.activityLog());		
		mainContainer.add(header);	
		mainContainer.setSpacing(SPACING);	
		
		activityLogFilterView = new ActivityLogFilterView();
		mainContainer.add(activityLogFilterView);
	}

	@Override
	public void anchorChanged(String anchor) {
		// TODO Auto-generated method stub
		
	}
	
}
