package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleMessages;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.ParamType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.RhsType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorLimited;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.TitleFilterOperator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterComplexValue;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterConditionNode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterRHSFieldNode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;



/**
 * 
 * @author rchu
 * 
 */
public class CriteriaListingPanel extends SimplePanel implements
Validatable {
    public static final String CRITERIA_PANEL_CONTAINER_STYLE = "criteria-panel-container";
    public static final String CRITERIA_PANEL_STYLE = "criteria-panel";

    private final VerticalPanel container = new VerticalPanel();
    protected BaseOperator operatorProvider; // NOSONAR
    protected int maxLevels = 2; // NOSONAR
    private PredicateList uiRoot;
    private final VerticalPanel warningMessages = new VerticalPanel();
    private final Set<String> currentErrorCodes = new HashSet<String>();
    private final TitleConstants myConstants = (TitleConstants) GWT
            .create(TitleConstants.class);
    private final TitleMessages myMessages = (TitleMessages) GWT
            .create(TitleMessages.class);
    private UiCriteriaMode criteriaMode;

    protected CriteriaListingPanel(UiCriteriaMode critMode) {
        criteriaMode = critMode;
        setWidget(container);
    }

    public CriteriaListingPanel(UiCriteriaMode critMode, IUITitleFilterNode rule, BaseOperator searchOperatorType) {
        this(critMode);
        this.operatorProvider = searchOperatorType;
        getContainer().add(warningMessages);
        initializeTree(rule);
    }

    public void setFilter(IUITitleFilterNode rule) {
        if (rule != null) {
            // new sibling rows will be added to last node
            clearCriteria();
            populateUiObjects(uiRoot, (UITitleFilterListNode) rule);
        }
    }

    public void clearCriteria() {
        clearWarningMessages();
        uiRoot.clearChildPanel(false);
    }

    public void resetCriteria() {
        uiRoot.clearChildPanel(true);
        uiRoot.setOperator(TitleFilterOperator.AND);
    }

    /*
     * recursive algorithm to populate our tree crap The image setting should be
     * moved to PredicateRowNode or PredicateRow
     */
    private void populateUiObjects(PredicateList root,
            UITitleFilterListNode tree) {
        root.setOperator(tree.getUiRetOperator());


        // go through each item, add rows and recursively add lists
        for (int i = 0; i < tree.getList().size(); i++) {
            IUITitleFilterNode node = tree.getList().get(i);
            if (node instanceof UITitleFilterComplexValue) {
                //deal with eval child field
                PredicateRow child = convertUiNode(node);
                root.addChildRow(child);

                child.setAddRowButtonVisible(true);
                UITitleFilterComplexValue compValue = (UITitleFilterComplexValue) node;
                for (UITitleFilterConditionNode evalNode : compValue.getChildren()) {
                    addEvalChildNodes(child, evalNode);
                }
            } else if (node instanceof UITitleFilterConditionNode) {
                //normal predicate row
                root.addChildRow(convertUiNode(node));
            } else if (node instanceof UITitleFilterListNode) {
                //predicate list
                PredicateList list = new PredicateList(root);
                root.addChildRow(list);
                populateUiObjects(list, (UITitleFilterListNode) node);
            }


        }
    }

    /*
     * add eval child nodes to the predicate row
     */
    private void addEvalChildNodes(PredicateRow child,
            UITitleFilterConditionNode evalNode) {
        IFieldTreeObject xmlObj = child.getLhsTreeObject();
        String assetType = xmlObj.getAssetType();
        String xpath = xmlObj.getField();
        TreeItem item;
        try {
            item = TreeCreator.findItem(UIFieldType.EPG, assetType, xpath, CriteriaType.RULE_CONDITION_LHS_EPG, criteriaMode);
        } catch (UndefinedFieldException e) {
            addWarningMessage(myMessages.invalidField(assetType +" "+xpath));
            return;
        }
        PredicateRow childEvalNode = convertEvalChildNode(evalNode, item);
        child.addChildRow(childEvalNode);
    }

    private PredicateRow convertUiNode(IUITitleFilterNode node) {
        UITitleFilterConditionNode predicateNode = (UITitleFilterConditionNode) node;
        PredicateRow row = new PredicateRow(this);
        row.setPredicate(predicateNode, criteriaMode);
        return row;
    }

    private PredicateRow convertEvalChildNode(IUITitleFilterNode node,
            TreeItem item) {
        UITitleFilterValueNode predicateNode = (UITitleFilterValueNode) node;
        PredicateRow row = new PredicateRow(this, item);
        row.setPredicate(predicateNode, criteriaMode);
        return row;
    }

    protected void initializeTree(IUITitleFilterNode rule) {
        uiRoot = new PredicateList(this, maxLevels);
        if (rule != null) {
            // new sibling rows will be added to last node
            clearCriteria();
            populateUiObjects(uiRoot, (UITitleFilterListNode) rule);
        } else {
            PredicateRow defaultRow = new PredicateRow(this);
            uiRoot.addChildRow(defaultRow);
        }
        getContainer().add(uiRoot);
    }

    public PredicateList getRoot() {
        return uiRoot;
    }

    @Override
    public boolean validate() {
        clearWarningMessages();
        boolean passes = uiRoot.validate();
        if (!passes) {
            this.addWarningMessage(myConstants.ruleValidationBadCriteria());
        }
        return passes;
    }

    /**
     * determines whether a predicate row can be deleted or modified.
     * 
     * @param row
     * @return
     */
    public boolean canChangePredicateRow(PredicateRow row) {
        return true;
    }

    /**
     * Allows for the notification of a change in a predicate row.
     * 
     * @param item
     *            new Tree item with root userObject the XmlTreeObject
     *            representing the item selected in the predicate row
     * @param oldObject
     *            the old XmlTreeObject that use to be selected
     */
    public void notifyChange(TreeItem item, IFieldTreeObject oldObject) {
        // Don't care here
    }

    /**
     * Allows for the notification of a removal of a predicate row.
     * 
     * @param xmlTreeObject
     *            the old XmlTreeObject that use to be selected
     */
    public void notifyRemoval(IFieldTreeObject xmlTreeObject) {
        // Don't care here
    }

    public void addWarningMessage(String messageTxt) {
        if(currentErrorCodes.add(messageTxt)) {
            LabelWidget message = new LabelWidget(messageTxt);
            message.addStyleName("red-txt");
            this.warningMessages.add(message);
        }
    }

    public void removeWarningMessage(String msg) {
        if(currentErrorCodes.remove(currentErrorCodes)) {
            Iterator<Widget> iterator = warningMessages.iterator();
            while(iterator.hasNext()) {
                Widget w = iterator.next();
                if(w instanceof LabelWidget) {
                    LabelWidget label = (LabelWidget) w;
                    if(label.getText().equals(msg)) {
                        iterator.remove();
                        return;
                    }
                }
            }
        }
    }

    public void clearWarningMessages() {
        this.warningMessages.clear();
        currentErrorCodes.clear();
    }

    public VerticalPanel getWarningMessageBox() {
        return this.warningMessages;
    }

    public boolean containsTreeObject(IFieldTreeObject treeObject) {
        return uiRoot.contains(treeObject);
    }

    public BaseOperator getOperatorProvider() {
        return operatorProvider;
    }

    public boolean isEmpty() {
        return getRoot().isEmpty();
    }

    public VerticalPanel getContainer() {
        return container;
    }

    public UITitleFilterListNode getCriteria() {
        PredicateList row = getRoot();
        UITitleFilterListNode tree = new UITitleFilterListNode();
        populateTree(tree, row);
        return tree;
    }

    /**
     * grab each tree and populate both levels of the UI. We are only going to
     * deal with two levels right now.
     */
    public void populateTree(UITitleFilterListNode list,
            PredicateList row) {

        TitleFilterOperator op = row.getOperator();
        list.setUiRetOperator(op);

        for (PredicateRowBase predNode : row.getChildRowNodes()) {
            if (predNode instanceof PredicateRow) {
                PredicateRow validationRow = (PredicateRow) predNode;
                if (validationRow.hasContents()) {
                    UITitleFilterConditionNode valueNode = createUiPredicate(validationRow);
                    list.addItem(valueNode);
                }
            } else if (predNode instanceof PredicateList) {
                PredicateList cl = (PredicateList) predNode;
                UITitleFilterListNode childList = new UITitleFilterListNode();
                populateTree(childList, cl);
                if (!childList.isEmpty()) {
                    list.addItem(childList);
                }
            }
        }
    }

    /*
     * Creates a UI object from a predicate row to be displayed
     */
    private UITitleFilterConditionNode createUiPredicate(PredicateRow row) {
        String fieldLhs = row.getLhsTreeObject().getField();
        String dataType = null;
        if(row.getLhsTreeObject().getDataType() != null) {
            dataType = row.getLhsTreeObject().getDataType().getName();
        }
        String sectionTypeLhs = row.getLhsTreeObject().getAssetType();
        BaseOperator op = row.getOperatorList()
                .getSelectedItem();
        UIFieldType fieldTypeLhs = row.getLhsTreeObject().getFieldType();
        ParamType paramType = row.getParamType();
        boolean ignoreCase = row.isIgnoreCase();
        boolean not = row.isNot();

        UITitleFilterConditionNode condition = null;
        if (row.getRhsType().equals(RhsType.COMPLEX)) {
            List<UITitleFilterConditionNode> children = new ArrayList<UITitleFilterConditionNode>();
            for (PredicateRowBase r : row.getChildRowNodes()) {
                if (r instanceof PredicateRow) {
                    PredicateRow evalRow = (PredicateRow) r;
                    children.add(createUiPredicate(evalRow));
                }
            }
            condition = new UITitleFilterComplexValue(fieldLhs, sectionTypeLhs, op,
                    paramType, children, row.isNot(), fieldTypeLhs);
        } else if(row.getRhsType().equals(RhsType.FIELD)) {
            IFieldTreeObject rhs = row.getRhsTreeObject();
            String fieldRhs = rhs.getField();
            String sectionTypeRhs = rhs.getAssetType();
            UIFieldType fieldTypeRhs = rhs.getFieldType();
            condition = new UITitleFilterRHSFieldNode(fieldLhs, sectionTypeLhs,
                    fieldTypeLhs, op, paramType, ignoreCase, not, dataType,
                    fieldRhs, sectionTypeRhs, fieldTypeRhs);
        } else {
            List<String> value = row.getValue();
            condition = new UITitleFilterValueNode(fieldLhs, sectionTypeLhs, fieldTypeLhs, op,
                    value, paramType, ignoreCase, not, dataType);
        }
        return condition;

    }

    public CriteriaPanelType getCriteriaPanelType() {
        return CriteriaPanelType.SEARCH;
    }

    public UiCriteriaMode getCriteriaMode() {
        return criteriaMode;
    }

    public void setCriteriaMode(UiCriteriaMode critMode) {
        this.criteriaMode = critMode;
    }

    public CriteriaType getLhsCriteriaType() {
        CriteriaType critType = CriteriaType.SEARCH_CONDITION_LHS;
        if (operatorProvider instanceof RulesOperatorLimited) {
            critType = CriteriaType.RULE_CONDITION_LHS;
        }
        return critType;
    }

    public CriteriaType getRhsCriteriaType() {
        return CriteriaType.CONDITION_RHS;
    }
}
