package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;



public class CriteriaModeSelector extends HorizontalPanel implements
		HasSelectionHandlers<UiCriteriaMode> {

	private TitleConstants myConstants = (TitleConstants) GWT
			.create(TitleConstants.class);
	private ListBoxWidget<UiCriteriaMode> listBox;
	private Label label = new Label(myConstants.TitleTypeLabel());
	private TextBox lockedDisplay;
	private SimplePanel widgetContainer = new SimplePanel();

	public CriteriaModeSelector() {
		this(UiCriteriaMode.EPISODE, false);
	}

	public CriteriaModeSelector(UiCriteriaMode critMode, boolean locked) {
		if (!locked) {
			initializeListBox();
		} else {
			initializeLockedDisplay(critMode);
			setValue(critMode);
		}
		this.setVerticalAlignment(ALIGN_MIDDLE);
		add(label);
		add(widgetContainer);
	}
	
	private void initializeLockedDisplay(UiCriteriaMode critMode) {
		lockedDisplay = new TextBox();
		lockedDisplay.setValue(getLabelValue(critMode));
		lockedDisplay.setVisibleLength(8);
		lockedDisplay.setReadOnly(true);
		lockedDisplay.addStyleName("black-txt");
	}

	private void initializeListBox() {
		listBox = new ListBoxWidget<UiCriteriaMode>();
		listBox.addItem(myConstants.episode(), UiCriteriaMode.EPISODE);
		listBox.addItem(myConstants.series(), UiCriteriaMode.SERIES);
		listBox.setSelectedItem(UiCriteriaMode.EPISODE);
		listBox.addChangeHandler(new ChangeHandler() {

			@Override
			public void onChange(ChangeEvent event) {
				SelectionEvent.fire(CriteriaModeSelector.this,
						listBox.getSelectedItem());
			}
		});
		widgetContainer.setWidget(listBox);
	}

	public UiCriteriaMode getValue() {
		if(listBox != null) {
			return listBox.getSelectedItem();
		} else if(lockedDisplay.getText().equals(myConstants.episode())) {
			return UiCriteriaMode.EPISODE;
		}
		return UiCriteriaMode.SERIES;
	}

	public void setValue(UiCriteriaMode critMode) {
		if(listBox != null) {
			listBox.setSelectedItem(critMode);
		} else {
			lockedDisplay.setText(getLabelValue(critMode));
		}
	}
	
	private String getLabelValue(UiCriteriaMode critMode) {
		if(critMode.equals(UiCriteriaMode.EPISODE)) {
			return myConstants.episode();
		} else {
			return myConstants.series();
		}
	}

	public void setLocked(boolean lock) {
		if (lock) {
			initializeLockedDisplay(listBox.getSelectedItem());
			widgetContainer.setWidget(lockedDisplay);
		} else if(listBox == null) {
			initializeListBox();
			widgetContainer.setWidget(listBox);
		} else {
			widgetContainer.setWidget(listBox);
		}
	}

	@Override
	public HandlerRegistration addSelectionHandler(
			SelectionHandler<UiCriteriaMode> handler) {
		return addHandler(handler, SelectionEvent.getType());
	}
}
