package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;


public class FieldSelector extends PopupPanel implements SelectionHandler<TreeItem> {
    private static final int BOX_HEIGHT_INT = 250;

    private static Map<FieldSelectorMapKey, FieldSelector> fieldSelectorMap = new HashMap<FieldSelectorMapKey, FieldSelector>();

    private static class FieldSelectorMapKey {

        private final CriteriaType critType;
        private final UiCriteriaMode critMode;

        private FieldSelectorMapKey(CriteriaType critType, UiCriteriaMode critMode) {
            this.critType = critType;
            this.critMode = critMode;
        }

        @Override
        public int hashCode() {
            return (critMode.toString()+critType.toString()).hashCode();
        }

        @Override
        public boolean equals(Object value) {
            if(!(value instanceof FieldSelectorMapKey)) {
                return false;
            }
            FieldSelectorMapKey typedValue = (FieldSelectorMapKey) value;
            return typedValue.critMode.equals(critMode) && typedValue.critType.equals(critType);
        }
    }

    private final Tree tree = new Tree();

    private FieldSelectorHandler handler;
    private int currentPosition = 0;

    private final VerticalPanel container = new VerticalPanel();
    private final ScrollPanel scrollPanel = new ScrollPanel();
    private final Timer timer;
    private final List<HandlerRegistration> currentHackHandlers = new ArrayList<HandlerRegistration>();
    private final TreeSearcher srchBox = new TreeSearcher(tree, getSearhBoxSelectionHander());

    protected FieldSelector() {
        super(true);
        timer = new Timer() {
            @Override
            public void run() {
                scrollPanel.setScrollPosition(currentPosition);
            }
        };

        tree.addSelectionHandler(this);
        scrollPanel.setWidget(tree);
        scrollPanel.setSize("300px", "250px");
        container.add(scrollPanel);
        container.add(getControlWidget());
        // full tree view by default
        setWidget(container);
    }

    protected FieldSelector(List<TreeItem> items) {
        this();
        addItems(items);
    }

    /*
     * this is to fix that bloody hack that moves the wheel back and forth
     */
    private void addScrollHack() {
        for (HandlerRegistration r : currentHackHandlers) {
            r.removeHandler();
        }
        currentHackHandlers.clear();

        currentHackHandlers.add(tree
                .addMouseDownHandler(new MouseDownHandler() {
                    @Override
                    public void onMouseDown(MouseDownEvent event) {
                        currentPosition = scrollPanel.getScrollPosition();
                    }
                }));

        currentHackHandlers.add(tree
                .addMouseUpHandler(new MouseUpHandler() {
                    @Override
                    public void onMouseUp(MouseUpEvent event) {
                        timer.schedule(5);
                    }
                }));
    }

    private Widget getControlWidget() {
        return srchBox;
    }

    /**
     * Show the specification in tree format from the root
     * 
     * @param x
     * @param y
     * @param xmlObj
     */
    public void show(int x, int y, IFieldTreeObject treeObj, FieldSelectorHandler handler) {
        // Firstly select the item in the tree, but if no object then we don't
        // need to set the existing item
        this.setHandler(handler);
        showTree(x, y);
        addScrollHack();
        setSelectedItem(treeObj);
    }

    /**
     * Only displays a subtree. It is reconstructed everytime so we might
     * needadmin to eventually clean up our unused trees
     * 
     * @param row
     * @param opType
     * @param item
     */
    public static FieldSelector getSubTree(TreeItem subitem) {
        FieldSelector fieldSelector = new FieldSelector();
        fieldSelector.tree.addItem(subitem);
        return fieldSelector;
    }

    public static void clearCache() {
        fieldSelectorMap.clear();
    }

    public static FieldSelector getTree(CriteriaType critType, UiCriteriaMode critMode) {
        FieldSelectorMapKey key = new FieldSelectorMapKey(critType, critMode);
        if(!fieldSelectorMap.containsKey(key)) {
            fieldSelectorMap.put(key, new FieldSelector(TreeCreator.getTreeItems(critType, critMode)));
        }
        return fieldSelectorMap.get(key);
    }

    public static void initialize(CriteriaType critType, UiCriteriaMode critMode) {
        FieldSelectorMapKey key = new FieldSelectorMapKey(critType, critMode);
        if(!fieldSelectorMap.containsKey(key)) {
            fieldSelectorMap.put(key, new FieldSelector(TreeCreator.getTreeItems(critType, critMode)));
        }
    }

    public static FieldSelector getTypedTree(CriteriaType critType, UiCriteriaMode critMode, UIFieldDataType dataType) {
        return new FieldSelector(TypedTreeCreator.getTreeItems(critType, critMode, dataType, false));
    }

    private void setSelectedItem(IFieldTreeObject treeObj) {
        if (treeObj != null) {
            String assType = treeObj.getAssetType();
            String xpath = treeObj.getField();
            TreeItem item = findItem(assType, xpath, tree);
            tree.setSelectedItem(item, false);
            tree.ensureSelectedItemVisible();
            scrollPanel.ensureVisible(item);
        }
    }

    /*
     * Show the tree widget relative to the widget
     */
    private void showTree(final int x, final int y) {
        srchBox.reset();
        setPopupPositionAndShow(new PopupPanel.PositionCallback() {
            @Override
            public void setPosition(int offsetWidth, int offsetHeight) {
                int height = Window.getClientHeight();
                int yOffset = 0;
                if (y + BOX_HEIGHT_INT > height) {
                    yOffset = BOX_HEIGHT_INT;
                }
                setPopupPosition(x, y - yOffset);
            }
        });
    }

    private TreeItem findItem(String assetType, String xpath, Tree tree) {
        Iterator<TreeItem> iterator = tree.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem item = iterator.next();
            IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
            String fAssetType = findObj.getAssetType();
            String fXPath = findObj.getField();
            if (assetType.equals(fAssetType) && xpath.equals(fXPath)) {
                return item;
            }
        }
        return null;
    }

    protected void addItems(List<TreeItem> items) {
        for(TreeItem item : items) {
            tree.addItem(item);
        }
    }

    @Override
    public void onSelection(SelectionEvent<TreeItem> event) {
        // expand the selected item and mark it as selected
        TreeItem item = event.getSelectedItem();
        if (getHandler().isSelectable(item)) {
            item.setSelected(true);
            getHandler().onSelection(item);
            hide();
        }
    }

    private FieldSelectorHandler getHandler() {
        return handler;
    }

    private void setHandler(FieldSelectorHandler handler) {
        this.handler = handler;
    }

    private SelectionHandler<TreeItem> getSearhBoxSelectionHander() {
        return new SelectionHandler<TreeItem>() {

            @Override
            public void onSelection(SelectionEvent<TreeItem> event) {
                TreeItem item = event.getSelectedItem();
                if (getHandler().isSelectable(item)) {
                    tree.setSelectedItem(item, false);
                    tree.ensureSelectedItemVisible();
                    getHandler().onSelection(item);
                    scrollPanel.ensureVisible(item);
                    srchBox.setFocus();
                } else {
                    item.setSelected(false);
                }

            }
        };
    }
}
