package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.google.gwt.user.client.Window;


public class AssetFieldTreeObject implements IFieldTreeObject {
    private static Map<String, Map<String, String>> fieldOptions;

    private final UIFieldDefinition fieldDefinition;

    private String assetPath;

    private String assetTypeDisplayName;

    public static void setFieldOptions( Map<String, Map<String, String>> contentClassOptions) {
        AssetFieldTreeObject.fieldOptions = contentClassOptions;
    }

    public static Map<String, Map<String, String>> getFieldOptions() {
        return fieldOptions;
    }

    public AssetFieldTreeObject(UIFieldDefinition fieldDefinition) {
        this.fieldDefinition = fieldDefinition;
    }

    public AssetFieldTreeObject(UIFieldDefinition fieldDefinition, String assetTypeDisplayName, String assetPath) {
        this.fieldDefinition = fieldDefinition;
        this.assetTypeDisplayName = assetTypeDisplayName;
        this.assetPath = assetPath;
    }

    @Override
    public UIFieldDataType getDataType() {
        if (fieldDefinition instanceof UIComplexFieldDefinition) {
            return null;
        } else {
            return ((UISimpleFieldDefinition) fieldDefinition).getDatatype();
        }
    }

    @Override
    public String getField() {
        return fieldDefinition.getXPath();
    }

    public UIFieldDefinition getFieldDefinition() {
        return fieldDefinition;
    }

    @Override
    public String getAssetType() {
        if(assetPath != null) {
            return assetPath;
        }
        return fieldDefinition.getAssetDefinition().getPath();
    }

    @Override
    public String getFullDisplayName() {
        String assetName;
        if(assetTypeDisplayName != null) {
            assetName = assetTypeDisplayName;
        } else {
            assetName = fieldDefinition.getAssetDefinition().getDisplayName();
        }
        return  assetName+"."+ fieldDefinition.getDisplayName();
    }

    @Override
    public String getSimpleDisplayName() {
        return fieldDefinition.getDisplayName();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + (getAssetType() == null ? 0 : getAssetType().hashCode());
        result = prime * result + (getField() == null ? 0 : getField().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AssetFieldTreeObject) {
            AssetFieldTreeObject otherVal = (AssetFieldTreeObject) obj;
            boolean assetTypeEqual = otherVal.getAssetType().equals(
                    getAssetType());
            boolean xpathEqual = otherVal.getField().equals(getField());
            return assetTypeEqual && xpathEqual;
        }
        return false;
    }

    @Override
    public String toString() {
        return getAssetType() + "|" + getField();
    }

    @Override
    public UIFieldType getFieldType() {
        return UIFieldType.ASSET;
    }

    @Override
    public Collection<UIValueOption> getSuggestedValues() {
        if(fieldOptions== null) {
            Window.alert("AssetFieldOptionProvider isn't being loaded");
            return new ArrayList<UIValueOption>();
        }
        if(!fieldOptions.containsKey(getField())) {
            return null;
        }
        List<UIValueOption> uiOptions = new ArrayList<UIValueOption>();
        for(Entry<String, String> option : fieldOptions.get(getField()).entrySet()) {
            uiOptions.add(new UIValueOption(option.getValue(), option.getKey()));
        }
        return uiOptions;
    }

    @Override
    public boolean supportsActions() {
        return getDataType() != null || !getAssetType().startsWith("SERIES");
    }

    @Override
    public boolean supportsOther() {
        return true;
    }

    public boolean supportsRHSField() {
        return getDataType() != null;
    }

    @Override
    public boolean hasSuggestedValues() {
        return fieldOptions != null && fieldOptions.get(fieldDefinition.getXPath()) != null;
    }

    @Override
    public boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
        if(getField().equals("/Fields/CustomFields")) {
            return false;
        }
        if (critType.equals(CriteriaType.BASIC_METADATA)) {
            return getAssetType().startsWith("PACKAGE") && critMode.equals(UiCriteriaMode.EPISODE)
                    || getAssetType().startsWith("SERIES") && critMode.equals(UiCriteriaMode.SERIES);
        }

        if(critMode.equals(UiCriteriaMode.SERIES) && getAssetType().startsWith("PACKAGE")) {
            return false;
        }
        if (getAssetType().startsWith("SERIES")
                && critMode.equals(UiCriteriaMode.EPISODE)
                && critType.equals(CriteriaType.SEARCH_CONDITION_LHS)) {
            return false;
        }
        if (critType.equals(CriteriaType.CONDITION_RHS)
                || critType.equals(CriteriaType.CONDITION_RHS_LICRULE)) {
            return supportsRHSField();
        } else if (critType.equals(CriteriaType.ACTION_LHS)) {
            return supportsActions();
        } else if (critType.equals(CriteriaType.ACTION_RHS)) {
            return !critMode.equals(UiCriteriaMode.SERIES) && supportsActions()
                    && !getAssetType().startsWith("SERIES");
        }
        return true;
    }

    @Override
    public boolean supportsSuggestValues() {
        boolean supportedDataType = getDataType().getName().equals(
                IntegerDataType.NAME)
                || getDataType().getName().equals(FloatDataType.NAME)
                || getDataType().getName().equals(StringDataType.NAME);
        return supportedDataType && hasSuggestedValues();
    }

    @Override
    public boolean supportsMatched() {
        return true;
    }
}