package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.IAssetTypeWFileProvider;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.IAssetTypeWFileProviderAsync;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;


public class AssetTreeObject implements IFieldTreeObject {

	private UIAssetDefinition assetDefinition;
	private static Set<String> AssetTypesWithFile;

	public AssetTreeObject(UIAssetDefinition assetDefinition) {
		this.assetDefinition = assetDefinition;
	}

	public static void initialize(final AsyncCallback<Void> callback) {
		//already got it
		if(AssetTypesWithFile != null) {
			callback.onSuccess(null);
		}

		//make call to server
		IAssetTypeWFileProviderAsync service = GWT.create(IAssetTypeWFileProvider.class);
		service.getAssetTypeWFile(new AsyncCallback<Set<String>>() {

			@Override
			public void onFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onSuccess(Set<String> result) {
				AssetTypesWithFile = result;
				callback.onSuccess(null);
			}
			
		});
		
	}
	
	public UIAssetDefinition getAssetDefinition() {
		return assetDefinition;
	}

	public static boolean isInitialized() {
		return AssetTypesWithFile != null;
	}

	@Override
	public UIFieldDataType getDataType() {
		// assets don't have a data type
		return null;
	}

	@Override
	public UIFieldType getFieldType() {
		return UIFieldType.ASSET;
	}

	@Override
	public String getFullDisplayName() {
		return assetDefinition.getDisplayName();
	}

	@Override
	public String getSimpleDisplayName() {
		return assetDefinition.getDisplayName();
	}

	@Override
	public List<UIValueOption> getSuggestedValues() {
		return new ArrayList<UIValueOption>();
	}

	@Override
	public boolean hasSuggestedValues() {
		return false;
	}

	@Override
	public boolean supportsActions() {
		return assetDefinition.getParentDefinition() != null;
	}

	@Override
	public boolean supportsOther() {
		return true;
	}

	public boolean supportsRHSField() {
		return false;
	}

	@Override
	public String getAssetType() {
		return assetDefinition.getPath();
	}

	@Override
	public String getField() {
		return "";
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((getAssetType() == null) ? 0 : getAssetType().hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof AssetTreeObject) {
			return ((AssetTreeObject) obj).getAssetType()
					.equals(getAssetType());
		}
		return false;
	}

	@Override
	public boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
		if (critType.equals(CriteriaType.BASIC_METADATA)) {
			return ((getAssetType().startsWith("PACKAGE") && critMode.equals(UiCriteriaMode.EPISODE)) 
					|| (getAssetType().startsWith("SERIES") && critMode.equals(UiCriteriaMode.SERIES)));
		}
		if(critMode.equals(UiCriteriaMode.SERIES) && getAssetType().startsWith("PACKAGE")) {
			return false;
		}
		if (getAssetType().startsWith("SERIES")
				&& critMode.equals(UiCriteriaMode.EPISODE)
				&& critType.equals(CriteriaType.SEARCH_CONDITION_LHS)) {
			return false;
		}
		if (critType.equals(CriteriaType.CONDITION_RHS)
				|| critType.equals(CriteriaType.CONDITION_RHS_LICRULE)) {
			return supportsRHSField();
		} else if (critType.equals(CriteriaType.ACTION_LHS)) {
			return supportsActions();
		} else if (critType.equals(CriteriaType.ACTION_RHS)) {
			return false;
		}
		return true;
	}

	@Override
	public boolean supportsSuggestValues() {
		return false;
	}
	
	public boolean supportsFiles() {
		return supportsFiles(assetDefinition);
	}
	
	public boolean isGroupType() {
		return assetDefinition instanceof UIGroupAssetDefinition;
	}

	private boolean supportsFiles(UIAssetDefinition assetDefn) {
		String assetType = getAssetType();
		return AssetTypesWithFile.contains(assetType);
	}

	@Override
	public boolean supportsMatched() {
		return true;
	}

}
