package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;


public class LicenseTreeObject implements IFieldTreeObject {

	private UIFieldDefinition fieldDefinition;

	public LicenseTreeObject(UIFieldDefinition fieldDefinition) {
		this.fieldDefinition = fieldDefinition;
	}

	@Override
	public String getSimpleDisplayName() {
		return fieldDefinition.getDisplayName();
	}

	@Override
	public String getFullDisplayName() {
		return "Licensing." + fieldDefinition.getDisplayName();
	}

	@Override
	public Collection<UIValueOption> getSuggestedValues() {
		if(hasSuggestedValues()) {
			return ((UISimpleFieldDefinition)fieldDefinition).getSuggestedValues();
		}
		return new ArrayList<UIValueOption>();
	}

	@Override
	public UIFieldType getFieldType() {
		return UIFieldType.LICENSE;
	}

	@Override
	public UIFieldDataType getDataType() {
		if (fieldDefinition instanceof UIComplexFieldDefinition) {
			return null;
		} else {
			return ((UISimpleFieldDefinition) fieldDefinition).getDatatype();
		}
	}

	@Override
	public boolean supportsActions() {
		return !(fieldDefinition instanceof UIComplexFieldDefinition);
	}

	@Override
	public boolean hasSuggestedValues() {
		if(fieldDefinition instanceof UISimpleFieldDefinition) {
			List<UIValueOption> values = ((UISimpleFieldDefinition) fieldDefinition)
					.getSuggestedValues();
			return values != null && values.size() > 0;
		}
		return false;
	}

	@Override
	public boolean supportsOther() {
		return true;
	}

	@Override
	public boolean supportsSuggestValues() {
		boolean supportedDataType = getDataType().getName().equals(
				IntegerDataType.NAME)
				|| getDataType().getName().equals(FloatDataType.NAME)
				|| getDataType().getName().equals(StringDataType.NAME);
		return supportedDataType && hasSuggestedValues();
	}

	public boolean supportsRHSField() {
		return true;
	}

	@Override
	public boolean supportsCriteriaType(CriteriaType critType,
			UiCriteriaMode critMode) {
		if(critMode.equals(UiCriteriaMode.SERIES) || fieldDefinition instanceof UIComplexFieldDefinition) {
			return false;
		}
		switch (critType) {
		case CONDITION_RHS:
			return true;
		case RULE_CONDITION_LHS:
			return supportsActions();
		case SEARCH_CONDITION_LHS:
			return false;
		case ACTION_LHS:
			return true;
		case ACTION_RHS:
			return false;
		default:
			return false;
		}
	}

	@Override
	public String getAssetType() {
		return "LICENSE";
	}

	@Override
	public String getField() {
		return fieldDefinition.getXPath();
	}

	@Override
	public boolean supportsMatched() {
		return false;
	}

	public UIFieldDefinition getFieldDefinition() {
		return fieldDefinition;
	}

}
