package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.Collection;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.google.gwt.core.client.GWT;



public class MatchedItemTreeObj implements IMIFieldTreeObject {

	private IFieldTreeObject userObject;
	private IFieldTreeObject parent;
	private TitleConstants myConstants = (TitleConstants) GWT
			.create(TitleConstants.class);

	public MatchedItemTreeObj(IFieldTreeObject userObject,
			IFieldTreeObject parent) {
		this.userObject = userObject;
		setParent(parent);
	}

	/**
	 * Sets the root XmlTreeObject of this matched item.
	 * 
	 * @param parent
	 */
	public void setParent(IFieldTreeObject parent) {
		this.parent = parent;
	}

	/**
	 * Gets the root XmlTreeObject of this matched item.
	 * 
	 * @return
	 */
	public IFieldTreeObject getParent() {
		return parent;
	}

	@Override
	public String getFullDisplayName() {
		return myConstants.matched() + "." + userObject.getFullDisplayName();
	}

	public IFieldTreeObject getUserObject() {
		return userObject;
	}

	@Override
	public UIFieldDataType getDataType() {
		return userObject.getDataType();
	}

	@Override
	public UIFieldType getFieldType() {
		return userObject.getFieldType();
	}

	@Override
	public String getSimpleDisplayName() {
		return userObject.getSimpleDisplayName();
	}

	@Override
	public Collection<UIValueOption> getSuggestedValues() {
		return userObject.getSuggestedValues();
	}

	@Override
	public boolean supportsActions() {
		return userObject.supportsActions();
	}

	@Override
	public boolean hasSuggestedValues() {
		return userObject.hasSuggestedValues();
	}

	@Override
	public boolean supportsOther() {
		return false;
	}

	public boolean supportsRHSField() {
		return false;
	}

	@Override
	public String getAssetType() {
		return userObject.getAssetType();
	}

	@Override
	public String getField() {
		return userObject.getField();
	}

	@Override
	public boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
		return userObject.supportsCriteriaType(critType, critMode);
	}

	@Override
	public boolean supportsSuggestValues() {
		return userObject.supportsSuggestValues();
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((userObject == null) ? 0 : userObject.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		return userObject.equals(obj);
	}

	@Override
	public boolean supportsMatched() {
		return true;
	}

}