package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.BooleanDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;


public class PMMTitleTreeObject implements IFieldTreeObject {

	private List<UIValueOption> suggestedValues;
	private String displayName;
	private String path;
	private UIFieldDataType dataType;
	private boolean supportsOther;
	
	public PMMTitleTreeObject(String path, String displayName,
			UIFieldDataType dataType) {
		this.path = path;
		this.displayName = displayName;
		this.dataType = dataType;
		suggestedValues = new ArrayList<UIValueOption>();
		supportsOther = true;
	}

	public PMMTitleTreeObject(String path, String displayName,
			UIFieldDataType dataType, List<UIValueOption> suggestedValues,
			boolean supportsOther) {
		this.path = path;
		this.displayName = displayName;
		this.dataType = dataType;
		this.supportsOther = supportsOther;
		this.suggestedValues = suggestedValues;
	}

	@Override
	public UIFieldDataType getDataType() {
		return dataType;
	}

	@Override
	public UIFieldType getFieldType() {
		return UIFieldType.PMM_TITLE;
	}

	@Override
	public String getFullDisplayName() {
		return displayName;
	}

	@Override
	public String getSimpleDisplayName() {
		return displayName;
	}

	@Override
	public List<UIValueOption> getSuggestedValues() {
		return suggestedValues;
	}
	
	public void setSuggestedValues(List<UIValueOption> suggestedValues) {
		this.suggestedValues = suggestedValues;
	}

	@Override
	public boolean supportsActions() {
		// PMM Title objects never support actions
		return false;
	}

	@Override
	public boolean supportsOther() {
		return supportsOther;
	}

	@Override
	public boolean supportsSuggestValues() {
		boolean supportedDataType = getDataType().getName().equals(
				IntegerDataType.NAME)
				|| getDataType().getName().equals(BooleanDataType.NAME)
				|| getDataType().getName().equals(StringDataType.NAME);
		return supportedDataType && getSuggestedValues().size() > 0;
	}

	public boolean supportsRHSField() {
		// PMM Title objects never support RHS field
		return false;
	}

	@Override
	public boolean hasSuggestedValues() {
		return suggestedValues.size() > 0;
	}

	@Override
	public String getAssetType() {
		// TODO not sure if this is what we want
		return "PMM_TITLE";
	}

	@Override
	public String getField() {
		return path;
	}

	@Override
	public boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
		return critType.equals(CriteriaType.SEARCH_CONDITION_LHS)
				|| critType.equals(CriteriaType.RULE_CONDITION_LHS)
				|| critType.equals(CriteriaType.RULE_CONDITION_LHS_LICRULE);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((getField() == null) ? 0 : getField().hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof PMMTitleTreeObject) {
			return ((PMMTitleTreeObject) obj).getField().equals(getField());
		}
		return false;
	}

	@Override
	public boolean supportsMatched() {
		return false;
	}
}
