package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;


public class UiSubscriptionFields implements IFieldTreeObject, Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private UIFieldDataType dataType;
	private String displayName;
	private String identifier;
	private UiSubscriptionProfile subscriptionProfile;

	/**
	 * provided for GWT only. Should not be used.
	 */
	public UiSubscriptionFields() {
		super();
	}

	/**
	 * @param dataType
	 * @param displayName
	 * @param identifier
	 */
	public UiSubscriptionFields(UIFieldDataType dataType, String displayName,
			String identifier, UiSubscriptionProfile subscriptionProfile) {
		super();
		this.dataType = dataType;
		this.displayName = displayName;
		this.identifier = identifier;
		this.subscriptionProfile = subscriptionProfile;
	}

	@Override
	public String getSimpleDisplayName() {
		return displayName;
	}

	@Override
	public String getFullDisplayName() {
		return subscriptionProfile.getFullDisplayName()+"."+displayName;
	}

	@Override
	public Collection<UIValueOption> getSuggestedValues() {
		return new ArrayList<UIValueOption>(0);
	}

	@Override
	public UIFieldType getFieldType() {
		return UIFieldType.ENHANCEMENT;
	}

	@Override
	public UIFieldDataType getDataType() {
		return dataType;
	}

	@Override
	public boolean supportsActions() {
		return true;
	}

	@Override
	public boolean hasSuggestedValues() {
		return false;
	}

	@Override
	public boolean supportsOther() {
		return false;
	}

	@Override
	public boolean supportsSuggestValues() {
		return false;
	}

	@Override
	public boolean supportsCriteriaType(CriteriaType critType,
			UiCriteriaMode critMode) {
		return critType.equals(CriteriaType.ACTION_LHS);
	}

	@Override
	public boolean supportsMatched() {
		return false;
	}

	@Override
	public String getAssetType() {
		return subscriptionProfile.getProfileId().toString();
	}

	@Override
	public String getField() {
		return identifier;
	}
	
	public UiSubscriptionProfile getSubscriptionProfile() {
		return subscriptionProfile;
	}

}
