package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;


public class UiSubscriptionProfile implements IFieldTreeObject, Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    private String displayName;
    private Long profileId;
    private Collection<UiSubscriptionFields> fields;


    /**
     * provided for GWT only. Should not be used.
     */
    public UiSubscriptionProfile() {

    }

    /**
     * @param displayName
     * @param profileId
     * @param fields
     */
    public UiSubscriptionProfile(String displayName, Long profileId) {
        super();
        this.displayName = displayName;
        this.profileId = profileId;
        this.fields = new ArrayList<UiSubscriptionFields>();
    }

    public Collection<UiSubscriptionFields> getSubscriptionFields() {
        return fields;
    }

    public void addField(UiSubscriptionFields field) {
        fields.add(field);
    }

    @Override
    public String getSimpleDisplayName() {
        return displayName;
    }

    @Override
    public String getFullDisplayName() {
        return displayName;
    }

    public Long getProfileId() {
        return profileId;
    }

    @Override
    public Collection<UIValueOption> getSuggestedValues() {
        return new ArrayList<UIValueOption>(0);
    }

    @Override
    public UIFieldType getFieldType() {
        return UIFieldType.ENHANCEMENT;
    }

    @Override
    public UIFieldDataType getDataType() {
        return null;
    }

    @Override
    public boolean supportsActions() {
        return false;
    }

    @Override
    public boolean hasSuggestedValues() {
        return false;
    }

    @Override
    public boolean supportsOther() {
        return false;
    }

    @Override
    public boolean supportsSuggestValues() {
        return false;
    }

    @Override
    public boolean supportsCriteriaType(CriteriaType critType,
            UiCriteriaMode critMode) {
        return false;
    }

    @Override
    public boolean supportsMatched() {
        return false;
    }

    @Override
    public String getAssetType() {
        return getProfileId().toString();
    }

    @Override
    public String getField() {
        return "";
    }
}
