package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleMessages;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSValueWidget;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSWidgetFactory;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.SimpleRHSValueWidget;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.ParamType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.RhsType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorFull;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorLimited;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterConditionNode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterRHSFieldNode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;



/**
 * A UI predicate row
 * 
 * @author dweiner
 * 
 */
public class PredicateRow extends PredicateRowBase {


    private final TitleMessages myMessages = (TitleMessages) GWT.create(TitleMessages.class);

    private static final TitleConstants myConstants = (TitleConstants) GWT.create(TitleConstants.class);
    private static final String PREDICATE_LABEL_STYLE = "predicate-label";
    private static int switchRhsCounter = 0;

    private BaseOperator operatorProvider;
    private ListBoxWidget<BaseOperator> operatorList;
    private TextBox lhsFldTxtBox;
    private TextBox rhsFldTxtBox;
    private RHSValueWidget dataValue;
    private final SimplePanel rhsValuePanel = new SimplePanel();
    private FieldSelector lhsFieldSelector;
    private FieldSelector rhsFieldSelector;
    private final VerticalPanel switchRhs = new VerticalPanel();
    private final RadioButton rhsField = new RadioButton("switchRhs"+switchRhsCounter, myConstants.field());
    private final RadioButton rhsValue = new RadioButton("switchRhs"+switchRhsCounter, myConstants.value());
    private IFieldTreeObject treeObject;
    private CheckBox ignoreCaseChkBox;
    private TreeItem evalChild;
    private CheckBox notChkBox;

    private Button addRow;

    private IFieldTreeObject treeObjectRhs;



    /**
     * Predicate row with root node of containers specification
     * 
     * @param parentContainer
     */
    public PredicateRow(CriteriaListingPanel parentContainer) {
        super(parentContainer);
        setOperatorProvider(parentContainer.getOperatorProvider());
        putUiTogther();
        switchRhsCounter++;
    }

    /**
     * Predicate row of a sub tree item. Specifically, evaluate child fields
     * 
     * @param parentContainer
     * @param treeItem
     */
    public PredicateRow(CriteriaListingPanel parentContainer, TreeItem treeItem) {
        this(parentContainer);
        this.evalChild = TreeCreator.cloneRootAssetType(treeItem);
        // Set the search operator for eval child field.
        setOperatorProvider(new RulesOperatorLimited());
    }

    /**
     * Filter the operator list according to the data type
     * 
     * @param dataType
     */
    private void filterOperatorList(IFieldTreeObject obj) {
        BaseOperator selectedItem = operatorList.getSelectedItem();
        // new List Contains Selected Item
        boolean newListContainsSI = false;
        operatorList.clear();

        BaseOperator sop = getOperatorProvider();
        List<BaseOperator> operators = sop.getOperators(obj);
        for (BaseOperator operator : operators) {
            String strItem = operator.toString();
            operatorList.addItem(myConstants.getString(strItem), operator);

            if (selectedItem != null && operator.equals(selectedItem)) {
                newListContainsSI = true;
            }
        }

        if (newListContainsSI) {
            operatorList.setSelectedItem(selectedItem);
        }

        resetDataValueWithEmptyString();

    }

    public void putUiTogther() {
        lhsFldTxtBox = new TextBox();
        rhsFldTxtBox = new TextBox();
        /*
         * give the data value a string default so it looks pretty. The real one
         * will be loaded when they select the operator
         */
        dataValue = new SimpleRHSValueWidget(new ValueTextBox(
                new StringValidator()));
        rhsValuePanel.setWidget(dataValue);
        operatorList = createOperatorList();
        operatorList.addChangeHandler(getOperatorListChangeHandler());
        ignoreCaseChkBox = new CheckBox();
        ignoreCaseChkBox.setText(myConstants.caseInsensitive());
        ignoreCaseChkBox.setVisible(false);
        ignoreCaseChkBox.addStyleName(PREDICATE_LABEL_STYLE);
        ignoreCaseChkBox.addStyleName("small-txt");

        notChkBox = new CheckBox();
        notChkBox.setText(myConstants.not());
        notChkBox.addStyleName("small-txt");

        Button btnDelete = createRemoveButton();

        lhsFldTxtBox.setReadOnly(true);
        lhsFldTxtBox.addStyleName("black-txt");
        lhsFldTxtBox.addStyleName("small-txt");
        lhsFldTxtBox.setVisibleLength(35);
        lhsFldTxtBox.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                if (canChangePredicateRow()) {
                    showLhsFieldSelector();
                }
            }
        });

        rhsFldTxtBox.setReadOnly(true);
        rhsFldTxtBox.addStyleName("black-txt");
        rhsFldTxtBox.addStyleName("small-txt");
        rhsFldTxtBox.setVisibleLength(35);
        rhsFldTxtBox.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                showRhsFieldSelector();
            }
        });

        HorizontalPanel horPanel = new HorizontalPanel();
        horPanel.setSpacing(3);

        SimplePanel chkBoxContainer = new SimplePanel();
        chkBoxContainer.setWidget(notChkBox);
        chkBoxContainer.addStyleName(PREDICATE_LABEL_STYLE);
        horPanel.add(chkBoxContainer);

        rhsField.addClickHandler(handleRhsSwitch());
        rhsValue.addClickHandler(handleRhsSwitch());

        horPanel.setCellVerticalAlignment(chkBoxContainer, ALIGN_TOP);
        horPanel.add(lhsFldTxtBox);
        horPanel.setCellVerticalAlignment(lhsFldTxtBox, ALIGN_TOP);
        horPanel.add(operatorList);
        horPanel.setCellVerticalAlignment(operatorList, ALIGN_TOP);
        horPanel.add(switchRhs);
        horPanel.add(rhsValuePanel);
        horPanel.setCellVerticalAlignment(rhsValuePanel, ALIGN_TOP);

        SimplePanel caseChkBoxContainer = new SimplePanel();
        caseChkBoxContainer.setWidget(ignoreCaseChkBox);
        caseChkBoxContainer.addStyleName(PREDICATE_LABEL_STYLE);
        horPanel.add(caseChkBoxContainer);
        horPanel.setCellVerticalAlignment(caseChkBoxContainer, ALIGN_TOP);

        horPanel.add(btnDelete);
        horPanel.setCellVerticalAlignment(btnDelete, ALIGN_TOP);

        treeObject = null;

        add(horPanel);

        /*
         * add a container for the children for eval child fields this isn't for
         * sub criteria or sibling critiria it is for eval child field only.
         */
        add(this.createContainer());
        //default don't show this bugger
    }

    private ClickHandler handleRhsSwitch() {
        return new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                if(rhsField.getValue()) {
                    rhsValuePanel.setWidget(rhsFldTxtBox);
                } else {
                    rhsValuePanel.setWidget(dataValue);
                }
            }
        };
    }

    private void showLhsFieldSelector() {
        int x = lhsFldTxtBox.getAbsoluteLeft();
        int y = lhsFldTxtBox.getAbsoluteTop();
        if(lhsFieldSelector == null && evalChild != null) {
            lhsFieldSelector = FieldSelector.getSubTree(evalChild);
        } else if(lhsFieldSelector == null) {
            lhsFieldSelector =FieldSelector.getTree(root.getLhsCriteriaType(), root.getCriteriaMode());
        }
        lhsFieldSelector.show(x, y, treeObject, getLhsSelectHandler());
    }

    private void showRhsFieldSelector() {
        int x = rhsFldTxtBox.getAbsoluteLeft();
        int y = rhsFldTxtBox.getAbsoluteTop();
        if (rhsFieldSelector == null) {
            rhsFieldSelector = FieldSelector.getTypedTree(
                    root.getRhsCriteriaType(), root.getCriteriaMode(),
                    treeObject.getDataType());
        }
        rhsFieldSelector.show(x, y, treeObjectRhs, getRhsSelectHandler());
    }

    private void resetDataValue(List<String> values) {
        if (treeObject == null) {
            return;
        }

        BaseOperator operator = operatorList.getSelectedItem();
        if (operator.allowRhsField()
                && operatorProvider instanceof RulesOperatorLimited) {
            switchRhs.add(rhsField);
            switchRhs.add(rhsValue);
            rhsValue.setValue(true);
        } else {
            switchRhs.clear();
        }
        dataValue = RHSWidgetFactory
                .getRHSWidgets(treeObject, operator, values);
        rhsValuePanel.setWidget(dataValue);
    }

    private void resetDataValueWithEmptyString() {
        int length = dataValue.getValues().size();
        List<String> emptyStrings = new ArrayList<String>(length);
        for (int i = 0; i < length; i++) {
            emptyStrings.add("");
        }
        resetDataValue(emptyStrings);
    }

    private ChangeHandler getOperatorListChangeHandler() {
        return new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                if (operatorList.getSelectedItem() == RulesOperatorFull.EVALCHILDFIELDS) {
                    // eval child fields
                    UIFieldType fieldType = treeObject.getFieldType();
                    String asset = treeObject.getAssetType();
                    String xpath = treeObject.getField();
                    TreeItem item;
                    try {
                        item = TreeCreator.findItem(fieldType, asset, xpath, root.getLhsCriteriaType(), root.getCriteriaMode());
                    } catch (UndefinedFieldException e) {
                        root.addWarningMessage(myMessages.invalidField(asset +" "+xpath));
                        return;
                    }

                    PredicateRow pred = new PredicateRow(root, item);
                    addChildRow(pred);
                    setAddRowButtonVisible(true);
                } else {
                    //just in case the last operator was eval child field clear the childrenPanel
                    clearChildPanel(false);
                    setAddRowButtonVisible(false);

                    BaseOperator op = operatorList.getSelectedItem();
                    UIFieldDataType dataType = treeObject.getDataType();
                    setIgnoreCaseVisibility(isSensitiveVisible(dataType, op));
                }
                resetDataValue(dataValue.getValues());
            }
        };
    }

    public void setAddRowButtonVisible(boolean visible) {
        addRow.setVisible(visible);
    }

    /**
     * Should probably be using events for this... This is called from
     * XmlSelection when an update happens.
     */
    public FieldSelectorHandler getLhsSelectHandler() {
        return new FieldSelectorHandler() {

            @Override
            public void onSelection(TreeItem item) {
                updateFieldLhs(item);
            }

            @Override
            public boolean isSelectable(TreeItem item) {
                return ((IFieldTreeObject) item.getUserObject())
                        .supportsCriteriaType(root.getLhsCriteriaType(),
                                root.getCriteriaMode());
            }
        };
    }

    /**
     * Should probably be using events for this... This is called from
     * XmlSelection when an update happens.
     */
    public FieldSelectorHandler getRhsSelectHandler() {
        return new FieldSelectorHandler() {

            @Override
            public void onSelection(TreeItem item) {
                updateFieldRhs(item);
            }

            @Override
            public boolean isSelectable(TreeItem item) {
                IFieldTreeObject tree = (IFieldTreeObject) item.getUserObject();
                return tree.getDataType() != null;
            }
        };
    }

    /**
     * Each row represents a predicate derived from a UI filter value node
     * object. This method populates the row with the predicate
     * 
     * @param predicateNode
     */
    public void setPredicate(UITitleFilterConditionNode predicateNode, UiCriteriaMode critMode) {

        String sectionType = predicateNode.getSectionType();
        String xpath = predicateNode.getField();
        UIFieldType fieldType = predicateNode.getFieldType();
        BaseOperator searchOp = predicateNode.getSearchOperator();
        boolean isIgnoreCase = predicateNode.isIgnoreCase();
        boolean isNot = predicateNode.isNot();

        // set crap here

        IFieldTreeObject obj;
        try {
            obj = TreeCreator.findObject(fieldType, sectionType, xpath, critMode);
        } catch (UndefinedFieldException e1) {
            root.addWarningMessage(myMessages.invalidField(sectionType +" "+xpath));
            return;
        }
        setLhsField(obj.getFullDisplayName());
        filterOperatorList(obj);
        setOperatorList(predicateNode.getSearchOperator());
        setIgnoreCaseVisibility(isSensitiveVisible(obj.getDataType(), searchOp));

        this.treeObject = obj;
        // set the data value
        if(predicateNode.getRhsType().equals(RhsType.FIELD)) {
            UITitleFilterRHSFieldNode rhsPred = (UITitleFilterRHSFieldNode) predicateNode;
            rhsValuePanel.setWidget(rhsFldTxtBox);
            String xpathRhs = rhsPred.getFieldRhs();
            String sectionTypeRhs  = rhsPred.getSectionTypeRhs();
            UIFieldType fieldTypeRhs = rhsPred.getFieldTypeRhs();
            try {
                treeObjectRhs = TreeCreator.findObject(fieldTypeRhs, sectionTypeRhs, xpathRhs, critMode);
            } catch (UndefinedFieldException e) {
                root.addWarningMessage(myMessages.invalidField(sectionTypeRhs +" "+xpathRhs));
                return;
            }
            switchRhs.add(rhsField);
            switchRhs.add(rhsValue);
            rhsField.setValue(true);
            setRhsField(treeObjectRhs.getFullDisplayName());
        } else if(predicateNode.getRhsType().equals(RhsType.VALUE)) {
            resetDataValue(((UITitleFilterValueNode)predicateNode).getValues());
        } else {
            resetDataValue(new ArrayList<String>(0));
        }
        this.ignoreCaseChkBox.setValue(isIgnoreCase);
        this.notChkBox.setValue(isNot);
        if (!isEvalChild()) {
            try {
                TreeItem item = TreeCreator.findItem(fieldType, sectionType, xpath, root.getLhsCriteriaType(), root.getCriteriaMode());
                this.root.notifyChange(item, null);
            } catch (UndefinedFieldException e) {
                root.addWarningMessage(myMessages.invalidField(sectionType +" "+xpath));
                return;
            }
        }
    }

    /**
     * Whether the sensitive checkbox will show up
     * 
     * @param type
     * @param op
     * @return
     */
    private boolean isSensitiveVisible(UIFieldDataType type, BaseOperator op) {
        return isItemString(type) && isStringIngoreCaseOperator(op);
    }

    private boolean isStringIngoreCaseOperator(BaseOperator op) {
        return !op.equals(BaseOperator.ISEMPTY)
                && !op.equals(BaseOperator.LENGTHEQUALS)
                && !op.equals(BaseOperator.LENGTHLESSTHAN)
                && !op.equals(BaseOperator.LENGTHGREATERTHAN)
                && !op.equals(BaseOperator.TOTALLENGTHEQUALS)
                && !op.equals(BaseOperator.TOTALLENGTHLESSTHAN)
                && !op.equals(BaseOperator.TOTALLENGTHGREATERTHAN)
                && !op.equals(BaseOperator.NUMINSTANCESEQUAL)
                && !op.equals(BaseOperator.NUMINSTANCESGREATERTHAN)
                && !op.equals(BaseOperator.NUMINSTANCESLESSTHAN)
                && !op.equals(BaseOperator.REGEX)
                && !op.equals(BaseOperator.CONTAINS)
                && !op.equals(BaseOperator.FIELDINVALID);
    }

    /*
     * check if XmlTreeObject is type string
     */
    private boolean isItemString(UIFieldDataType dataType) {
        return dataType != null
                && dataType.getName().equalsIgnoreCase("string");
    }

    /*
     * Creates the operator list. should be moved somewhere else...
     */
    private static ListBoxWidget<BaseOperator> createOperatorList() {
        ListBoxWidget<BaseOperator> list = new ListBoxWidget<BaseOperator>();
        list.addStyleName("condition-list");
        Collection<BaseOperator> operators = BaseOperator.values();

        for (BaseOperator oper : operators) {
            String strItem = oper.toString();
            list.addItem(myConstants.getString(strItem), oper);
        }
        return list;
    }

    public boolean isEvalChild() {
        return evalChild != null;
    }

    public void setEvalChild(TreeItem evalChild) {
        this.evalChild = evalChild;
    }

    private void setOperatorList(BaseOperator operator) {
        operatorList.setSelectedItem(operator);
        if(operatorList.getSelectedIndex() == -1) {
            root.addWarningMessage(myMessages.invalidOperator(operator.toString()));
        }
    }

    /*
     * Creates an remove button with an appropriate click handler that adds
     * deletes a row. Actually, it just hides it, but gets ignored when save
     * occurs
     */
    private Button createRemoveButton() {
        Button button = new Button("-", new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                if (canChangePredicateRow()) {
                    parentList.removeItem(PredicateRow.this);
                    root.notifyRemoval(treeObject);
                }
            }
        });
        button.setTitle(myConstants.removeCriteria());
        button.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);
        return button;
    }

    private void setOperatorProvider(BaseOperator operatorProvider) {
        this.operatorProvider = operatorProvider;
    }

    private BaseOperator getOperatorProvider() {
        return this.operatorProvider;
    }

    /**
     * Returns true if this predicate row can changed based on whether this
     * sucker has children.
     * 
     * @return
     */
    public boolean canChangePredicateRow() {
        if (this.parentList instanceof PredicateRow) {
            return true;
        }
        boolean result = true;
        if (!root.canChangePredicateRow(PredicateRow.this)) {
            result = false;
        }
        return result;
    }

    /**
     * Validation method for this row
     * 
     * @return
     */
    @Override
    public boolean validate() {
        boolean result = super.validate();

        if (lhsFldTxtBox.getValue().equals("")) {
            this.lhsFldTxtBox.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
            result = false;
        }

        if(rhsField.getValue() && rhsFldTxtBox.getValue().equals("")) {
            this.rhsFldTxtBox.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
            result = false;
        } else if((!rhsValue.isAttached() || rhsValue.getValue()) && !dataValue.validate()) {
            result = false;
        }
        return result;
    }

    public ParamType getParamType() {
        BaseOperator operator = operatorList.getSelectedItem();
        return operator.multiValued() ? ParamType.LIST : ParamType.VALUE;
    }

    /**
     * Gets the level from the top (0)
     * 
     * @return
     */
    public int getLevel() {
        int i = 0;
        PredicateRowBase node = this;

        while (node != null) {
            i++;
            node = node.getParentList();
        }
        return i - 1;
    }

    public void updateFieldLhs(TreeItem item) {
        IFieldTreeObject oldObj = treeObject;
        IFieldTreeObject itemObj = (IFieldTreeObject) item.getUserObject();

        if (oldObj != null) {
            UIFieldDataType oldDT = oldObj.getDataType();
            UIFieldDataType newDT = itemObj.getDataType();
            if( oldDT != null && newDT != null &&
                    (oldDT == null ^ newDT == null ||
                    !oldDT.getName().equals(newDT.getName()))) {
                rhsFldTxtBox.setValue("");
                treeObjectRhs = null;
                rhsFieldSelector = null;
            }
        }

        //More hacks for eval child field
        //if you change the field and we have an eval child children we need to delete them.
        if(oldObj != null && getChildCount() > 0 && (!oldObj.getAssetType().equals(itemObj.getAssetType()) ||
                !oldObj.getField().equals(itemObj.getField()))) {
            clearChildPanel(false);
            setAddRowButtonVisible(false);
            getOperatorList().setSelectedIndex(0);
        }

        // if the user forgot to click next before
        this.lhsFldTxtBox.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);

        setLhsField(itemObj.getFullDisplayName());
        setLhsTreeObject(itemObj);
        filterOperatorList(itemObj);
        setIgnoreCaseVisibility(isSensitiveVisible(itemObj.getDataType(),
                operatorList.getSelectedItem()));

        /*
         * If this is a Complex Type (Eval Child Fields) we don't need to notify
         * change child fields are treated as part of the parent predicate and
         * don't need to be add to actions.
         * 
         * If nothing has changed than we don't need to notify of change.
         */
        Object userObj = item.getUserObject();
        if (!isEvalChild() && (oldObj == null || !oldObj.equals(userObj))) {
            this.root.notifyChange(item, oldObj);
        }
    }

    public void updateFieldRhs(TreeItem item) {
        IFieldTreeObject itemObj = (IFieldTreeObject) item.getUserObject();
        // if the user forgot to click next before
        this.lhsFldTxtBox.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);

        setRhsField(itemObj.getFullDisplayName());
        setRhsTreeObject(itemObj);
    }

    public boolean hasContents() {
        return !this.lhsFldTxtBox.getValue().equals("");
    }

    public RHSValueWidget getDataValue() {
        return this.dataValue;
    }

    public ListBoxWidget<BaseOperator> getOperatorList() {
        return operatorList;
    }

    public RhsType getRhsType() {
        if(getOperatorList().getSelectedItem().equals(BaseOperator.EVALCHILDFIELDS)) {
            return RhsType.COMPLEX;
        }
        if(rhsValue.getValue() || !rhsValue.isAttached()) {
            return RhsType.VALUE;
        }
        if(rhsField.getValue()) {
            return RhsType.FIELD;
        }
        return RhsType.VALUE;
    }

    public List<String> getValue() {
        return dataValue.getValues();
    }

    public void setLhsField(String s) {
        lhsFldTxtBox.setText(s);
        lhsFldTxtBox.setTitle(s);
    }

    public String getLhsField() {
        return lhsFldTxtBox.getText();
    }

    public void setRhsField(String s) {
        rhsFldTxtBox.setText(s);
        rhsFldTxtBox.setTitle(s);
    }

    public String getRhsField() {
        return rhsFldTxtBox.getText();
    }

    public IFieldTreeObject getLhsTreeObject() {
        return treeObject;
    }

    public void setLhsTreeObject(IFieldTreeObject xmlTreeObject) {
        this.treeObject = xmlTreeObject;
    }

    public void setRhsTreeObject(IFieldTreeObject xmlTreeObject) {
        this.treeObjectRhs = xmlTreeObject;
    }

    public IFieldTreeObject getRhsTreeObject() {
        return this.treeObjectRhs;
    }

    public boolean isIgnoreCase() {
        return getOperatorList().getSelectedItem().hasRightSide()
                && this.ignoreCaseChkBox.getValue();
    }

    public void setIgnoreCaseVisibility(boolean visible) {
        this.ignoreCaseChkBox.setVisible(visible);
    }

    public void setNot(boolean not) {
        this.notChkBox.setValue(not);
    }

    public boolean isNot() {
        return notChkBox.getValue();
    }

    public boolean isEmptyRow() {
        // first check the left hand side
        if (getLhsTreeObject() != null) {
            return false;
        }
        // next check the rhs
        return dataValue.getValues() != null
                && dataValue.getValues().isEmpty()
                || dataValue.getValues().size() == 1 && dataValue.getValues()
                .get(0).isEmpty();
    }

    protected Widget buildButtonPanel() {
        HorizontalPanel panel = new HorizontalPanel();
        addRow = getAddCriterionButton();
        setAddRowButtonVisible(false);
        panel.add(addRow);
        return panel;
    }

    /*
     * creates a container which has the brackets and the text format of the
     * operator. this is added as a child row
     */
    private FlexTable createContainer() {
        // create label and add to container
        // create table which has the bracket on the left and children on the
        // right column
        FlexTable tableContainer = new FlexTable();
        tableContainer.setWidget(0, 0, new Label(""));
        tableContainer.getCellFormatter().setStyleName(0, 0, "eval-child-spacing");
        VerticalPanel rightSide = new VerticalPanel();
        rightSide.add(getChildrenPanel());
        rightSide.add(buildButtonPanel());
        tableContainer.setWidget(0, 1, rightSide);
        return tableContainer;
    }

    @Override
    public void removeItem(PredicateRowBase item) {
        super.removeItem(item);
        //I HATE EVAL CHILD FIELD
        //eval child should always have a default row
        if(getChildrenPanel().getWidgetCount() == 0) {
            PredicateRow row = this;
            IFieldTreeObject obj = row.getLhsTreeObject();
            TreeItem treeItem = TreeCreator.convertToTreeItem(obj, root.getLhsCriteriaType(), root.getCriteriaMode());
            addChildRow(new PredicateRow(root, treeItem));
        }
    }

    private Button getAddCriterionButton() {
        Button button = new Button("+");
        button.setTitle(myConstants.addCriterion());
        button.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                // eval child can suck it...
                PredicateRow row = PredicateRow.this;
                //eval child needs a special tree selector.
                IFieldTreeObject obj = row.getLhsTreeObject();
                TreeItem treeItem = TreeCreator.convertToTreeItem(obj, root.getLhsCriteriaType(), root.getCriteriaMode());
                addChildRow(new PredicateRow(root, treeItem));
            }
        });
        return button;
    }
}