package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;



/**
 * This is the base node that contains the structure. Contains children, parents
 * and knows things like if this node is the first item on the list and such.
 * 
 * @author rchu
 * 
 */
public abstract class PredicateRowBase extends VerticalPanel {
    protected PredicateRowBase parentList; // NOSONAR
    protected TitleConstants myConstants = (TitleConstants) GWT.create(TitleConstants.class); // NOSONAR
    private VerticalPanel childrenPanel = new VerticalPanel();
    protected CriteriaListingPanel root; // NOSONAR

    protected PredicateRowBase(CriteriaListingPanel parentContainer) {
        super();
        this.root = parentContainer;
        childrenPanel.setStyleName("predicate-children");
    }

    public PredicateRowBase getParentList() {
        return parentList;
    }

    public void setParentList(PredicateRowBase parent) {
        // TODO: This should be a motherfucking list!
        // Ron I know and I would say that we shouldn't have bloody eval child
        // field.
        this.parentList = parent;
    }

    public boolean isRoot() {
        return parentList == null;
    }

    public boolean validate() {
        // If it is the root, and there is only one predicate row and it is
        // empty than it is the default row.
        if (parentList == null && childrenPanel.getWidgetCount() == 1
                && childrenPanel.getWidget(0) instanceof PredicateRow
                && ((PredicateRow) childrenPanel.getWidget(0)).isEmptyRow()) {
            return true;
        }

        boolean result = true;
        for (Widget pr : childrenPanel) {
            if (!((PredicateRowBase) pr).validate()) {
                result = false;
            }
        }
        return result;
    }

    /**
     * Gets children
     * 
     * @return
     */
    public List<PredicateRowBase> getChildRowNodes() {
        List<PredicateRowBase> result = new ArrayList<PredicateRowBase>();
        if (isEmpty()) {
            return result;
        }
        childrenPanel.iterator();
        for (Widget w : childrenPanel) {
            result.add((PredicateRowBase) w);
        }
        return result;
    }

    public boolean isEmpty() {
        // if it has zero rows or is in the rootList and has one row with no
        // value or field.
        return childrenPanel.getWidgetCount() == 0 || parentList == null
                && childrenPanel.getWidgetCount() == 1
                && childrenPanel.getWidget(0) instanceof PredicateRow && ((PredicateRow) childrenPanel
                        .getWidget(0)).isEmptyRow();
    }

    public int getChildCount() {
        return childrenPanel.getWidgetCount();
    }

    /**
     * Can add a row or a list as its children
     * 
     * @param child
     */
    public void addChildRow(PredicateRowBase child) {
        addChildRow(child, childrenPanel.getWidgetCount());
    }

    private void addChildRow(PredicateRowBase child, int pos) {
        child.setParentList(this);

        if (pos >= childrenPanel.getWidgetCount()) {
            childrenPanel.add(child);
        } else {
            childrenPanel.insert(child, pos);
        }
    }

    public int getPosition(PredicateRowBase base) throws NeptuneException {
        for (int i = 0; i < childrenPanel.getWidgetCount(); i++) {
            if (base.equals(childrenPanel.getWidget(i))) {
                return i;
            }
        }
        throw new NeptuneException("predicateRowBase passed in was not here.");
    }

    /**
     * Removes the item provided from the childrenPanel.
     * 
     * @param item
     */
    public void removeItem(PredicateRowBase item) {
        Iterator<Widget> iterator = childrenPanel.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().equals(item)) {
                iterator.remove();
            }
        }
    }

    public void clearChildPanel(boolean leaveDefaultRow) {
        childrenPanel.clear();
        if (leaveDefaultRow) {
            PredicateRow pr = new PredicateRow(root);
            addChildRow(pr);
        }
    }

    protected VerticalPanel getChildrenPanel() {
        return childrenPanel;
    }

    protected void setChildrenPanel(VerticalPanel childrenPanel) {
        this.childrenPanel = childrenPanel;
    }
}
