package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFileTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.EPGTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.LicenseTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.MatchedItemTreeObj;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.IUIFieldDefinitionVisitor;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFloatFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.ericsson.cms.epgmgmt.client.model.UIConstants;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;


/**
 * This is responsible for creating the UI tree for Xpaths given an asset
 * specification
 * 
 * @author rchu
 * 
 */
public class TreeCreator {

    private static UIFieldDefinition epgData;

    /**
     * @return the epgData
     */
    public static UIFieldDefinition getEpgData() {
        return epgData;
    }

    /**
     * @param data the epgData to set
     */
    public static void setEpgData(UIFieldDefinition data) {
        epgData = data;
    }
    /**
     * recursively traverses the list of fields anding them to the TreeItem.
     * 
     * @param fields
     */
    private static List<TreeItem> traverseFields(
            List<UIFieldDefinition> fields, final CriteriaType critType,
            final UiCriteriaMode critMode, final boolean isContract, final String fileAssetPath, final boolean isActionItem) {
        final List<TreeItem> items = new ArrayList<TreeItem>();
        if(fields == null) {
            return items;
        }
        for (UIFieldDefinition fieldDefn : fields) {
            fieldDefn.accept(new IUIFieldDefinitionVisitor() {
                @Override
                public void visit(UIComplexFieldDefinition fieldDef) {
                    List<TreeItem> children = traverseFields(fieldDef
                            .getChildren(), critType, critMode, isContract, fileAssetPath, isActionItem);
                    if (!fieldDef.isArtificial()) {
                        IFieldTreeObject usrObj;
                        if(isContract) {
                            usrObj = new LicenseTreeObject(fieldDef);
                        } else if(fileAssetPath != null) {
                            usrObj = new AssetFieldTreeObject(fieldDef, "File", fileAssetPath);
                        } else if (critType == CriteriaType.RULE_CONDITION_LHS_EPG || critType == CriteriaType.ACTION_LHS_EPG) {
                            usrObj = new EPGTreeObject(fieldDef);
                        } else {
                            usrObj = new AssetFieldTreeObject(fieldDef);
                        }
                        if (children.size() > 0
                                || usrObj.supportsCriteriaType(critType, critMode)) {
                            TreeItem item = new TreeItem(usrObj
                                    .getSimpleDisplayName());
                            item.setUserObject(usrObj);
                            for (TreeItem cItem : children) {
                                item.addItem(cItem);
                            }
                            items.add(item);

                        }
                    } else if(children.size() > 0) {
                        for(TreeItem item : children) {
                            items.add(item);
                        }
                    }
                }

                @Override
                public void visit(UIBooleanFieldDefinition fieldDefinition) {
                    visitSimpleDefinition(fieldDefinition);
                }

                @Override
                public void visit(UIIntegerFieldDefinition fieldDefinition) {
                    visitSimpleDefinition(fieldDefinition);
                }

                @Override
                public void visit(UIFloatFieldDefinition fieldDefinition) {
                    visitSimpleDefinition(fieldDefinition);
                }

                @Override
                public void visit(UIDateFieldDefinition fieldDefinition) {
                    visitSimpleDefinition(fieldDefinition);
                }

                @Override
                public void visit(UITimeFieldDefinition fieldDefinition) {
                    visitSimpleDefinition(fieldDefinition);
                }

                @Override
                public void visit(UIStringFieldDefinition fieldDefinition) {
                    visitSimpleDefinition(fieldDefinition);
                }

                private void visitSimpleDefinition(
                        UISimpleFieldDefinition fieldDef) {
                    IFieldTreeObject usrObj;
                    if(isContract) {
                        usrObj = new LicenseTreeObject(fieldDef);
                    } else if(fileAssetPath != null) {
                        usrObj = new AssetFieldTreeObject(fieldDef, "File", fileAssetPath);
                    } else if (critType == CriteriaType.RULE_CONDITION_LHS_EPG || critType == CriteriaType.ACTION_LHS_EPG){
                        if (isActionItem){
                            if (isPredicateAllowedInEPGTree(fieldDef)) {
                                usrObj = new EPGTreeObject(fieldDef);
                            } else {
                                usrObj = null;
                            }
                        }
                        else if (isCriteriaAllowedInEPGTree(fieldDef)) {
                            usrObj = new EPGTreeObject(fieldDef);
                        } else {
                            usrObj = null;
                        }
                    } else {
                        usrObj = new AssetFieldTreeObject(fieldDef);
                    }
                    if (usrObj != null && usrObj.supportsCriteriaType(critType, critMode)) {
                        TreeItem item = new TreeItem(usrObj
                                .getSimpleDisplayName());
                        item.setUserObject(usrObj);
                        items.add(item);
                    }
                }

                private boolean isPredicateAllowedInEPGTree(UISimpleFieldDefinition fieldDef){
                    boolean result = false;
                    List<UIValueOption> epgAttribs = fieldDef.getSuggestedValues();
                    if (epgAttribs != null && epgAttribs.size() > 0){
                        for (UIValueOption epgAttrib: epgAttribs) {
                            if (epgAttrib.getName().equalsIgnoreCase(UIConstants.IS_ALLOW_AS_PREDICATE)
                                    && epgAttrib.getValue().equalsIgnoreCase("true")){
                                result = true;
                                break;
                            }
                        }
                    }
                    return result;
                }

                private boolean isCriteriaAllowedInEPGTree(UISimpleFieldDefinition fieldDef){
                    boolean result = false;
                    List<UIValueOption> epgAttribs = fieldDef.getSuggestedValues();
                    if (epgAttribs != null && epgAttribs.size() > 0){
                        for (UIValueOption epgAttrib: epgAttribs) {
                            if (epgAttrib.getName().equalsIgnoreCase(UIConstants.IS_ALLOW_AS_CRITERIA)
                                    && epgAttrib.getValue().equalsIgnoreCase("true")){
                                result = true;
                                break;
                            }
                        }
                    }
                    return result;
                }
            });
        }
        return items;
    }


    private static TreeItem convertFileDef(UIAssetFileDefinition fileDef, CriteriaType critType, UiCriteriaMode critMode) {
        List<UIAssetFileFieldDefinition> fieldDefs = fileDef.getFieldDefinitions();
        AssetFileTreeObject treeObj = new AssetFileTreeObject(fileDef);
        TreeItem items = new TreeItem(treeObj.getSimpleDisplayName());
        items.setUserObject(treeObj);
        for(UIAssetFileFieldDefinition field : fieldDefs) {
            UISimpleFieldDefinition fieldDef = field.getFieldDefinition();
            String assetPath = fileDef.getParent().getPath()+"/FILE";
            AssetFieldTreeObject usrObj = new AssetFieldTreeObject(fieldDef, "File", assetPath);
            if (usrObj.supportsCriteriaType(critType, critMode)) {
                TreeItem item = new TreeItem(usrObj
                        .getSimpleDisplayName());
                item.setUserObject(usrObj);
                items.addItem(item);
            }
        }
        if(!treeObj.supportsCriteriaType(critType, critMode) && items.getChildCount() == 0) {
            return null;
        }
        return items;
    }

    public static List<TreeItem> getTreeItems(CriteriaType critType, UiCriteriaMode critMode) {
        // add all asset definitions to the root of the tree
        List<TreeItem> items = new ArrayList<TreeItem>();
        if (ClientAuthorizationManager.isAuthorized("EPGManager_View")
                && critMode.equals(UiCriteriaMode.EPISODE)
                && (critType.equals(CriteriaType.RULE_CONDITION_LHS_EPG)||critType.equals(CriteriaType.ACTION_LHS_EPG))) {
            items.addAll(getEPGTreeItem(critType, critMode, getEpgData(), false));
        }
        return items;
    }

    public static List<TreeItem> getTreeItems(CriteriaType critType, UiCriteriaMode critMode, boolean isActionItem) {
        // add all asset definitions to the root of the tree
        List<TreeItem> items = new ArrayList<TreeItem>();
        if (ClientAuthorizationManager.isAuthorized("EPGManager_View")
                && critMode.equals(UiCriteriaMode.EPISODE)
                && (critType.equals(CriteriaType.RULE_CONDITION_LHS_EPG)||critType.equals(CriteriaType.ACTION_LHS_EPG))) {
            items.addAll(getEPGTreeItem(critType, critMode, getEpgData(), isActionItem));
        }
        return items;
    }

    private static List<TreeItem> getEPGTreeItem(CriteriaType critType, UiCriteriaMode critMode, UIFieldDefinition def, boolean isActionItem) {
        if(def != null) {
            return traverseFields(Arrays.asList(new UIFieldDefinition[]{def}), critType, critMode, false, null, isActionItem);
        }
        return new ArrayList<TreeItem>(0);
    }

    /**
     * Searches the tree to find an item that has the xmltreeObject that matches
     * the given sectionType and xpath. If found the item is set as the
     * currently selected item.
     * 
     * @param sectionType
     * @param xpath
     * @return xmlTreeObject that matches the given sectionType and xpath
     * @throws UndefinedFieldException
     */
    public static TreeItem findItem(UIFieldType fieldType, String sectionType, String xpath, CriteriaType critType, UiCriteriaMode critMode) throws UndefinedFieldException {
        switch(fieldType) {
        case EPG:
            return findEpgFieldTreeItem(xpath, critType);
        default:
            throw new UndefinedFieldException("Unsupported fieldType " + fieldType);
        }
    }

    private static IFieldTreeObject findEpgObjHelper(String field, UIFieldDefinition def) throws UndefinedFieldException {
        if(def instanceof UIComplexFieldDefinition) {
            UIComplexFieldDefinition cdef = (UIComplexFieldDefinition)def;
            for(UIFieldDefinition child : cdef.getChildren()) {
                IFieldTreeObject childObj = findEpgObjHelper(field, child);
                if(childObj != null) {
                    return childObj;
                }
            }
        } else if (def.getXPath().equals(field)){
            return new EPGTreeObject(def);
        }
        return null;
    }

    private static TreeItem findEpgFieldTreeItem(String xpath, CriteriaType critType) throws UndefinedFieldException {
        IFieldTreeObject treeObj = findEpgObjHelper(xpath, getEpgData());
        if(treeObj == null) {
            throw new UndefinedFieldException("Couldn't locate EPG field " + xpath);
        }
        return convertToTreeItem(treeObj, critType, UiCriteriaMode.EPISODE);
    }

    public static IFieldTreeObject findObject(UIFieldType fieldType, String sectionType, String xpath, UiCriteriaMode critMode) throws UndefinedFieldException {
        switch(fieldType) {
        case EPG:
            IFieldTreeObject licObj = findEpgObjHelper(xpath, getEpgData());
            if(licObj == null) {
                throw new UndefinedFieldException("Couldn't locate EPG field " + xpath);
            }
            return licObj;
        default:
            throw new UndefinedFieldException("Unsupported fieldType " + fieldType);
        }
    }

    public static TreeItem convertToTreeItem(IFieldTreeObject treeObj, CriteriaType critType, UiCriteriaMode critMode) {
        if(treeObj instanceof AssetTreeObject) {
            TreeItem item = new TreeItem(treeObj.getSimpleDisplayName());
            item.setUserObject(treeObj);
            List<UIFieldDefinition> fields = ((AssetTreeObject) treeObj)
                    .getAssetDefinition().getRootFieldDefinition()
                    .getChildren();
            List<TreeItem> childItems = traverseFields(fields, critType, critMode, false, null, false);
            for(TreeItem childItem : childItems) {
                item.addItem(childItem);
            }
            return item;
        } else if(treeObj instanceof AssetFieldTreeObject) {
            String fileAssetPath = null;
            UIFieldDefinition def = ((AssetFieldTreeObject)treeObj).getFieldDefinition();
            if(treeObj.getAssetType().endsWith("/FILE")) {
                fileAssetPath = treeObj.getAssetType();
            }
            List<UIFieldDefinition> fields = Arrays.asList(new UIFieldDefinition[]{def});
            //it will be the first one. Trust me ;)
            return traverseFields(fields, critType, critMode, false, fileAssetPath, false).get(0);
        } else if (treeObj instanceof AssetFileTreeObject) {
            return convertFileDef(((AssetFileTreeObject)treeObj).getFileDefinition(), critType, critMode);
        } else if(treeObj instanceof LicenseTreeObject) {
            UIFieldDefinition def = ((LicenseTreeObject)treeObj).getFieldDefinition();
            return traverseFields(Arrays.asList(new UIFieldDefinition[]{def}), critType, critMode, true, null, false).get(0);
        } else if (treeObj instanceof EPGTreeObject) {
            UIFieldDefinition def = ((EPGTreeObject)treeObj).getFieldDefinition();
            if(traverseFields(Arrays.asList(new UIFieldDefinition[]{def}), critType, critMode, true, null, false).size()>0){
                return traverseFields(Arrays.asList(new UIFieldDefinition[]{def}), critType, critMode, true, null, false).get(0);
            }

        }
        return null;
    }

    /**
     * Makes an exact copy of a TreeItem.
     * 
     * @param item
     *            the item you want cloned
     * @return the new copy
     */
    public static TreeItem clone(TreeItem item) {
        TreeItem newOne = new TreeItem(item.getText());
        newOne.setUserObject(item.getUserObject());
        clone(newOne, item);
        return newOne;
    }

    /*
     * helper method for clone
     */
    private static void clone(TreeItem newOne, TreeItem oldOne) {

        for (int i = 0; i < oldOne.getChildCount(); i++) {
            TreeItem oldChild = oldOne.getChild(i);
            TreeItem newChild = new TreeItem();
            newChild.setText(oldChild.getText());
            newChild.setTitle(oldChild.getTitle());
            newChild.setUserObject(oldChild.getUserObject());
            newOne.addItem(newChild);

            if (oldChild.getChildCount() > 0) {
                clone(newChild, oldChild);
            }

        }
    }

    /**
     * performs a clone of a treeItem not copying paths with other assetTypes.
     * For example lets say you do a clone of a package. This would clone all
     * paths that have package as the assetType but would ignore the movie,
     * title, poster, ...
     * 
     * @param item
     * @return the new copy
     */
    public static TreeItem cloneRootAssetType(TreeItem item) {
        TreeItem newOne = new TreeItem(item.getText());
        newOne.setUserObject(item.getUserObject());
        cloneRootAssetType(newOne, item, ((IFieldTreeObject) item
                .getUserObject()).getAssetType());
        return newOne;
    }

    /*
     * helper method for cloneRootAssetType
     */
    private static void cloneRootAssetType(TreeItem newOne, TreeItem oldOne,
            String rootAssetType) {
        for (int i = 0; i < oldOne.getChildCount(); i++) {
            TreeItem oldChild = oldOne.getChild(i);
            if (((IFieldTreeObject) oldChild.getUserObject()).getAssetType()
                    .equals(rootAssetType)) {
                TreeItem newChild = new TreeItem();
                newChild.setText(oldChild.getText());
                newChild.setTitle(oldChild.getTitle());
                newChild.setUserObject(oldChild.getUserObject());
                newOne.addItem(newChild);

                if (oldChild.getChildCount() > 0) {
                    cloneRootAssetType(newChild, oldChild, rootAssetType);
                }
            }

        }
    }

    /**
     * performs a clone of a treeItem containing XmlTreeObjects as user objects
     * but substitutes MatchedItemTreeObjects for the user objects in the new
     * TreeItem. This is used for normalization actions.
     * 
     * @param item
     * @return the new copy
     */
    public static TreeItem cloneMatchedItemRootAssetType(TreeItem item) {
        // I put the full display name in the root TreeItem to remove ambiguity
        // of
        // what field you are looking at for Matched Items.
        TreeItem newOne = new TreeItem(
                ((IFieldTreeObject) item.getUserObject()).getFullDisplayName());
        newOne.setUserObject(new MatchedItemTreeObj((IFieldTreeObject) item
                .getUserObject(), (IFieldTreeObject) item.getUserObject()));
        cloneMatchedItemRootAssetType(newOne, item, (IFieldTreeObject) item
                .getUserObject(), ((IFieldTreeObject) item.getUserObject())
                .getAssetType());
        return newOne;
    }

    /*
     * This is the recursive helper method for cloneMatchedItemRootAssetType
     */
    private static void cloneMatchedItemRootAssetType(TreeItem newOne,
            TreeItem oldOne, IFieldTreeObject root, String rootAssetType) {
        for (int i = 0; i < oldOne.getChildCount(); i++) {
            TreeItem oldChild = oldOne.getChild(i);
            if (((IFieldTreeObject) oldChild.getUserObject()).getAssetType()
                    .equals(rootAssetType) || oldChild.getUserObject() instanceof AssetTreeObject) {
                TreeItem newChild = new TreeItem();
                newChild.setText(oldChild.getText());
                newChild.setTitle(oldChild.getTitle());
                newChild.setUserObject(new MatchedItemTreeObj(
                        (IFieldTreeObject) oldChild.getUserObject(), root));
                newOne.addItem(newChild);

                if (oldChild.getChildCount() > 0) {
                    cloneMatchedItemRootAssetType(newChild, oldChild, root, rootAssetType);
                }
            }

        }
    }
}
