package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.EPGTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.MatchedItemTreeObj;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.BooleanDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.DateDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.IUIFieldDefinitionVisitor;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFloatFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;


/**
 * This is responsible for creating the UI tree for Xpaths given an asset
 * specification
 * 
 * @author Daniel Weiner
 * 
 */
public class TypedTreeCreator {

	/**
	 * recursively traverses the list of fields anding them to the TreeItem.
	 * 
	 * @param fields
	 */
	private static List<TreeItem> traverseFields(
			List<UIFieldDefinition> fields, final CriteriaType critType, final UiCriteriaMode critMode, final UIFieldDataType dataType, final boolean includeString, final boolean isEpgData) {
		final List<TreeItem> items = new ArrayList<TreeItem>();
		for (UIFieldDefinition fieldDefn : fields) {
			fieldDefn.accept(new IUIFieldDefinitionVisitor() {
				public void visit(UIComplexFieldDefinition fieldDef) {
					List<TreeItem> children = traverseFields(fieldDef
							.getChildren(), critType, critMode, dataType, includeString, isEpgData);
					if (!fieldDef.isArtificial()) {
						IFieldTreeObject usrObj;
						if(isEpgData) {
							usrObj = new EPGTreeObject(fieldDef);
						} else {
							usrObj = new AssetFieldTreeObject(fieldDef);
						}
						if(children.size() == 1 && !fieldDef.getXPath().equals("/Fields/CustomFields") && !isEpgData) {
							items.add(children.get(0));
						} else if (children.size() > 0
								|| usrObj.supportsCriteriaType(critType, critMode)) {
							TreeItem item = new TreeItem(usrObj
									.getSimpleDisplayName());
							item.setUserObject(usrObj);
							for (TreeItem cItem : children) {
								item.addItem(cItem);
							}
							items.add(item);

						}
					} else if(children.size() > 0) {
						for(TreeItem item : children) {
							items.add(item);
						}
					}
				}

				@Override
				public void visit(UIBooleanFieldDefinition fieldDefinition) {
					visitSimpleDefinition(fieldDefinition);
				}

				@Override
				public void visit(UIIntegerFieldDefinition fieldDefinition) {
					visitSimpleDefinition(fieldDefinition);
				}

				@Override
				public void visit(UIFloatFieldDefinition fieldDefinition) {
					visitSimpleDefinition(fieldDefinition);
				}

				@Override
				public void visit(UIDateFieldDefinition fieldDefinition) {
					visitSimpleDefinition(fieldDefinition);
				}

				@Override
				public void visit(UITimeFieldDefinition fieldDefinition) {
					visitSimpleDefinition(fieldDefinition);
				}

				@Override
				public void visit(UIStringFieldDefinition fieldDefinition) {
					visitSimpleDefinition(fieldDefinition);
				}

				private void visitSimpleDefinition(
						UISimpleFieldDefinition fieldDef) {
					IFieldTreeObject usrObj;
					if(isEpgData) {
						usrObj = new EPGTreeObject(fieldDef);
					} else {
						usrObj = new AssetFieldTreeObject(fieldDef);
					}
					if (usrObj.supportsCriteriaType(critType, critMode)
							&& validDataType(dataType, usrObj.getDataType(), includeString)) {
						TreeItem item = new TreeItem(usrObj
								.getSimpleDisplayName());
						item.setUserObject(usrObj);
						items.add(item);
					}
				}
			});
		}
		return items;
	}

	public static List<TreeItem> getTreeItems(CriteriaType critType, UiCriteriaMode critMode, UIFieldDataType dataType, boolean includeString) {
		// add all asset definitions to the root of the tree
		List<TreeItem> items = new ArrayList<TreeItem>();
		if (ClientAuthorizationManager.isAuthorized("EPGManager_View")) {
			items.addAll(getEPGTreeItem(critType, critMode, TreeCreator.getEpgData(), dataType, includeString));
		}
		return items;
	}

	private static List<TreeItem> getEPGTreeItem(CriteriaType critType, UiCriteriaMode critMode,
			UIFieldDefinition def, UIFieldDataType dataType,
			boolean includeString) {
		return traverseFields(Arrays.asList(new UIFieldDefinition[] { def }),
				critType, critMode, dataType, includeString, true);
	}

	/**
	 * performs a clone of a treeItem containing XmlTreeObjects as user objects
	 * but substitutes MatchedItemTreeObjects for the user objects in the new
	 * TreeItem. This is used for normalization actions.
	 * 
	 * @param item
	 * @return the new copy or null if item is not valid for dataType
	 */
	public static TreeItem cloneMatchedItemRootAssetType(TreeItem item, UIFieldDataType dataType, boolean includeString) {
		// I put the full display name in the root TreeItem to remove ambiguity
		// of
		// what field you are looking at for Matched Items.
		IFieldTreeObject fieldObj = (IFieldTreeObject) item.getUserObject();
		
		TreeItem newOne = new TreeItem((fieldObj).getFullDisplayName());
		newOne.setUserObject(new MatchedItemTreeObj(fieldObj, fieldObj));
		//call method to fill in
		cloneMatchedItemRootAssetType(newOne, item, fieldObj, fieldObj
				.getAssetType(), dataType);
		if ((fieldObj.getDataType() == null && newOne.getChildCount() > 0)
				|| validDataType(dataType, fieldObj.getDataType(), includeString)) {
			return newOne;
		} else {
			return null;
		}
	}

	/*
	 * This is the recursive helper method for cloneMatchedItemRootAssetType
	 */
	private static void cloneMatchedItemRootAssetType(TreeItem newOne,
			TreeItem oldOne, IFieldTreeObject root, String rootAssetType, UIFieldDataType dataType) {
		for (int i = 0; i < oldOne.getChildCount(); i++) {
			TreeItem oldChild = oldOne.getChild(i);
			if (((IFieldTreeObject) oldChild.getUserObject()).getAssetType()
					.equals(rootAssetType)) {
				IFieldTreeObject usrObj = (IFieldTreeObject) oldChild
				.getUserObject();
				TreeItem newChild = new TreeItem();
				newChild.setText(oldChild.getText());
				newChild.setTitle(oldChild.getTitle());
				newChild.setUserObject(new MatchedItemTreeObj(usrObj, root));

				if (oldChild.getChildCount() > 0) {
					cloneMatchedItemRootAssetType(newChild, oldChild, root,
							rootAssetType, dataType);
				}
				// if it is an assetFieldTreeObject add a leaf node then it
				// should have a valid data type otherwise it should have
				// children for it to be added to the tree
				if ((usrObj instanceof AssetFieldTreeObject
						&& usrObj.getDataType() != null && validDataType(
						dataType, usrObj.getDataType(), true))
						|| newChild.getChildCount() > 0) {
					newOne.addItem(newChild);
				}
			}
		}
	}
	
	public static boolean validDataType(UIFieldDataType baseDataType, UIFieldDataType fieldDataType, boolean includeString) {
		if(fieldDataType == null) {
			return false;
		}
		if(includeString && fieldDataType.getName().equals(StringDataType.NAME)) {
				return true;
		}

		if (baseDataType.getName().equals(StringDataType.NAME)) {
			return fieldDataType.getName().equals(StringDataType.NAME);
		}
		if (baseDataType.getName().equals(IntegerDataType.NAME)) {
			return fieldDataType.getName().equals(IntegerDataType.NAME);
		}
		if (baseDataType.getName().equals(FloatDataType.NAME)) {
			return fieldDataType.getName().equals(FloatDataType.NAME);
		}
		if (baseDataType.getName().equals(BooleanDataType.NAME)) {
			return fieldDataType.getName().equals(BooleanDataType.NAME);
		}
		if (baseDataType.getName().equals(DateDataType.NAME)) {
			return fieldDataType.getName().equals(DateDataType.NAME);
		}
		if (baseDataType.getName().equals(TimeDataType.NAME)) {
			return fieldDataType.getName().equals(TimeDataType.NAME);
		}
		return false;
	}
}
