package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueChangeHandler;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueDeleteEvent;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueDeleteHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.PushButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;


public class ValueListRow extends HorizontalContainer {

	private static final String DEL_BUTTON = "cms_title_ui/resources/images/delete_button.gif";
	private PushButtonWidget xer;
	private SingleValueWidget value;

	public ValueListRow(SingleValueWidget value, boolean showX) {
		super();
		this.value = value;
		this.putUiTogether();
		this.setXVisible(showX);
	}

	private void putUiTogether() {
		ImageWidget image = new ImageWidget(DEL_BUTTON);
		this.xer = new PushButtonWidget(image);
		this.xer.addStyleName("small-button");
		this.add(value);
		this.add(xer);
		this.xer.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				RHSValueDeleteEvent delEvent = new RHSValueDeleteEvent(ValueListRow.this);
				fireEvent(delEvent);
			}
		});
	}
	
	public HandlerRegistration addDeleteHandler(RHSValueDeleteHandler handler) {
		return addHandler(handler, RHSValueDeleteEvent.TYPE);
	}

	public void setXVisible(boolean visible) {
		this.xer.setVisible(visible);
	}

	public String getValue() {
		return value.getValue();
	}
	
	public SingleValueWidget getValueWidget() {
		return value;
	}

	public HandlerRegistration addValueChangeHandler(RHSValueChangeHandler handler) {
		return value.addChangeHandler(handler);
	}
}
