package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import java.util.Collection;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueChangeEvent;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;



/**
 * Text box for supporting standard value entry for any type that has a
 * IRulesValidator.
 * 
 * @author dweiner
 * 
 */
public class ValueTextBox extends SingleValueWidget {

	private static final String OTHER = "PARANOID_OTHER";
	private TitleConstants myConstants = (TitleConstants) GWT
			.create(TitleConstants.class);
	private HorizontalPanel panel = new HorizontalPanel();
	private ListBox suggestedValues;
	private TextBoxWidget valueBox;
	private IRulesValidator validator;

	public ValueTextBox(IRulesValidator validator,
			Collection<UIValueOption> suggestedValues, boolean supportsOther) {
		this.validator = validator;
		buildSuggestedValues(suggestedValues, supportsOther);
		buildUI();
	}

	public ValueTextBox(IRulesValidator validator) {
		super();
		this.validator = validator;
		suggestedValues = null;
		buildUI();
	}

	public ValueTextBox(IRulesValidator validator, String value) {
		this(validator);
		setValue(value);
	}

	public ValueTextBox(IRulesValidator validator,
			Collection<UIValueOption> suggestedValues, boolean supportsOther,
			String value) {
		this(validator, suggestedValues, supportsOther);
		setValue(value);
	}

	private void buildSuggestedValues(Collection<UIValueOption> options,
			boolean supportsOther) {
		suggestedValues = new ListBox(false);
		suggestedValues.addStyleName("small-txt");
		suggestedValues.addItem("", "");
		for (UIValueOption sg : options) {

			String display = sg.getName();
			if (supportsOther && !sg.getName().equals(sg.getValue().toString())) {
				display += "(" + sg.getValue().toString() + ")";
			}
			suggestedValues.addItem(display, sg.getValue().toString());
		}
		if (supportsOther) {
			suggestedValues.addItem(myConstants.other(), ValueTextBox.OTHER);
		}
	}

	public void buildUI() {
		// TODO IMPLIMENT CHANGE LOGIC
		valueBox = new TextBoxWidget();
		valueBox.setTitle(validator.getToolTip());
		valueBox.addStyleName("small-txt");
		valueBox.addStyleName("rhs-value-textbox");
		valueBox.addKeyPressHandler(new KeyPressHandler() {

			@Override
			public void onKeyPress(KeyPressEvent event) {
				fireEvent(new RHSValueChangeEvent());
			}

		});
		valueBox.addChangeHandler(new ChangeHandler() {

			@Override
			public void onChange(ChangeEvent event) {
				valueBox.setValue(validator.normalize(valueBox.getValue()),
						false);
				validate();
				fireEvent(new RHSValueChangeEvent());

			}
		});
		if (suggestedValues != null) {
			panel.add(suggestedValues);
			valueBox.setVisible(false);
			suggestedValues.addChangeHandler(new ChangeHandler() {

				@Override
				public void onChange(ChangeEvent event) {
					valueBox.setVisible(getSuggestedValue().equals(OTHER));
					clearErrorState();
					getRidOfEmpty();
					fireEvent(new RHSValueChangeEvent());
				}

			});
		}
		panel.add(valueBox);
		setWidget(panel);
	}

	private void getRidOfEmpty() {
		if (suggestedValues.getSelectedIndex() != 0
				&& suggestedValues.getValue(0).equals("")) {
			suggestedValues.removeItem(0);
		}
	}

	private String getSuggestedValue() {
		int index = suggestedValues.getSelectedIndex();
		return suggestedValues.getValue(index);
	}

	@Override
	public boolean validate() {
		clearErrorState();
		boolean valid;
		if (suggestedValues != null && !getSuggestedValue().equals(OTHER)) {
			valid = !getSuggestedValue().equals("");
			if (!valid) {
				suggestedValues.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
				suggestedValues.setSelectedIndex(0);
			}
		} else {
			valid = !getValue().isEmpty()
					&& validator.validate(valueBox.getValue());
			if (!valid) {
				valueBox.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
			}
		}
		return valid;
	}

	private void clearErrorState() {
		valueBox.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
		if (suggestedValues != null) {
			suggestedValues.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
		}
	}

	@Override
	public void setValue(String value) {
		if (suggestedValues != null) {
			boolean found = false;
			boolean hasOther = suggestedValues.getValue(
					suggestedValues.getItemCount() - 1).equals(OTHER);
			int length = suggestedValues.getItemCount() - (hasOther ? 1 : 0);
			int i = 0;

			while (!found && i < length) {
				if (suggestedValues.getValue(i).equals(value)) {
					found = true;
					suggestedValues.setSelectedIndex(i);
				}
				i++;
			}

			if (!found && hasOther) {
				suggestedValues
						.setSelectedIndex(suggestedValues.getItemCount() - 1);
				valueBox.setValue(validator.normalize(value), false);
				validate();
				valueBox.setVisible(true);
			}
			getRidOfEmpty();
		} else {
			valueBox.setValue(validator.normalize(value), false);
			validate();
			valueBox.setVisible(true);
		}
	}

	@Override
	public String getValue() {
		if (suggestedValues != null && !getSuggestedValue().equals(OTHER)) {
			return getSuggestedValue();
		}
		return valueBox.getText();

	}
}
