package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.google.gwt.core.client.GWT;



public class FloatValidator implements IRulesValidator {

	private TitleConstants myConstants = (TitleConstants) GWT
			.create(TitleConstants.class);

	@Override
	public String normalize(String value) {
		return value;
	}

	@Override
	public boolean validate(String str) {
		char[] chars = str.toCharArray();
		int i = 0;
		boolean foundDec = false;
		boolean foundDigit = false;
		int maxCharacters = 6;

		// empty case
		if (chars.length == 0) {
			return true;
		}

		// handle signs
		if (chars[i] == '+' || chars[i] == '-') {
			maxCharacters++;
			i++;
		}

		while (i < chars.length) {
			// handle decimal
			if (chars[i] == '.') {
				// no more than one decimal
				if (foundDec) {
					return false;
				}
				maxCharacters++;
				foundDec = true;
			} else if (chars[i] < 48 || chars[i] > 57) {
				return false;
			} else {
				foundDigit = true;
			}

			if (i > maxCharacters) {
				return false;
			}
			i++;
		}
		return foundDigit;
	}

	@Override
	public String getToolTip() {
		return myConstants.validFloatTitle();
	}

}
