package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate;

/**
 * validates and normalizes values of a condition. Not to be confused with CMS
 * validation and normalization rules. They are totally different.
 * 
 * @author dweiner
 * 
 */
public interface IRulesValidator {

	/**
	 * Validate the value.
	 * 
	 * @param Value
	 *            the value to be validated
	 * @return True if the value is valid. False if it is invalid.
	 */
	boolean validate(String value);

	/**
	 * Normalize the value.
	 * 
	 * @param value
	 *            The value to be normalized.
	 * @return the normalized value.
	 */
	String normalize(String value);
	
	String getToolTip();

}
