package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleMessages;
import com.google.gwt.core.client.GWT;



public class LongValidator implements IRulesValidator {

	private TitleMessages myMessages = (TitleMessages) GWT.create(TitleMessages.class);
	private static final String maxLongString = Long.MAX_VALUE + "";
	// don't need the sign
	private static final String minLongString = (Long.MIN_VALUE + "")
			.substring(1);

	private long minValue = Long.MIN_VALUE;
	private long maxValue = Long.MAX_VALUE;

	public LongValidator() {
	}

	public LongValidator(long minValue, long maxValue) {
		setMinValue(minValue);
		setMaxValue(maxValue);
	}

	@Override
	public String normalize(String value) {
		return value;
	}

	public boolean validate(String str) {
		try {
			Long value = Long.parseLong(str);
			return (checkLongBoundaries(str)) && value <= maxValue
					&& value >= minValue;
		} catch (NumberFormatException ex) {
			return false;
		}
	}

	public void setMinValue(long minValue) {
		this.minValue = minValue;
	}

	public Long getMinValue() {
		return minValue;
	}

	public void setMaxValue(long maxValue) {
		this.maxValue = maxValue;
	}

	public Long getMaxValue() {
		return maxValue;
	}

	@Override
	public String getToolTip() {
		
		return myMessages.validLong(minValue+"", maxValue+"");
	}

	/*
	 * There are some precision issues with Longs in javascript. This method has
	 * worked in the past to prevent invalid longs from being saved. So as
	 * messed up as this method is it will live on.
	 */
	private boolean checkLongBoundaries(String str) {
		try {
			Long.parseLong(str);
		} catch (NumberFormatException ex) {
			return false;
		}
		if (str.isEmpty()) {
			return true;
		}
		String digits;
		boolean isNegative = str.startsWith("-");
		if (isNegative) {
			digits = str.substring(1);
		} else {
			digits = str;
		}

		// if there are more characters than the max number of digits return
		// false
		if (digits.length() > maxLongString.length()) {
			return false;
		}
		// if not charaters are digits in the decimal system return false
		if (!allDigit(digits)) {
			return false;
		}
		// make sure we don't exceed what a Java long can handle.
		if (digits.length() == maxLongString.length()) {
			if (isNegative) {
				return digits.compareTo(minLongString) <= 0;
			}
			return digits.compareTo(maxLongString) <= 0;
		}
		// otherwise return true
		return true;

	}

	private boolean allDigit(String str) {
		char[] chars = str.toCharArray();
		for (char c : chars) {
			if (c < 48 || c > 57) {
				return false;
			}
		}
		return true;
	}

}
