package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.google.gwt.core.client.GWT;



public class TimeValidator implements IRulesValidator {

	private TitleConstants myConstants = (TitleConstants) GWT
			.create(TitleConstants.class);

	@Override
	public String normalize(String value) {
		String[] strValues = value.split(":");
		int[] intValues = new int[3];

		if (strValues.length > 3) {
			return value;
		}

		for (int i = 0; i < strValues.length; i++) {
			String val = strValues[i];
			try {
				intValues[i] = Integer.parseInt(val);
			} catch (NumberFormatException x) {
				return value;
			}
		}

		for (int i = 2; i > 0; i--) {
			intValues[i - 1] += intValues[i] / 60;
			intValues[i] = intValues[i] % 60;
		}

		if (intValues[0] > 23 || intValues[1] > 59 || intValues[2] > 59) {
			return value;
		}

		return (padWitZero(intValues[0]) + ":" + padWitZero(intValues[1]) + ":" + padWitZero(intValues[2]));
	}

	private String padWitZero(int num) {
		if (num > 9) {
			return "" + num;
		}
		return "0" + num;
	}

	@Override
	public boolean validate(String str) {
		String[] strValues = str.split(":");
		int[] intValues = new int[3];

		if (strValues.length > 3) {
			return false;
		}

		for (int i = 0; i < strValues.length; i++) {
			String val = strValues[i];
			try {
				intValues[i] = Integer.parseInt(val);
			} catch (NumberFormatException x) {
				return false;
			}
		}

		if (intValues[0] > 23 || intValues[1] > 59 || intValues[2] > 59) {
			return false;
		}

		return true;
	}

	@Override
	public String getToolTip() {
		return myConstants.validTimeTitle();
	}

}
