/*
 * Created on Feb 22, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype;

import com.google.gwt.i18n.client.Constants;

/**
 * Interface that provides the internationalized names of the field data types
 * 
 * @author Vijay Silva
 */
public interface DataTypeNames extends Constants {

	/**
	 * The display name for the boolean field data type
	 * 
	 * @return the boolean data type name
	 */
	public String booleanName();

	/**
	 * The display name for the integer field data type
	 * 
	 * @return the integer data type name
	 */
	public String integerName();

	/**
	 * The display name for the float field data type
	 * 
	 * @return the float data type name
	 */
	public String floatName();

	/**
	 * The display name for the date field data type
	 * 
	 * @return the date data type name
	 */
	public String dateName();

	/**
	 * The display name for the time field data type
	 * 
	 * @return the time data type name
	 */
	public String timeName();

	/**
	 * The display name for the string field data type
	 * 
	 * @return the string data type name
	 */
	public String stringName();
}
