/*
 * Created on Feb 20, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype;

/**
 * UI Model class representing the 'float' data type for the field value.
 * 
 * @author Vijay Silva
 */
public class FloatDataType extends UIFieldDataType {

	/** The name of the data type */
	public static final String NAME = "float";

	/**
	 * Constructor - The float data type for UIField values
	 */
	public FloatDataType() {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return NAME;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDisplayName() {
		return (NAMES != null) ? NAMES.floatName() : getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldDataTypeVisitor visitor) {
		visitor.visit(this);
	}

}
